/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import javax.olap.OLAPException;

class ArrayNavigator {
    private Object[] a;
    private int position;

    public ArrayNavigator(Object[] a) {
        this.a = a;
        this.position = -1;
    }

    public boolean next() throws OLAPException {
        ++this.position;
        if (this.position < this.a.length) {
            return true;
        }
        this.position = this.a.length;
        return false;
    }

    public boolean previous() throws OLAPException {
        --this.position;
        if (this.position >= 0) {
            return true;
        }
        this.position = -1;
        return false;
    }

    public boolean relative(int arg0) throws OLAPException {
        this.position += arg0;
        if (this.position >= this.a.length) {
            this.position = this.a.length;
            return false;
        }
        if (this.position < 0) {
            this.position = 0;
            return false;
        }
        return true;
    }

    public boolean first() throws OLAPException {
        if (this.a.length > 0) {
            this.position = 0;
            return true;
        }
        return false;
    }

    public boolean last() throws OLAPException {
        if (this.a.length > 0) {
            this.position = this.a.length - 1;
            return true;
        }
        return false;
    }

    public boolean isBeforeFirst() {
        return this.position < 0;
    }

    public boolean isAfterLast() throws OLAPException {
        return this.position >= this.a.length;
    }

    public boolean isFirst() throws OLAPException {
        return this.position == 0;
    }

    public boolean isLast() throws OLAPException {
        return this.position == this.a.length - 1;
    }

    public void afterLast() throws OLAPException {
        this.position = this.a.length;
    }

    public void beforeFirst() throws OLAPException {
        this.position = -1;
    }

    public void setPosition(long position) throws OLAPException {
        this.position = (int)position;
    }

    public long getPosition() throws OLAPException {
        return this.position;
    }

    protected Object current() {
        return this.a[this.position];
    }
}

