/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.record.CFRuleRecord;
import org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.ConditionalFormattingTable;
import org.apache.poi.hssf.usermodel.HSSFConditionalFormatting;
import org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.Region;

public final class HSSFSheetConditionalFormatting {
    private final HSSFWorkbook _workbook;
    private final ConditionalFormattingTable _conditionalFormattingTable;

    HSSFSheetConditionalFormatting(HSSFWorkbook workbook, Sheet sheet) {
        this._workbook = workbook;
        this._conditionalFormattingTable = sheet.getConditionalFormattingTable();
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(byte comparisonOperation, String formula1, String formula2) {
        HSSFWorkbook wb = this._workbook;
        CFRuleRecord rr = CFRuleRecord.create(wb, comparisonOperation, formula1, formula2);
        return new HSSFConditionalFormattingRule(wb, rr);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(String formula) {
        HSSFWorkbook wb = this._workbook;
        CFRuleRecord rr = CFRuleRecord.create(wb, formula);
        return new HSSFConditionalFormattingRule(wb, rr);
    }

    public int addConditionalFormatting(HSSFConditionalFormatting cf) {
        CFRecordsAggregate cfraClone = cf.getCFRecordsAggregate().cloneCFAggregate();
        return this._conditionalFormattingTable.add(cfraClone);
    }

    public int addConditionalFormatting(Region[] regions, HSSFConditionalFormattingRule[] cfRules) {
        return this.addConditionalFormatting(Region.convertRegionsToCellRanges(regions), cfRules);
    }

    public int addConditionalFormatting(CellRangeAddress[] regions, HSSFConditionalFormattingRule[] cfRules) {
        if (regions == null) {
            throw new IllegalArgumentException("regions must not be null");
        }
        if (cfRules == null) {
            throw new IllegalArgumentException("cfRules must not be null");
        }
        if (cfRules.length == 0) {
            throw new IllegalArgumentException("cfRules must not be empty");
        }
        if (cfRules.length > 3) {
            throw new IllegalArgumentException("Number of rules must not exceed 3");
        }
        CFRuleRecord[] rules = new CFRuleRecord[cfRules.length];
        for (int i = 0; i != cfRules.length; ++i) {
            rules[i] = cfRules[i].getCfRuleRecord();
        }
        CFRecordsAggregate cfra = new CFRecordsAggregate(regions, rules);
        return this._conditionalFormattingTable.add(cfra);
    }

    public int addConditionalFormatting(CellRangeAddress[] regions, HSSFConditionalFormattingRule rule1) {
        return this.addConditionalFormatting(regions, new HSSFConditionalFormattingRule[]{rule1});
    }

    public int addConditionalFormatting(CellRangeAddress[] regions, HSSFConditionalFormattingRule rule1, HSSFConditionalFormattingRule rule2) {
        return this.addConditionalFormatting(regions, new HSSFConditionalFormattingRule[]{rule1, rule2});
    }

    public HSSFConditionalFormatting getConditionalFormattingAt(int index) {
        CFRecordsAggregate cf = this._conditionalFormattingTable.get(index);
        if (cf == null) {
            return null;
        }
        return new HSSFConditionalFormatting(this._workbook, cf);
    }

    public int getNumConditionalFormattings() {
        return this._conditionalFormattingTable.size();
    }

    public void removeConditionalFormatting(int index) {
        this._conditionalFormattingTable.remove(index);
    }
}

