/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.JNumberComboBox;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.NodeList;

public class Misc {
    public static FileObject createFolders(String path) throws IOException {
        FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
        StringTokenizer st = new StringTokenizer(path, "/");
        System.out.println("Creating dir: " + path);
        FileObject nextDir = root;
        while (st.hasMoreTokens()) {
            String nextDirName = st.nextToken();
            if (nextDirName.length() == 0) continue;
            System.out.println("Creating subir: " + nextDirName);
            if (nextDir == null) continue;
            FileObject newDir = nextDir.getFileObject(nextDirName);
            if (newDir == null) {
                newDir = nextDir.createFolder(nextDirName);
            }
            nextDir = newDir;
        }
        return nextDir;
    }

    public static String getDataFolderPath(DataFolder targetFolder) {
        if (targetFolder == null) {
            return null;
        }
        FileObject file = targetFolder.getPrimaryFile();
        File f = FileUtil.toFile((FileObject)file);
        String path = f.getPath();
        return path;
    }

    public static Window getParentWindow(Component c) {
        if (c == null) {
            return Misc.getMainWindow();
        }
        return SwingUtilities.getWindowAncestor(c);
    }

    public static Window getMainWindow() {
        return Misc.getMainFrame();
    }

    public static Frame getMainFrame() {
        WindowManager w = (WindowManager)Lookup.getDefault().lookup(WindowManager.class);
        return w == null ? null : w.getMainWindow();
    }

    public static String formatString(String s, Object[] params) {
        return MessageFormat.format(s, params);
    }

    public static Image loadImageFromResources(String filename) {
        return Misc.loadImageFromResources(filename, Misc.class.getClassLoader());
    }

    public static Image loadImageFromResources(String filename, ClassLoader cl) {
        try {
            if (!filename.startsWith("/")) {
                filename = "/" + filename;
            }
            return new ImageIcon(cl.getResource(filename)).getImage();
        }
        catch (Exception ex) {
            System.out.println("Exception loading resource: " + filename);
            return null;
        }
    }

    public static Image loadImageFromFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image img = tk.createImage(path);
            try {
                MediaTracker mt = new MediaTracker(new JPanel());
                mt.addImage(img, 0);
                mt.waitForID(0);
            }
            catch (Exception ex) {
                return null;
            }
            return img;
        }
        return null;
    }

    public static void msg(String string) {
        Logger.global.log(Level.INFO, string);
        Handler[] handlres = Logger.global.getHandlers();
        for (int i = 0; i < handlres.length; ++i) {
            handlres[i].flush();
        }
    }

    public static void msg(String string, Throwable t) {
        Logger.global.log(Level.SEVERE, string, t);
        Handler[] handlres = Logger.global.getHandlers();
        for (int i = 0; i < handlres.length; ++i) {
            handlres[i].flush();
        }
    }

    public static String readPCDATA(org.w3c.dom.Node textNode) {
        return Misc.readPCDATA(textNode, true);
    }

    public static String readPCDATA(org.w3c.dom.Node textNode, boolean trim) {
        NodeList list_child = textNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            short nt;
            org.w3c.dom.Node child_child = list_child.item(ck);
            org.w3c.dom.Node ns = child_child.getNextSibling();
            if (ns != null) {
                child_child = ns;
            }
            if ((nt = child_child.getNodeType()) != 4 && nt != 3) continue;
            if (trim) {
                return child_child.getNodeValue().trim();
            }
            return child_child.getNodeValue();
        }
        return "";
    }

    public static String nvl(Object obj, String def) {
        if (obj == null) {
            return def;
        }
        return "" + obj;
    }

    public static Locale getLocaleFromString(String localeName) {
        return Misc.getLocaleFromString(localeName, Locale.getDefault());
    }

    public static String toHTML(String s) {
        s = Misc.string_replace("&gt;", ">", s);
        s = Misc.string_replace("&lt;", "<", s);
        s = Misc.string_replace("&nbsp;", " ", s);
        s = Misc.string_replace("&nbsp;&nbsp;&nbsp;&nbsp;", "\t", s);
        s = Misc.string_replace("<br>", "\n", s);
        return s;
    }

    public static Locale getLocaleFromString(String localeName, Locale defaultLocale) {
        String language = "";
        String country = "";
        String variant = "";
        Locale locale = defaultLocale;
        if (localeName == null || localeName.length() == 0) {
            return locale;
        }
        if (localeName.startsWith("_")) {
            localeName = localeName.substring(1);
        }
        if (localeName.indexOf("_") > 0) {
            language = localeName.substring(0, localeName.indexOf("_"));
            if ((localeName = localeName.substring(localeName.indexOf("_") + 1)).indexOf("_") > 0) {
                country = localeName.substring(0, localeName.indexOf("_"));
                if ((localeName = localeName.substring(localeName.indexOf("_") + 1)).indexOf("_") > 0) {
                    variant = localeName.substring(0, localeName.indexOf("_"));
                    localeName = localeName.substring(localeName.indexOf("_") + 1);
                } else {
                    variant = localeName;
                }
            } else {
                country = localeName;
            }
        } else {
            language = localeName;
        }
        locale = new Locale(language, country, variant);
        return locale;
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = string + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = string + s3.substring(pos_i);
        return string;
    }

    public static void selectTextAndFocusArea(JComponent expArea) {
        if (expArea == null) {
            return;
        }
        if (expArea instanceof JTextComponent) {
            ((JTextComponent)expArea).setSelectionStart(0);
            ((JTextComponent)expArea).setSelectionEnd(((JTextComponent)expArea).getText().length());
            ((JTextComponent)expArea).setBorder(new LineBorder(Color.RED.darker(), 2));
        } else if (expArea instanceof JEditorPane) {
            ((JEditorPane)expArea).setSelectionStart(0);
            ((JEditorPane)expArea).setSelectionEnd(((JTextComponent)expArea).getText().length());
            ((JEditorPane)expArea).setBorder(new LineBorder(Color.RED.darker(), 2));
        }
        expArea.requestFocusInWindow();
    }

    public static String getJRFieldType(String type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("java.lang.Byte") || type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("java.lang.Integer") || type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("java.lang.Long") || type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("java.lang.Double") || type.equals("double")) {
            return "java.lang.Double";
        }
        if (type.equals("java.lang.Float") || type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("java.lang.Short") || type.equals("short")) {
            return "java.lang.Short";
        }
        if (type.startsWith("[")) {
            return "java.lang.Object";
        }
        return type;
    }

    public static boolean saveSQLQuery(String query) {
        return Misc.saveSQLQuery(query, null);
    }

    public static boolean saveSQLQuery(String query, Component c) {
        if (c == null) {
            c = Misc.getMainWindow();
        }
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".sql") || filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "SQL query (*.sql, *.txt)";
            }
        });
        if (jfc.showSaveDialog(Misc.getMainWindow()) == 0) {
            try {
                String fileName = jfc.getSelectedFile().getName();
                if (fileName.indexOf(".") < 0) {
                    fileName = fileName + ".sql";
                }
                File f = new File(jfc.getSelectedFile().getParent(), fileName);
                FileWriter fw = new FileWriter(f);
                fw.write(query);
                fw.close();
                return true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error saving the query: " + ex.getMessage(), "Error", 0);
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static String loadSQLQuery() {
        return Misc.loadSQLQuery(null);
    }

    public static String loadSQLQuery(Component c) {
        if (c == null) {
            c = Misc.getMainWindow();
        }
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".sql") || filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "SQL query (*.sql, *.txt)";
            }
        });
        if (jfc.showOpenDialog(Misc.getMainWindow()) == 0) {
            try {
                FileReader fr = new FileReader(jfc.getSelectedFile());
                StringBuffer sb = new StringBuffer();
                char[] cbuf = new char[1024];
                int i = fr.read(cbuf);
                while (i > 0) {
                    sb.append(cbuf, 0, i);
                    i = fr.read(cbuf);
                }
                fr.close();
                return sb.toString();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error loading the query: " + ex.getMessage(), "Error", 0);
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static String getJdbcTypeClass(ResultSetMetaData rsmd, int t) {
        String cls = "java.lang.Object";
        try {
            cls = rsmd.getColumnClassName(t);
            cls = Misc.getJRFieldType(cls);
        }
        catch (Exception ex) {
            try {
                int type = rsmd.getColumnType(t);
                switch (type) {
                    case -7: 
                    case -6: {
                        cls = "java.lang.Byte";
                        break;
                    }
                    case 5: {
                        cls = "java.lang.Short";
                        break;
                    }
                    case 4: {
                        cls = "java.lang.Integer";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        cls = "java.lang.Double";
                        break;
                    }
                    case 1: 
                    case 12: {
                        cls = "java.lang.String";
                        break;
                    }
                    case -5: {
                        cls = "java.lang.Long";
                        break;
                    }
                    case 91: {
                        cls = "java.util.Date";
                        break;
                    }
                    case 92: {
                        cls = "java.sql.Time";
                        break;
                    }
                    case 93: {
                        cls = "java.sql.Timestamp";
                    }
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        return cls;
    }

    public static void ensurePathIsSelected(TreePath treePath, JTree jTree) {
        if (jTree == null || treePath == null) {
            return;
        }
        TreePath[] selectedPaths = jTree.getSelectionPaths();
        for (int i = 0; selectedPaths != null && i < selectedPaths.length; ++i) {
            if (!selectedPaths[i].equals(treePath)) continue;
            return;
        }
        jTree.setSelectionPath(treePath);
    }

    public static String removeSlashesString(String str) {
        if (str == null) {
            return str;
        }
        String newStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' && str.length() > i + 1) {
                char c2 = str.charAt(++i);
                switch (c2) {
                    case 'n': {
                        newStr = newStr + "\n";
                        break;
                    }
                    case 'r': {
                        newStr = newStr + "\r";
                        break;
                    }
                    case 't': {
                        newStr = newStr + "\t";
                        break;
                    }
                    case '\\': {
                        newStr = newStr + "\\";
                        break;
                    }
                    default: {
                        newStr = newStr + c;
                        newStr = newStr + c2;
                        break;
                    }
                }
                continue;
            }
            newStr = newStr + c;
        }
        return newStr;
    }

    public static String addSlashesString(String str) {
        if (str == null) {
            return str;
        }
        String newStr = "";
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    newStr = newStr + "\\n";
                    continue block6;
                }
                case '\r': {
                    newStr = newStr + "\\r";
                    continue block6;
                }
                case '\t': {
                    newStr = newStr + "\\t";
                    continue block6;
                }
                case '\\': {
                    newStr = newStr + "\\\\";
                    continue block6;
                }
                default: {
                    newStr = newStr + c;
                }
            }
        }
        return newStr;
    }

    public static void updateComboBox(JComboBox comboBox, List newItems) {
        Misc.updateComboBox(comboBox, newItems, false);
    }

    public static void updateComboBox(JComboBox comboBox, List newItems, boolean addNullEntry) {
        Object itemSelected = null;
        if (comboBox.getSelectedIndex() >= 0) {
            itemSelected = comboBox.getSelectedItem();
        }
        Vector items = new Vector(newItems.size(), 1);
        boolean selected = false;
        boolean foundNullItem = false;
        Iterator e = newItems.iterator();
        int selectedIndex = -1;
        int currentelement = 0;
        while (e.hasNext()) {
            Object item = e.next();
            items.add(item);
            if (item == itemSelected) {
                selectedIndex = currentelement;
            }
            if (item.equals("")) {
                foundNullItem = true;
            }
            ++currentelement;
        }
        if (addNullEntry) {
            if (!foundNullItem) {
                items.add(0, "");
            }
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
        }
        comboBox.setModel(new DefaultComboBoxModel(items));
        comboBox.setSelectedIndex(selectedIndex);
    }

    public static void setComboboxSelectedTagValue(JComboBox comboBox, Object itemValue) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object val = comboBox.getItemAt(i);
            if (!(val instanceof Tag) || (val != null || itemValue != null) && ((Tag)val).getValue() != itemValue && (((Tag)val).getValue() == null || !((Tag)val).getValue().equals(itemValue))) continue;
            comboBox.setSelectedIndex(i);
            return;
        }
        if (comboBox.isEditable() && itemValue != null && itemValue instanceof String) {
            comboBox.setSelectedItem(itemValue);
        }
    }

    public static String changeFileExtension(String filename, String newExtension) {
        if (!newExtension.startsWith(".")) {
            newExtension = "." + newExtension;
        }
        if (filename == null || filename.length() == 0) {
            return newExtension;
        }
        int index = filename.lastIndexOf(".");
        if (index >= 0) {
            filename = filename.substring(0, index);
        }
        filename = filename + newExtension;
        return filename;
    }

    public static String getClassPath() {
        String cp = System.getProperty("java.class.path");
        if (IReportManager.getInstance() != null) {
            List<String> cp_v = IReportManager.getInstance().getClasspath();
            for (String s : cp_v) {
                cp = cp + File.pathSeparator + s;
            }
        }
        return cp;
    }

    public static String getExpressionText(JRExpression exp) {
        if (exp == null) {
            return "";
        }
        if (exp.getText() == null) {
            return "";
        }
        return exp.getText();
    }

    public static JRDesignExpression createExpression(String className, String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName(className != null ? className : "java.lang.Object");
        exp.setText(text);
        return exp;
    }

    public static void showErrorMessage(String errorMsg, String title, Throwable theException) {
        final JXErrorPane pane = new JXErrorPane();
        String[] lines = errorMsg.split("\r\n|\n|\r");
        String shortMessage = errorMsg;
        if (lines.length > 4) {
            shortMessage = "";
            for (int i = 0; i < 4; ++i) {
                shortMessage = shortMessage + lines[i] + "\n";
            }
            shortMessage = shortMessage.trim() + "\n...";
        }
        final ErrorInfo ei = new ErrorInfo(title, shortMessage, null, null, theException, null, null);
        Runnable r = new Runnable(){

            public void run() {
                pane.setErrorInfo(ei);
                JXErrorPane.showDialog((Component)Misc.getMainWindow(), (JXErrorPane)pane);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    public static File findStartingDirectory() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            File f;
            DataObject d = (DataObject)nodes[i].getCookie(DataObject.class);
            if (d == null || (f = FileUtil.toFile((FileObject)d.getPrimaryFile())) == null) continue;
            if (f.isFile()) {
                f = f.getParentFile();
            }
            return f;
        }
        String dir = IReportManager.getPreferences().get("CURRENT_DIRECTORY", null);
        if (dir != null) {
            return new File(dir);
        }
        return new File(System.getProperty("user.home"));
    }

    public static boolean setComboBoxText(boolean firstTime, String value, JComboBox comboField) {
        if (!firstTime && !Misc.nvl(comboField.getSelectedItem(), "").equalsIgnoreCase(value)) {
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            boolean found = false;
            for (int i = 0; i < comboField.getItemCount(); ++i) {
                String s = (String)comboField.getItemAt(i);
                if (s == null || !s.equalsIgnoreCase(value)) continue;
                comboField.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found) {
                comboField.addItem(value);
                comboField.setSelectedItem(value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static boolean setElementComboNumber(boolean firstTime, double value, JNumberComboBox numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setSetting(true);
            numberField.setSelectedItem("");
            numberField.setSetting(false);
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static String loadExpression(Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "Text file (*.txt)";
            }
        });
        if (jfc.showOpenDialog(c) == 0) {
            try {
                FileReader fr = new FileReader(jfc.getSelectedFile());
                StringBuffer sb = new StringBuffer();
                char[] cbuf = new char[1024];
                int i = fr.read(cbuf);
                while (i > 0) {
                    sb.append(cbuf, 0, i);
                    i = fr.read(cbuf);
                }
                fr.close();
                return sb.toString();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(c, I18n.getString("Misc.loadingExpression.error.text", new Object[]{ex.getMessage()}), I18n.getString("Misc.loadingExpression.error.title", (Object)"Error"), 0);
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean saveExpression(String expression, Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".txt") || file.isDirectory();
            }

            public String getDescription() {
                return "Text file (*.txt)";
            }
        });
        if (jfc.showSaveDialog(c) == 0) {
            try {
                String fileName = jfc.getSelectedFile().getName();
                if (fileName.indexOf(".") < 0) {
                    fileName = fileName + ".txt";
                }
                File f = new File(jfc.getSelectedFile().getParent(), fileName);
                FileWriter fw = new FileWriter(f);
                fw.write(expression);
                fw.close();
                return true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(c, I18n.getString("Misc.savingExpression.error.text", new Object[]{ex.getMessage()}), I18n.getString("Misc.savingExpression.error.title", (Object)"Error"), 0);
                ex.printStackTrace();
            }
        }
        return false;
    }
}

