/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IRFont;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.outline.nodes.StyleChildren;
import com.jaspersoft.ireport.designer.sheet.JRLineBoxProperty;
import com.jaspersoft.ireport.designer.sheet.JRPenProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.StylePatternProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class AbstractStyleNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRBaseStyle style = null;

    public AbstractStyleNode(JasperDesign jd, JRDesignStyle style, Lookup doLkp) {
        super((Children)new StyleChildren(jd, style, doLkp), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, style})}));
        this.jd = jd;
        this.style = style;
        this.init();
    }

    public AbstractStyleNode(JasperDesign jd, JRBaseStyle style, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, style})}));
        this.jd = jd;
        this.style = style;
        this.init();
    }

    private void init() {
        this.setDisplayName(this.style.getName());
        super.setName(this.style.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/style-16.png");
        this.style.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)this.style.getLinePen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        JRBaseLineBox baseBox = (JRBaseLineBox)this.style.getLineBox();
        baseBox.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getTopPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getBottomPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getLeftPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getRightPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.getStyle().getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new ModeProperty(this.getStyle()));
        set.put((Node.Property)new ForecolorProperty(this.getStyle()));
        set.put((Node.Property)new BackcolorProperty(this.getStyle()));
        set.put((Node.Property)new PaddingAndBordersProperty(this.getStyle()));
        JRPenProperty penProp = new JRPenProperty(this.getStyle().getLinePen(), (JRPenContainer)this.getStyle());
        set.put((Node.Property)penProp);
        set.put((Node.Property)new FillProperty(this.getStyle()));
        set.put((Node.Property)new RadiusProperty(this.getStyle()));
        set.put((Node.Property)new ScaleImageProperty(this.getStyle()));
        set.put((Node.Property)new HorizontalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new VerticalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new RotationProperty(this.getStyle()));
        set.put((Node.Property)new LineSpacingProperty(this.getStyle()));
        set.put((Node.Property)new StyledTextProperty(this.getStyle()));
        set.put((Node.Property)new FontNameProperty(this.getStyle()));
        set.put((Node.Property)new FontSizeProperty(this.getStyle()));
        set.put((Node.Property)new BoldProperty(this.getStyle()));
        set.put((Node.Property)new ItalicProperty(this.getStyle()));
        set.put((Node.Property)new UnderlineProperty(this.getStyle()));
        set.put((Node.Property)new StrikeThroughProperty(this.getStyle()));
        set.put((Node.Property)new PdfFontNameProperty(this.getStyle()));
        set.put((Node.Property)new PdfEmbeddedProperty(this.getStyle()));
        set.put((Node.Property)new PdfEncodingProperty(this.getStyle()));
        set.put((Node.Property)new StylePatternProperty(this.getStyle()));
        set.put((Node.Property)new BlankWhenNullProperty(this.getStyle()));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getStyle().getName());
            this.setDisplayName(this.getStyle().getName());
        } else if (evt.getPropertyName().equals("lineColor") || evt.getPropertyName().equals("lineStyle") || evt.getPropertyName().equals("lineWidth")) {
            if (ModelUtils.containsProperty(this.getPropertySets(), "pen")) {
                this.firePropertyChange("pen", evt.getOldValue(), evt.getNewValue());
            }
            if (ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
                this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
            }
        } else if ((evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding")) && ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
            this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public JRBaseStyle getStyle() {
        return this.style;
    }

    public void setStyle(JRBaseStyle style) {
        this.style = style;
    }

    public static final class PaddingAndBordersProperty
    extends JRLineBoxProperty {
        private final JRBaseStyle style;

        public PaddingAndBordersProperty(JRBaseStyle style) {
            super((JRBoxContainer)style);
            this.style = style;
        }
    }

    public static final class BlankWhenNullProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;

        public BlankWhenNullProperty(JRBaseStyle style) {
            super("blankWhenNull", Boolean.class, I18n.getString("AbstractStyleNode.Property.Blank_When_Null"), I18n.getString("AbstractStyleNode.Property.Blankdetail"));
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isBlankWhenNull();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnBlankWhenNull();
                Boolean newValue = (Boolean)val;
                this.style.setBlankWhenNull(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "BlankWhenNull", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnBlankWhenNull() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class PdfEncodingProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;
        PropertyEditor editor = null;

        public PdfEncodingProperty(JRBaseStyle style) {
            super("pdfEncoding", String.class, I18n.getString("AbstractStyleNode.Property.Pdf_Encoding"), I18n.getString("AbstractStyleNode.Property.Pdf_Encoding"));
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getPdfEncoding();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                if ((val + "").trim().length() == 0) {
                    val = null;
                }
                String oldValue = this.style.getOwnPdfEncoding();
                String newValue = (String)val;
                this.style.setPdfEncoding(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "PdfEncoding", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnPdfEncoding() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> encodings = new ArrayList<Tag>();
                encodings.add(new Tag("Cp1250", "CP1250 (Central European)"));
                encodings.add(new Tag("Cp1251", "CP1251 (Cyrillic)"));
                encodings.add(new Tag("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
                encodings.add(new Tag("Cp1253", "CP1253 (Greek)"));
                encodings.add(new Tag("Cp1254", "CP1254 (Turkish)"));
                encodings.add(new Tag("Cp1255", "CP1255 (Hebrew)"));
                encodings.add(new Tag("Cp1256", "CP1256 (Arabic)"));
                encodings.add(new Tag("Cp1257", "CP1257 (Baltic)"));
                encodings.add(new Tag("Cp1258", "CP1258 (Vietnamese)"));
                encodings.add(new Tag("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
                encodings.add(new Tag("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
                encodings.add(new Tag("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
                encodings.add(new Tag("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
                encodings.add(new Tag("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
                encodings.add(new Tag("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
                encodings.add(new Tag("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
                encodings.add(new Tag("Identity-H", "Identity-H (Unicode with horizontal writing)"));
                encodings.add(new Tag("Identity-V", "Identity-V (Unicode with vertical writing)"));
                this.editor = new ComboBoxPropertyEditor(true, encodings);
            }
            return this.editor;
        }
    }

    private static final class PdfFontNameProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;
        PropertyEditor editor = null;

        public PdfFontNameProperty(JRBaseStyle style) {
            super("pdfFontName", String.class, I18n.getString("AbstractStyleNode.Property.Pdf_Font_name"), I18n.getString("AbstractStyleNode.Property.Pdf_Font_name"));
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", true);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getPdfFontName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.style.getOwnPdfFontName();
                String newValue = (String)val;
                this.style.setPdfFontName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "PdfFontName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnPdfFontName() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                classes.add(new Tag("Helvetica"));
                classes.add(new Tag("Helvetica-Bold"));
                classes.add(new Tag("Helvetica-BoldOblique"));
                classes.add(new Tag("Helvetica-Oblique"));
                classes.add(new Tag("Courier"));
                classes.add(new Tag("Courier-Bold"));
                classes.add(new Tag("Courier-BoldOblique"));
                classes.add(new Tag("Courier-Oblique"));
                classes.add(new Tag("Symbol"));
                classes.add(new Tag("Times-Roman"));
                classes.add(new Tag("Times-Bold"));
                classes.add(new Tag("Times-BoldItalic"));
                classes.add(new Tag("Times-Italic"));
                classes.add(new Tag("ZapfDingbats"));
                classes.add(new Tag("STSong-Light"));
                classes.add(new Tag("MHei-Medium"));
                classes.add(new Tag("MSung-Light"));
                classes.add(new Tag("HeiseiKakuGo-W5"));
                classes.add(new Tag("HeiseiMin-W3"));
                classes.add(new Tag("HYGoThic-Medium"));
                classes.add(new Tag("HYSMyeongJo-Medium"));
                List<IRFont> fonts = IReportManager.getInstance().getIRFonts();
                for (IRFont f : fonts) {
                    classes.add(new Tag(f.getFile(), f.toString()));
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    private static final class FontSizeProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;
        PropertyEditor editor = null;

        public FontSizeProperty(JRBaseStyle style) {
            super("fontSize", Integer.class, I18n.getString("AbstractStyleNode.Property.Size"), I18n.getString("AbstractStyleNode.Property.Size"));
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getFontSize();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && !(val instanceof Integer)) {
                try {
                    val = new Integer(val + "");
                }
                catch (Exception ex) {
                    return;
                }
            }
            if (val == null || val instanceof Integer) {
                Integer oldValue = this.style.getOwnFontSize();
                Integer newValue = (Integer)val;
                this.style.setFontSize(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "FontSize", Integer.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnFontSize() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                int i = 6;
                while (i < 100) {
                    classes.add(new Tag(new Integer(i), "" + i));
                    if (i < 16) {
                        ++i;
                        continue;
                    }
                    if (i < 32) {
                        i += 2;
                        continue;
                    }
                    if (i < 48) {
                        i += 4;
                        continue;
                    }
                    if (i < 72) {
                        i += 6;
                        continue;
                    }
                    i += 8;
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    private static final class FontNameProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;
        PropertyEditor editor = null;

        public FontNameProperty(JRBaseStyle style) {
            super("fontName", String.class, I18n.getString("AbstractStyleNode.Property.Font_name"), I18n.getString("Font_name"));
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getFontName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.style.getOwnFontName();
                String newValue = (String)val;
                this.style.setFontName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "FontName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnFontName() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    classes.add(new Tag(name));
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    public static final class PdfEmbeddedProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;

        public PdfEmbeddedProperty(JRBaseStyle style) {
            super("pdfEmbedded", Boolean.class, I18n.getString("AbstractStyleNode.Property.Pdf_Embedded"), "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isPdfEmbedded();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnPdfEmbedded();
                Boolean newValue = (Boolean)val;
                this.style.setPdfEmbedded(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "PdfEmbedded", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnPdfEmbedded() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class UnderlineProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;

        public UnderlineProperty(JRBaseStyle style) {
            super("underline", Boolean.class, I18n.getString("AbstractStyleNode.Property.Underline"), "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isUnderline();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnUnderline();
                Boolean newValue = (Boolean)val;
                this.style.setUnderline(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Underline", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnUnderline() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class StrikeThroughProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;

        public StrikeThroughProperty(JRBaseStyle style) {
            super("strikeThrough", Boolean.class, I18n.getString("AbstractStyleNode.Property.Strike_Through"), "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isStrikeThrough();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnStrikeThrough();
                Boolean newValue = (Boolean)val;
                this.style.setStrikeThrough(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "StrikeThrough", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnStrikeThrough() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class ItalicProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;

        public ItalicProperty(JRBaseStyle style) {
            super("italic", Boolean.class, I18n.getString("AbstractStyleNode.Property.Italic"), "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isItalic();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnItalic();
                Boolean newValue = (Boolean)val;
                this.style.setItalic(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Italic", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnItalic() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class BoldProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;

        public BoldProperty(JRBaseStyle style) {
            super("bold", Boolean.class, I18n.getString("AbstractStyleNode.Property.Bold"), "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isBold();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnBold();
                Boolean newValue = (Boolean)val;
                this.style.setBold(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Bold", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnBold() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class StyledTextProperty
    extends PropertySupport.ReadWrite {
        private final JRBaseStyle style;

        public StyledTextProperty(JRBaseStyle style) {
            super("isStyledText", Boolean.class, I18n.getString("AbstractStyleNode.Property.Is_Styled_Text"), I18n.getString("AbstractStyleNode.Property.StyleTextDetail"));
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isStyledText();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnStyledText();
                Boolean newValue = (Boolean)val;
                this.style.setStyledText(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "StyledText", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnStyledText() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class LineSpacingProperty
    extends PropertySupport {
        private final JRBaseStyle style;
        private ComboBoxPropertyEditor editor;

        public LineSpacingProperty(JRBaseStyle style) {
            super("lineSpacing", Byte.class, I18n.getString("AbstractStyleNode.Property.Line_Spacing"), I18n.getString("AbstractStyleNode.Property.LSDetail"), true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(0), I18n.getString("AbstractStyleNode.Property.Single")));
                l.add(new Tag(new Byte(1), I18n.getString("AbstractStyleNode.Property.1-5")));
                l.add(new Tag(new Byte(2), I18n.getString("AbstractStyleNode.Property.Double")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getLineSpacing();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnLineSpacing();
                Byte newValue = (Byte)val;
                this.style.setLineSpacing(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "LineSpacing", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnLineSpacing() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class RotationProperty
    extends PropertySupport {
        private final JRBaseStyle style;
        private ComboBoxPropertyEditor editor;

        public RotationProperty(JRBaseStyle style) {
            super("rotation", Byte.class, I18n.getString("AbstractStyleNode.Property.Rotation"), I18n.getString("AbstractStyleNode.Property.RotationDetail"), true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(0), I18n.getString("AbstractStyleNode.Property.None")));
                l.add(new Tag(new Byte(1), I18n.getString("AbstractStyleNode.Property.Left")));
                l.add(new Tag(new Byte(2), I18n.getString("AbstractStyleNode.Property.Right")));
                l.add(new Tag(new Byte(3), I18n.getString("AbstractStyleNode.Property.Upside_Down")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getRotation();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnRotation();
                Byte newValue = (Byte)val;
                this.style.setRotation(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Rotation", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnRotation() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class VerticalAlignmentProperty
    extends PropertySupport {
        private final JRBaseStyle style;
        private ComboBoxPropertyEditor editor;

        public VerticalAlignmentProperty(JRBaseStyle style) {
            super("verticalAlignment", Byte.class, I18n.getString("AbstractStyleNode.Property.Vertical_Alignment"), I18n.getString("AbstractStyleNode.Property.VerticalDetail"), true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(1), I18n.getString("AbstractStyleNode.Property.Left")));
                l.add(new Tag(new Byte(2), I18n.getString("AbstractStyleNode.Property.Center")));
                l.add(new Tag(new Byte(3), I18n.getString("AbstractStyleNode.Property.Right")));
                l.add(new Tag(new Byte(4), I18n.getString("AbstractStyleNode.Property.Justified")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getVerticalAlignment();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnVerticalAlignment();
                Byte newValue = (Byte)val;
                this.style.setVerticalAlignment(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "VerticalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnVerticalAlignment() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class HorizontalAlignmentProperty
    extends PropertySupport {
        private final JRBaseStyle style;
        private ComboBoxPropertyEditor editor;

        public HorizontalAlignmentProperty(JRBaseStyle style) {
            super("horizontalAlignment", Byte.class, I18n.getString("AbstractStyleNode.Property.Horizontal_Alignment"), I18n.getString("AbstractStyleNode.Property.HorizDetail"), true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(1), I18n.getString("AbstractStyleNode.Property.Left")));
                l.add(new Tag(new Byte(2), I18n.getString("AbstractStyleNode.Property.Center")));
                l.add(new Tag(new Byte(3), I18n.getString("AbstractStyleNode.Property.Right")));
                l.add(new Tag(new Byte(4), I18n.getString("AbstractStyleNode.Property.Justified")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getHorizontalAlignment();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnHorizontalAlignment();
                Byte newValue = (Byte)val;
                this.style.setHorizontalAlignment(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "HorizontalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnHorizontalAlignment() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class ScaleImageProperty
    extends PropertySupport {
        private final JRBaseStyle style;
        private ComboBoxPropertyEditor editor;

        public ScaleImageProperty(JRBaseStyle style) {
            super("scaleImage", Byte.class, I18n.getString("AbstractStyleNode.Property.Scale"), I18n.getString("AbstractStyleNode.Property.Scaledetail"), true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(1), I18n.getString("AbstractStyleNode.Property.Clip")));
                l.add(new Tag(new Byte(2), I18n.getString("AbstractStyleNode.Property.Fill_Frame")));
                l.add(new Tag(new Byte(3), I18n.getString("AbstractStyleNode.Property.Retain_Shape")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getScaleImage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnScaleImage();
                Byte newValue = (Byte)val;
                this.style.setScaleImage(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "ScaleImage", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnScaleImage() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class RadiusProperty
    extends PropertySupport {
        private final JRBaseStyle style;

        public RadiusProperty(JRBaseStyle style) {
            super("radius", Integer.class, I18n.getString("RadiusPropertyRadius.Property.Radius"), I18n.getString("RadiusPropertyRadius.Property.Radiusdetail"), true, true);
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getRadius();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Integer) {
                Integer oldValue = this.style.getOwnRadius();
                Integer newValue = (Integer)val;
                if (newValue < 0) {
                    IllegalArgumentException iae = this.annotateException(I18n.getString("RadiusPropertyRadius.Property.Message"));
                    throw iae;
                }
                this.style.setRadius(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Radius", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }

        public boolean isDefaultValue() {
            return this.style.getOwnRadius() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class FillProperty
    extends PropertySupport {
        private final JRBaseStyle style;
        private ComboBoxPropertyEditor editor;

        public FillProperty(JRBaseStyle style) {
            super("fill", Byte.class, I18n.getString("AbstractStyleNode.Property.Fill"), I18n.getString("AbstractStyleNode.Property.Fill"), true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(1), I18n.getString("AbstractStyleNode.Property.Solid")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getFill();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnFill();
                Byte newValue = (Byte)val;
                this.style.setFill(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Fill", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnFill() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class BackcolorProperty
    extends PropertySupport.ReadWrite {
        JRBaseStyle style;

        public BackcolorProperty(JRBaseStyle style) {
            super("backcolor", Color.class, I18n.getString("AbstractStyleNode.Property.Backcolor"), I18n.getString("AbstractStyleNode.Property.Backcolordetail"));
            this.style = null;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getBackcolor();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Color) {
                Color oldValue = this.style.getOwnBackcolor();
                Color newValue = (Color)val;
                this.style.setBackcolor(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Backcolor", Color.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return null == this.style.getOwnBackcolor();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class ForecolorProperty
    extends PropertySupport.ReadWrite {
        JRBaseStyle style;

        public ForecolorProperty(JRBaseStyle style) {
            super("forecolor", Color.class, I18n.getString("AbstractStyleNode.Property.Forecolor"), I18n.getString("AbstractStyleNode.Property.Forecolordetail"));
            this.style = null;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getForecolor();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Color) {
                Color oldValue = this.style.getOwnForecolor();
                Color newValue = (Color)val;
                this.style.setForecolor(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Forecolor", Color.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return null == this.style.getOwnForecolor();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class ModeProperty
    extends PropertySupport.ReadWrite {
        JRBaseStyle style;

        public ModeProperty(JRBaseStyle style) {
            super("mode", Boolean.class, I18n.getString("AbstractStyleNode.Property.Opaque"), I18n.getString("AbstractStyleNode.Property.Set"));
            this.style = null;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this.style.getMode() != null && this.style.getMode() == 1);
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Byte oldValue = this.style.getOwnMode();
                Byte newValue = val == null ? null : Byte.valueOf((Boolean)val != false ? (byte)1 : 2);
                this.style.setMode(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Mode", Byte.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnMode() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }
}

