/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

class ComboInplaceEditor
extends JComboBox
implements InplaceEditor,
FocusListener,
AncestorListener {
    static final KeyStroke[] cbKeyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(40, 0, false), KeyStroke.getKeyStroke(38, 0, false), KeyStroke.getKeyStroke(40, 0, true), KeyStroke.getKeyStroke(38, 0, true), KeyStroke.getKeyStroke(34, 0, false), KeyStroke.getKeyStroke(33, 0, false), KeyStroke.getKeyStroke(34, 0, true), KeyStroke.getKeyStroke(33, 0, true)};
    private static PopupChecker checker = null;
    protected PropertyEditor editor;
    protected PropertyEnv env;
    protected PropertyModel mdl;
    boolean inSetUI = false;
    private boolean tableUI;
    private boolean connecting = false;
    private boolean hasBeenEditable = false;
    private boolean needLayout = false;

    public ComboInplaceEditor(boolean bl) {
        if (bl) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        if (Boolean.getBoolean("netbeans.ps.combohack")) {
            this.setLightWeightPopupEnabled(false);
        }
        if (this.getClass() == ComboInplaceEditor.class) {
            this.enableEvents(4L);
        }
        this.tableUI = bl;
        if (bl) {
            this.updateUI();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.isEditable() && this.getClass() == ComboInplaceEditor.class) {
            this.getEditor().getEditorComponent().addFocusListener(this);
        }
        this.getLayout().layoutContainer(this);
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.hasBeenEditable;
        this.hasBeenEditable |= bl;
        super.setEditable(bl);
        if (bl2 != this.hasBeenEditable) {
            this.log("Combo editor for " + this.editor + " setEditable (" + bl + ")");
            this.needLayout = true;
        }
    }

    public void removeNotify() {
        this.log("Combo editor for " + this.editor + " removeNotify forcing popup close");
        this.setPopupVisible(false);
        super.removeNotify();
        this.getEditor().getEditorComponent().removeFocusListener(this);
    }

    public Insets getInsets() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            return new Insets(0, 0, 0, 0);
        }
        return super.getInsets();
    }

    public void clear() {
        this.editor = null;
        this.env = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.connecting = true;
        try {
            this.log("Combo editor connect to " + propertyEditor + " env=" + propertyEnv);
            this.env = propertyEnv;
            this.editor = propertyEditor;
            this.setModel(new DefaultComboBoxModel<String>(propertyEditor.getTags()));
            boolean bl = this.editor instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)this.editor).supportsEditingTaggedValues() : propertyEnv != null && Boolean.TRUE.equals(propertyEnv.getFeatureDescriptor().getValue("canEditAsText"));
            this.setEditable(bl);
            this.setActionCommand("success");
            this.reset();
        }
        finally {
            this.connecting = false;
        }
    }

    private void log(String string) {
        if (PropUtils.isLoggable(ComboInplaceEditor.class) && this.getClass() == ComboInplaceEditor.class) {
            PropUtils.log(ComboInplaceEditor.class, string);
        }
    }

    public void setSelectedItem(Object object) {
        if (object == null && this.editor != null && this.editor.getTags() != null && this.editor.getTags().length > 0) {
            object = this.editor.getTags()[0];
        }
        if (object != null) {
            super.setSelectedItem(object);
        }
    }

    public void fireActionEvent() {
        if (this.connecting || this.editor == null) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        if ("comboBoxEdited".equals(this.getActionCommand())) {
            this.log("Translating comboBoxEdited action command to COMMAND_SUCCESS");
            this.setActionCommand("success");
        }
        this.log("Combo editor firing ActionPerformed command=" + this.getActionCommand());
        super.fireActionEvent();
    }

    public void reset() {
        String string;
        String string2 = null;
        if (this.editor != null) {
            this.log("Combo editor reset setting selected item to " + this.editor.getAsText());
            string2 = this.editor.getAsText();
        }
        if (this.getClass() == ComboInplaceEditor.class && this.env != null && this.env.getFeatureDescriptor() != null && (string = (String)this.env.getFeatureDescriptor().getValue("initialEditValue")) != null) {
            string2 = string;
        }
        this.setSelectedItem(string2);
    }

    public Object getValue() {
        if (this.isEditable()) {
            return this.getEditor().getItem();
        }
        return this.getSelectedItem();
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public PropertyModel getPropertyModel() {
        return this.mdl;
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.log("Combo editor set property model to " + propertyModel);
        this.mdl = propertyModel;
    }

    public JComponent getComponent() {
        return this;
    }

    public KeyStroke[] getKeyStrokes() {
        return cbKeyStrokes;
    }

    public void handleInitialInputEvent(InputEvent inputEvent) {
    }

    public void updateUI() {
        boolean bl;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getID();
        boolean bl2 = bl = this.tableUI && (lookAndFeel instanceof MetalLookAndFeel || "GTK".equals(string) || "Kunststoff".equals(string));
        if (bl) {
            super.setUI(PropUtils.createComboUI(this, this.tableUI));
        } else {
            super.updateUI();
        }
        if (this.tableUI & this.getEditor().getEditorComponent() instanceof JComponent) {
            ((JComponent)this.getEditor().getEditorComponent()).setBorder(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(ComboBoxUI comboBoxUI) {
        this.inSetUI = true;
        try {
            super.setUI(comboBoxUI);
        }
        finally {
            this.inSetUI = false;
        }
    }

    public void showPopup() {
        try {
            this.log(" Combo editor show popup");
            super.showPopup();
        }
        catch (NullPointerException nullPointerException) {
            this.log(" Combo editor show popup later due to npe");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComboInplaceEditor.super.showPopup();
                }
            });
        }
    }

    private void prepareEditor() {
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            String string = jTextComponent.getText();
            if (string != null && string.length() > 0) {
                jTextComponent.setSelectionStart(0);
                jTextComponent.setSelectionEnd(string.length());
            }
            if (this.tableUI) {
                jTextComponent.setBackground(this.getBackground());
            } else {
                jTextComponent.setBackground(PropUtils.getTextFieldBackground());
            }
            if (this.tableUI) {
                jTextComponent.requestFocus();
            }
        }
        if (this.getLayout() != null) {
            this.getLayout().layoutContainer(this);
        }
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    public void processFocusEvent(FocusEvent var1_1) {
        super.processFocusEvent(var1_1);
        if (PropUtils.isLoggable(ComboInplaceEditor.class)) {
            PropUtils.log(ComboInplaceEditor.class, "Focus event on combo editor");
            PropUtils.log(ComboInplaceEditor.class, var1_1);
        }
        var2_2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!this.isDisplayable()) ** GOTO lbl-1000
        if (var1_1.getID() == 1004 && var2_2 == this && !this.isPopupVisible()) {
            if (this.isEditable()) {
                this.prepareEditor();
                if (this.tableUI) {
                    SwingUtilities.invokeLater(new PopupChecker());
                }
            } else if (this.tableUI) {
                this.showPopup();
                SwingUtilities.invokeLater(new PopupChecker());
            }
            this.repaint();
        } else if (var1_1.getID() == 1005 && this.isPopupVisible() && !this.isDisplayable()) {
            if (!PropUtils.psCommitOnFocusLoss) {
                this.setActionCommand("failure");
                this.fireActionEvent();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!ComboInplaceEditor.this.isDisplayable()) {
                        ComboInplaceEditor.this.hidePopup();
                    }
                }
            });
        }
        this.repaint();
    }

    public boolean isKnownComponent(Component component) {
        return component == this.getEditor().getEditorComponent();
    }

    public void setValue(Object object) {
        this.setSelectedItem(object);
    }

    public boolean supportsTextEntry() {
        return this.isEditable();
    }

    protected void installAncestorListener() {
        if (this.tableUI) {
            this.addAncestorListener(this);
        } else {
            super.installAncestorListener();
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        if (!this.inSetUI || !this.tableUI) {
            super.addFocusListener(focusListener);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.prepareEditor();
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getOppositeComponent();
        if (!this.isAncestorOf(component) && component != this.getEditor().getEditorComponent()) {
            if (component == this || component instanceof SheetTable && ((SheetTable)component).isAncestorOf(this)) {
                return;
            }
            this.setActionCommand("failure");
            this.log(" Combo editor lost focus - setting action command to failure");
            this.getEditor().getEditorComponent().removeFocusListener(this);
            if (checker == null) {
                this.log("No active popup checker, firing action event");
                this.fireActionEvent();
            }
        }
    }

    public void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        if (this.isEditable()) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.isDisplayable() && component == this) {
                this.log("combo editor popup menu canceled.  Requesting focus on editor component");
                this.getEditor().getEditorComponent().requestFocus();
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 401) {
            if (keyEvent.getKeyCode() == 27) {
                this.setActionCommand("failure");
                this.fireActionEvent();
            }
        }
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        checker = new PopupChecker();
        SwingUtilities.invokeLater(checker);
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
        if (this.needLayout && this.getLayout() != null) {
            this.getLayout().layoutContainer(this);
        }
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public void paintChildren(Graphics graphics) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            return;
        }
        super.paintChildren(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            Insets insets = this.getInsets();
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            finally {
                graphics.setColor(color);
            }
            insets.left += PropUtils.getTextMargin();
            this.editor.paintValue(graphics, new Rectangle(insets.left, insets.top, this.getWidth() - (insets.right + insets.left), this.getHeight() - (insets.top + insets.bottom)));
        } else {
            super.paintComponent(graphics);
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private boolean sel = false;

        private Renderer() {
        }

        public Color getBackground() {
            if (ComboInplaceEditor.this == null) {
                return null;
            }
            if (!this.sel && this.getText() != null && ComboInplaceEditor.this.getSelectedItem() != null && this.getText().equals(ComboInplaceEditor.this.getSelectedItem())) {
                return ComboInplaceEditor.this.getBackground();
            }
            return super.getBackground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.sel = bl;
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private class PopupChecker
    implements Runnable {
        private PopupChecker() {
        }

        public void run() {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (null != window && window.isAncestorOf(ComboInplaceEditor.this)) {
                if (ComboInplaceEditor.this.isShowing() && !ComboInplaceEditor.this.isPopupVisible()) {
                    ComboInplaceEditor.this.log("Popup checker ensuring editor prepared or popup visible");
                    if (ComboInplaceEditor.this.isEditable()) {
                        ComboInplaceEditor.this.prepareEditor();
                    }
                    ComboInplaceEditor.this.showPopup();
                }
                checker = null;
            }
        }
    }
}

