/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public final class MimePathLookup
extends ProxyLookup
implements LookupListener {
    private static final Logger LOG = Logger.getLogger(MimePathLookup.class.getName());
    private MimePath mimePath;
    private Lookup.Result<MimeDataProvider> dataProviders;
    private Lookup.Result<MimeLookupInitializer> mimeInitializers;

    public MimePathLookup(MimePath mimePath) {
        if (mimePath == null) {
            throw new NullPointerException("Mime path can't be null.");
        }
        this.mimePath = mimePath;
        this.dataProviders = Lookup.getDefault().lookup(new Lookup.Template(MimeDataProvider.class));
        this.dataProviders.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.dataProviders));
        this.mimeInitializers = Lookup.getDefault().lookup(new Lookup.Template(MimeLookupInitializer.class));
        this.mimeInitializers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.mimeInitializers));
        this.rebuild();
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    private void rebuild() {
        Object object;
        Object object2;
        Object object32;
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        for (Object object32 : this.dataProviders.allInstances()) {
            object2 = object32.getLookup(this.mimePath);
            if (object2 == null) continue;
            arrayList.add((Lookup)object2);
        }
        try {
            object32 = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            ((Method)object32).setAccessible(true);
            object2 = (List)((Method)object32).invoke((Object)this.mimePath, new Object[]{null, null});
            object = object2;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", exception);
            object = Collections.singletonList(this.mimePath.getPath());
        }
        object32 = object.iterator();
        while (object32.hasNext()) {
            Lookup lookup;
            Object object4;
            object2 = (String)object32.next();
            MimePath mimePath = MimePath.parse((String)object2);
            Object object5 = this.mimeInitializers.allInstances();
            for (int i = 0; i < mimePath.size(); ++i) {
                object4 = new ArrayList(object5.size());
                lookup = object5.iterator();
                while (lookup.hasNext()) {
                    MimeLookupInitializer mimeLookupInitializer = (MimeLookupInitializer)lookup.next();
                    object4.addAll(mimeLookupInitializer.child(mimePath.getMimeType(i)).allInstances());
                }
                object5 = object4;
            }
            Iterator iterator = object5.iterator();
            while (iterator.hasNext()) {
                object4 = (MimeLookupInitializer)iterator.next();
                lookup = object4.lookup();
                if (lookup == null) continue;
                arrayList.add(lookup);
            }
        }
        this.setLookups(arrayList.toArray(new Lookup[arrayList.size()]));
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.rebuild();
    }
}

