/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;

public class JRSaver {
    public static void saveObject(Object obj, String fileName) throws JRException {
        JRSaver.saveObject(obj, new File(fileName));
    }

    public static void saveObject(Object obj, File file) throws JRException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bos.flush();
            fos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error saving file : " + file, e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void saveObject(Object obj, OutputStream os) throws JRException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(obj);
            oos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error saving object to OutputStream", e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void saveClassSource(String source, File file) throws JRException {
        FileWriter fwriter = null;
        try {
            fwriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fwriter);
            bufferedWriter.write(source);
            bufferedWriter.flush();
            fwriter.flush();
        }
        catch (IOException e) {
            throw new JRException("Error saving expressions class file : " + file, e);
        }
        finally {
            if (fwriter != null) {
                try {
                    fwriter.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

