/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.tools.JRSubreportParameterDialog;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;
import org.jdesktop.swingx.JXTable;

public class SubreportParametersPanel
extends JPanel {
    private Map parameters = new HashMap();
    private ExpressionContext expressionContext = null;
    private JButton jButtonAdd;
    private JButton jButtonCopyFromMaster;
    private JButton jButtonDelete;
    private JButton jButtonModify;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map oldParameters) {
        this.parameters.clear();
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        model.setRowCount(0);
        for (Object key : oldParameters.keySet()) {
            JRDesignSubreportParameter oldParameter = (JRDesignSubreportParameter)oldParameters.get(key);
            JRDesignSubreportParameter parameter = new JRDesignSubreportParameter();
            parameter.setName(oldParameter.getName());
            if (oldParameter.getExpression() != null) {
                JRDesignExpression exp = new JRDesignExpression();
                exp.setText(oldParameter.getExpression().getText());
                exp.setValueClassName(oldParameter.getExpression().getValueClassName());
                parameter.setExpression((JRExpression)exp);
            }
            this.parameters.put(parameter.getName(), parameter);
            model.addRow(new Object[]{parameter.getName(), parameter.getExpression() != null && parameter.getExpression().getText() != null ? parameter.getExpression().getText() : ""});
        }
    }

    public SubreportParametersPanel() {
        this.initComponents();
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTable.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SubreportParametersPanel.this.jTableSelectionValueChanged(e);
            }
        });
    }

    public void jTableSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTable.getSelectedRowCount() > 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonDelete.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JXTable();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCopyFromMaster = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabelTitle.setText(I18n.getString("SubreportParametersPanel.jLabelTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabelTitle, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(375, 275));
        this.jTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Expression"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable.setOpaque(false);
        this.jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SubreportParametersPanel.this.jTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonAdd.setText(I18n.getString("SubreportParametersPanel.jButtonAdd.text"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportParametersPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText(I18n.getString("SubreportParametersPanel.jButtonModify.text"));
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportParametersPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonDelete.setText(I18n.getString("Global.Button.Delete"));
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportParametersPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonDelete, gridBagConstraints);
        this.jButtonCopyFromMaster.setText(I18n.getString("SubreportParametersPanel.jButtonCopyFromMaster.text"));
        this.jButtonCopyFromMaster.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportParametersPanel.this.jButtonCopyFromMasterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonCopyFromMaster, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        Window pWin = SwingUtilities.getWindowAncestor(this);
        JRSubreportParameterDialog jrpd = null;
        jrpd = pWin instanceof Dialog ? new JRSubreportParameterDialog((Dialog)pWin, this.getParameters()) : new JRSubreportParameterDialog((Frame)pWin, this.getParameters());
        jrpd.setExpressionContext(this.getExpressionContext());
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRDesignSubreportParameter parameter = jrpd.getParameter();
            this.parameters.put(parameter.getName(), parameter);
            DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
            model.addRow(new Object[]{parameter.getName(), parameter.getExpression() != null && parameter.getExpression().getText() != null ? parameter.getExpression().getText() : ""});
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        while (this.jTable.getSelectedRow() >= 0) {
            int row = this.jTable.getSelectedRow();
            row = ((JXTable)this.jTable).convertRowIndexToModel(row);
            this.parameters.remove(model.getValueAt(row, 0));
            model.removeRow(row);
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        row = ((JXTable)this.jTable).convertRowIndexToModel(row);
        JRDesignSubreportParameter parameter = (JRDesignSubreportParameter)this.parameters.get(model.getValueAt(row, 0));
        String oldName = parameter.getName();
        JRSubreportParameterDialog jrpd = null;
        Window pWin = SwingUtilities.getWindowAncestor(this);
        jrpd = pWin instanceof Dialog ? new JRSubreportParameterDialog((Dialog)pWin, this.getParameters()) : (pWin instanceof Frame ? new JRSubreportParameterDialog((Frame)pWin, this.getParameters()) : new JRSubreportParameterDialog((Dialog)null, this.getParameters()));
        jrpd.setExpressionContext(this.getExpressionContext());
        jrpd.setParameter(parameter);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            parameter = jrpd.getParameter();
            this.parameters.remove(oldName);
            this.parameters.put(parameter.getName(), parameter);
            model.setValueAt(parameter.getName(), row, 0);
            model.setValueAt(parameter.getExpression() != null && parameter.getExpression().getText() != null ? parameter.getExpression().getText() : "", row, 1);
            this.jTable.updateUI();
        }
    }

    private void jButtonCopyFromMasterActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        List reportParameters = IReportManager.getInstance().getActiveReport().getParametersList();
        for (int i = 0; i < reportParameters.size(); ++i) {
            JRDesignParameter jrParameter = (JRDesignParameter)reportParameters.get(i);
            if (jrParameter.isSystemDefined() || this.parameters.containsKey(jrParameter.getName())) continue;
            JRDesignSubreportParameter parameter = new JRDesignSubreportParameter();
            parameter.setName(jrParameter.getName());
            JRDesignExpression exp = new JRDesignExpression();
            exp.setText("$P{" + jrParameter.getName() + "}");
            parameter.setExpression((JRExpression)exp);
            this.parameters.put(parameter.getName(), parameter);
            model.addRow(new Object[]{parameter.getName(), parameter.getExpression() != null && parameter.getExpression().getText() != null ? parameter.getExpression().getText() : ""});
        }
        this.jTable.updateUI();
    }

    private void jTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt) && this.jTable.getSelectedRowCount() > 0) {
            this.jButtonModifyActionPerformed(null);
        }
    }
}

