/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.atp.AnalysisToolPak;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NameEval;
import org.apache.poi.hssf.record.formula.eval.NameXEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.EvaluationWorkbook;

final class ExternalFunction
implements FreeRefFunction {
    ExternalFunction() {
    }

    public ValueEval evaluate(Eval[] args, EvaluationWorkbook workbook, int srcCellSheet, int srcCellRow, int srcCellCol) {
        FreeRefFunction targetFunc;
        int nIncomingArgs;
        block5: {
            nIncomingArgs = args.length;
            if (nIncomingArgs < 1) {
                throw new RuntimeException("function name argument missing");
            }
            Eval nameArg = args[0];
            try {
                if (nameArg instanceof NameEval) {
                    targetFunc = this.findInternalUserDefinedFunction((NameEval)nameArg);
                    break block5;
                }
                if (nameArg instanceof NameXEval) {
                    targetFunc = this.findExternalUserDefinedFunction(workbook, (NameXEval)nameArg);
                    break block5;
                }
                throw new RuntimeException("First argument should be a NameEval, but got (" + nameArg.getClass().getName() + ")");
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
        }
        int nOutGoingArgs = nIncomingArgs - 1;
        Eval[] outGoingArgs = new Eval[nOutGoingArgs];
        System.arraycopy(args, 1, outGoingArgs, 0, nOutGoingArgs);
        return targetFunc.evaluate(outGoingArgs, workbook, srcCellSheet, srcCellRow, srcCellCol);
    }

    private FreeRefFunction findExternalUserDefinedFunction(EvaluationWorkbook workbook, NameXEval n) throws EvaluationException {
        String functionName = workbook.resolveNameXText(n.getPtg());
        FreeRefFunction result = AnalysisToolPak.findFunction(functionName);
        if (result != null) {
            return result;
        }
        throw new EvaluationException(ErrorEval.FUNCTION_NOT_IMPLEMENTED);
    }

    private FreeRefFunction findInternalUserDefinedFunction(NameEval functionNameEval) throws EvaluationException {
        String functionName = functionNameEval.getFunctionName();
        throw new EvaluationException(ErrorEval.FUNCTION_NOT_IMPLEMENTED);
    }
}

