/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseMeterPlot
extends JRBaseChartPlot
implements JRMeterPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange = null;
    protected JRValueDisplay valueDisplay = null;
    protected Byte shapeByte = null;
    protected List intervals = new ArrayList();
    protected Integer meterAngleInteger = null;
    protected String units = null;
    protected Double tickIntervalDouble = null;
    protected Color meterBackgroundColor = null;
    protected Color needleColor = null;
    protected Color tickColor = null;
    private int PSEUDO_SERIAL_VERSION_UID = 30103;
    private byte shape = (byte)2;
    private int meterAngle = 180;
    private double tickInterval = 10.0;

    public JRBaseMeterPlot(JRChartPlot meterPlot, JRChart chart) {
        super(meterPlot, chart);
    }

    public JRBaseMeterPlot(JRMeterPlot meterPlot, JRBaseObjectFactory factory) {
        super((JRChartPlot)meterPlot, factory);
        this.dataRange = new JRBaseDataRange(meterPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), factory);
        this.shapeByte = meterPlot.getShapeByte();
        List origIntervals = meterPlot.getIntervals();
        this.intervals.clear();
        if (origIntervals != null) {
            Iterator iter = origIntervals.iterator();
            while (iter.hasNext()) {
                JRMeterInterval interval = (JRMeterInterval)iter.next();
                this.intervals.add(new JRMeterInterval(interval, factory));
            }
        }
        this.meterAngleInteger = meterPlot.getMeterAngleInteger();
        this.units = meterPlot.getUnits();
        this.tickIntervalDouble = meterPlot.getTickIntervalDouble();
        this.meterBackgroundColor = meterPlot.getMeterBackgroundColor();
        this.needleColor = meterPlot.getNeedleColor();
        this.tickColor = meterPlot.getTickColor();
    }

    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    public byte getShape() {
        return this.shapeByte == null ? (byte)2 : this.shapeByte;
    }

    public Byte getShapeByte() {
        return this.shapeByte;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public int getMeterAngle() {
        return this.meterAngleInteger == null ? 180 : this.meterAngleInteger;
    }

    public Integer getMeterAngleInteger() {
        return this.meterAngleInteger;
    }

    public String getUnits() {
        return this.units;
    }

    public double getTickInterval() {
        return this.tickIntervalDouble == null ? 10.0 : this.tickIntervalDouble;
    }

    public Double getTickIntervalDouble() {
        return this.tickIntervalDouble;
    }

    public Color getMeterBackgroundColor() {
        return this.meterBackgroundColor;
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Object clone(JRChart parentChart) {
        JRBaseMeterPlot clone = (JRBaseMeterPlot)super.clone(parentChart);
        if (this.dataRange != null) {
            clone.dataRange = (JRDataRange)this.dataRange.clone();
        }
        if (this.valueDisplay != null) {
            clone.valueDisplay = (JRValueDisplay)this.valueDisplay.clone();
        }
        if (this.intervals != null) {
            clone.intervals = new ArrayList(this.intervals.size());
            for (int i = 0; i < this.intervals.size(); ++i) {
                clone.intervals.add(((JRMeterInterval)this.intervals.get(i)).clone());
            }
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
            this.shapeByte = new Byte(this.shape);
            this.meterAngleInteger = new Integer(this.meterAngle);
            this.tickIntervalDouble = new Double(this.tickInterval);
        }
    }
}

