/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.openide.util.NbBundle;

public class StatusBar
implements PropertyChangeListener,
SettingsChangeListener,
DocumentListener {
    public static final String CELL_MAIN = "main";
    public static final String CELL_POSITION = "position";
    public static final String CELL_TYPING_MODE = "typing-mode";
    public static final String INSERT_LOCALE = "status-bar-insert";
    public static final String OVERWRITE_LOCALE = "status-bar-overwrite";
    private static final String[] POS_MAX_STRINGS = new String[]{"99999:999"};
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    static final Border CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getDefaults().getColor("controlHighlight")), BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlDkShadow")))), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    protected EditorUI editorUI;
    private JPanel panel;
    private boolean visible;
    private Coloring coloring;
    private Coloring boldColoring;
    private List cellList = new ArrayList();
    private Caret caret;
    private CaretListener caretL;
    private int caretDelay;
    private boolean overwriteModeDisplayed;
    private String insText;
    private String ovrText;
    private String caretPositionLocaleString;
    private String insertModeLocaleString;
    private String overwriteModeLocaleString;
    static final long serialVersionUID = -6266183959929157349L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusBar(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.caretDelay = 10;
        this.caretL = new CaretListener(this.caretDelay);
        ResourceBundle resourceBundle = NbBundle.getBundle(BaseKit.class);
        this.insText = resourceBundle.getString(INSERT_LOCALE);
        this.ovrText = resourceBundle.getString(OVERWRITE_LOCALE);
        this.caretPositionLocaleString = resourceBundle.getString("status-bar-caret-position");
        this.insertModeLocaleString = resourceBundle.getString("status-bar-insert-mode");
        this.overwriteModeLocaleString = resourceBundle.getString("status-bar-overwrite-mode");
        Settings.addSettingsChangeListener(this);
        Object object = editorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = editorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(editorUI, "component", null, jTextComponent));
            }
            editorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        String string;
        Class clazz = Utilities.getKitClass(this.editorUI.getComponent());
        String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (clazz != null) {
            this.coloring = this.editorUI.getColoring("status-bar");
            this.boldColoring = this.editorUI.getColoring("status-bar-bold");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.refreshPanel();
                }
            });
            if (string == null || "status-bar-caret-delay".equals(string)) {
                this.caretDelay = SettingsUtil.getInteger(clazz, "status-bar-caret-delay", SettingsDefaults.defaultStatusBarCaretDelay);
                if (this.caretL != null) {
                    this.caretL.setDelay(this.caretDelay);
                }
            }
            if (string == null || "status-bar-visible".equals(string)) {
                boolean bl = SettingsUtil.getBoolean(clazz, "status-bar-visible", SettingsDefaults.defaultStatusBarVisible);
                this.setVisible(bl);
            }
        }
    }

    private void documentUndo(DocumentEvent documentEvent) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                StatusBar.this.setText(StatusBar.CELL_MAIN, "");
            }
        });
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
            this.documentUndo(documentEvent);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
            this.documentUndo(documentEvent);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    protected JPanel createPanel() {
        return new JPanel(new GridBagLayout());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            if (this.panel != null || this.visible) {
                if (this.visible) {
                    this.refreshPanel();
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    this.getPanel().setVisible(this.visible);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusBar.this.getPanel().setVisible(StatusBar.this.visible);
                        }
                    });
                }
            }
        }
    }

    public final JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            this.initPanel();
        }
        return this.panel;
    }

    protected void initPanel() {
        JLabel jLabel = this.addCell(CELL_POSITION, POS_MAX_STRINGS);
        jLabel.setHorizontalAlignment(0);
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Action action;
                if (mouseEvent.getClickCount() == 2 && (action = Utilities.getKit(StatusBar.this.editorUI.getComponent()).getActionByName("goto")) != null) {
                    action.actionPerformed(new ActionEvent(StatusBar.this.editorUI.getComponent(), 0, null));
                }
            }
        });
        this.addCell(CELL_TYPING_MODE, new String[]{this.insText, this.ovrText}).setHorizontalAlignment(0);
        this.setText(CELL_TYPING_MODE, this.insText);
        this.addCell(CELL_MAIN, null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jTextComponent != null) {
                Document document;
                jTextComponent.addPropertyChangeListener(this);
                this.caret = jTextComponent.getCaret();
                if (this.caret != null) {
                    this.caret.addChangeListener(this.caretL);
                }
                if ((document = jTextComponent.getDocument()) != null) {
                    document.addDocumentListener(this);
                }
                this.settingsChange(null);
                this.refreshPanel();
            } else {
                Document document;
                jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                jTextComponent.removePropertyChangeListener(this);
                this.caret = jTextComponent.getCaret();
                if (this.caret != null) {
                    this.caret.removeChangeListener(this.caretL);
                }
                if ((document = jTextComponent.getDocument()) != null) {
                    document.removeDocumentListener(this);
                }
            }
        } else if ("caret".equals(string)) {
            if (this.caret != null) {
                this.caret.removeChangeListener(this.caretL);
            }
            this.caret = (Caret)propertyChangeEvent.getNewValue();
            if (this.caret != null) {
                this.caret.addChangeListener(this.caretL);
            }
        } else if ("document".equals(string)) {
            Document document = (Document)propertyChangeEvent.getOldValue();
            Document document2 = (Document)propertyChangeEvent.getNewValue();
            if (document != null) {
                document.removeDocumentListener(this);
            }
            if (document2 != null) {
                document2.addDocumentListener(this);
            }
        }
        if ("overwriteMode".equals(string)) {
            this.caretL.actionPerformed(null);
        } else {
            this.caretL.stateChanged(null);
        }
    }

    private void applyColoring(Cell cell, Coloring coloring) {
        coloring.apply(cell);
        if (coloring.getForeColor() == null) {
            cell.setForeground(cell.getDefaultForeground());
        }
        if (coloring.getBackColor() == null) {
            cell.setBackground(cell.getDefaultBackground());
        }
    }

    public int getCellCount() {
        return this.cellList.size();
    }

    public JLabel addCell(String string, String[] stringArray) {
        return this.addCell(-1, string, stringArray);
    }

    public JLabel addCell(int n, String string, String[] stringArray) {
        Cell cell = new Cell(string, stringArray);
        this.addCellImpl(n, cell);
        return cell;
    }

    public void addCustomCell(int n, JLabel jLabel) {
        this.addCellImpl(n, jLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCellImpl(int n, JLabel jLabel) {
        List list = this.cellList;
        synchronized (list) {
            ArrayList<JLabel> arrayList = new ArrayList<JLabel>(this.cellList);
            int n2 = arrayList.size();
            if (n < 0 || n > n2) {
                n = n2;
            }
            arrayList.add(n, jLabel);
            this.cellList = arrayList;
            this.updateCellBorders(n);
        }
        this.refreshPanel();
    }

    private void updateCellBorders(int n) {
        int n2 = this.getCellCount();
        Border border = (Border)UIManager.get("Nb.Editor.Status.innerBorder");
        Border border2 = (Border)UIManager.get("Nb.Editor.Status.leftBorder");
        Border border3 = (Border)UIManager.get("Nb.Editor.Status.rightBorder");
        Border border4 = (Border)UIManager.get("Nb.Editor.Status.onlyOneBorder");
        if (border == null || border2 == null || border3 == null || border4 == null) {
            return;
        }
        if (n2 == 1) {
            ((JLabel)this.cellList.get(0)).setBorder(border4);
            return;
        }
        if (n == 0) {
            ((JLabel)this.cellList.get(0)).setBorder(border2);
            JLabel jLabel = (JLabel)this.cellList.get(1);
            jLabel.setBorder(n2 == 2 ? border3 : border);
        } else if (n == n2 - 1) {
            ((JLabel)this.cellList.get(n2 - 1)).setBorder(border3);
            JLabel jLabel = (JLabel)this.cellList.get(n2 - 2);
            jLabel.setBorder(n2 == 2 ? border2 : border);
        } else {
            ((JLabel)this.cellList.get(n)).setBorder(border);
        }
    }

    public JLabel getCellByName(String string) {
        for (JLabel jLabel : this.cellList) {
            if (!string.equals(jLabel.getName())) continue;
            return jLabel;
        }
        return null;
    }

    public String getText(String string) {
        JLabel jLabel = this.getCellByName(string);
        return jLabel != null ? jLabel.getText() : null;
    }

    public void setText(String string, String string2) {
        this.setText(string, string2, null);
    }

    public void setBoldText(String string, String string2) {
        this.setText(string, string2, this.boldColoring);
    }

    public void setText(String string, String string2, Coloring coloring) {
        JLabel jLabel = this.getCellByName(string);
        if (jLabel != null) {
            Coloring coloring2 = this.coloring;
            if (coloring2 != null && coloring != null) {
                coloring2 = coloring.apply(coloring2);
            } else if (coloring2 == null) {
                coloring2 = coloring;
            }
            jLabel.setText(string2);
            if (CELL_POSITION.equals(string)) {
                jLabel.setToolTipText(this.caretPositionLocaleString);
            } else if (CELL_TYPING_MODE.equals(string)) {
                jLabel.setToolTipText(this.insText.equals(string2) ? this.insertModeLocaleString : this.overwriteModeLocaleString);
            } else {
                jLabel.setToolTipText(string2.length() == 0 ? null : string2);
            }
            if (coloring2 != null && jLabel instanceof Cell) {
                this.applyColoring((Cell)jLabel, coloring2);
            }
        }
    }

    private void refreshPanel() {
        if (this.isVisible()) {
            Serializable serializable2;
            for (Serializable serializable2 : this.cellList) {
                if (!(serializable2 instanceof Cell) || this.coloring == null) continue;
                this.applyColoring((Cell)serializable2, this.coloring);
            }
            serializable2 = new GridBagConstraints();
            ((GridBagConstraints)serializable2).gridx = -1;
            ((GridBagConstraints)serializable2).gridwidth = 1;
            ((GridBagConstraints)serializable2).gridheight = 1;
            for (JLabel jLabel : this.cellList) {
                boolean bl = CELL_MAIN.equals(jLabel.getName());
                if (bl) {
                    ((GridBagConstraints)serializable2).fill = 2;
                    ((GridBagConstraints)serializable2).weightx = 1.0;
                }
                this.getPanel().add((Component)jLabel, serializable2);
                if (!bl) continue;
                ((GridBagConstraints)serializable2).fill = 0;
                ((GridBagConstraints)serializable2).weightx = 0.0;
            }
        }
    }

    public static final class StatusBarFactory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent jTextComponent) {
            return Utilities.getEditorUI(jTextComponent).getStatusBar().getPanel();
        }
    }

    static class Cell
    extends JLabel {
        Dimension maxDimension;
        String[] widestStrings;
        private final Color defaultBackground;
        private final Color defaultForeground;
        static final long serialVersionUID = -2554600362177165648L;

        Cell(String string, String[] stringArray) {
            this.setName(string);
            this.setBorder(CELL_BORDER);
            this.setOpaque(true);
            this.widestStrings = stringArray;
            this.defaultBackground = this.getBackground();
            this.defaultForeground = this.getForeground();
            this.updateSize();
        }

        private void updateSize() {
            Font font = this.getFont();
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            if (font != null) {
                Border border = this.getBorder();
                Insets insets = border != null ? border.getBorderInsets(this) : NULL_INSETS;
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = fontMetrics.stringWidth(this.getText());
                this.maxDimension.height = fontMetrics.getHeight() + insets.top + insets.bottom;
                if (this.widestStrings != null) {
                    for (int i = 0; i < this.widestStrings.length; ++i) {
                        String string = this.widestStrings[i];
                        if (string == null) continue;
                        n = Math.max(n, fontMetrics.stringWidth(string));
                    }
                }
                this.maxDimension.width = n + insets.left + insets.right;
            }
        }

        public Dimension getPreferredSize() {
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            return new Dimension(this.maxDimension);
        }

        public Dimension getMinimumSize() {
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            return new Dimension(this.maxDimension);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.updateSize();
        }

        public Color getDefaultForeground() {
            Color color = (Color)UIManager.get("Label.foreground");
            return color != null ? color : this.defaultForeground;
        }

        public Color getDefaultBackground() {
            Color color = (Color)UIManager.get("Label.background");
            return color != null ? color : this.defaultBackground;
        }
    }

    class CaretListener
    implements ChangeListener,
    ActionListener {
        Timer timer;

        CaretListener(int n) {
            this.timer = new Timer(n, new WeakTimerListener(this));
            this.timer.setRepeats(false);
        }

        void setDelay(int n) {
            this.timer.setInitialDelay(n);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.timer.restart();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Caret caret = StatusBar.this.caret;
            JTextComponent jTextComponent = StatusBar.this.editorUI.getComponent();
            if (jTextComponent != null) {
                boolean bl;
                Serializable serializable;
                if (caret != null && (serializable = Utilities.getDocument(StatusBar.this.editorUI.getComponent())) != null && ((BaseDocument)serializable).getDefaultRootElement().getElementCount() > 0) {
                    int bl2 = caret.getDot();
                    String string = Utilities.debugPosition((BaseDocument)serializable, bl2);
                    StatusBar.this.setText(StatusBar.CELL_POSITION, string);
                }
                boolean bl3 = bl = (serializable = (Boolean)StatusBar.this.editorUI.getProperty("overwriteMode")) != null && ((Boolean)serializable).booleanValue();
                if (bl != StatusBar.this.overwriteModeDisplayed) {
                    StatusBar.this.overwriteModeDisplayed = bl;
                    StatusBar.this.setText(StatusBar.CELL_TYPING_MODE, StatusBar.this.overwriteModeDisplayed ? StatusBar.this.ovrText : StatusBar.this.insText);
                }
            }
        }
    }
}

