/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

class TokenHighlightsLayer
extends AbstractHighlightsContainer {
    private Highlighting highlighting;
    private TokenHierarchy hierarchy;
    private Document document;
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TokenHighlightsLayer.this.fireHighlightsChange((Integer)propertyChangeEvent.getOldValue(), (Integer)propertyChangeEvent.getNewValue());
        }
    };

    TokenHighlightsLayer(Document document) {
        this.highlighting = Highlighting.getHighlighting(document);
        this.hierarchy = TokenHierarchy.get((Document)document);
        this.document = document;
        this.highlighting.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.highlighting));
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return new Highlights(this.document, this.highlighting, this.hierarchy, n, n2);
    }

    private static class Highlights
    implements HighlightsSequence {
        private int endOffset;
        private int startOffset1;
        private int endOffset1;
        private SimpleAttributeSet attributeSet;
        private Highlighting highlighting;
        private TokenHierarchy hierarchy;
        private Document document;

        private Highlights(Document document, Highlighting highlighting, TokenHierarchy tokenHierarchy, int n, int n2) {
            this.document = document;
            this.endOffset = n2;
            this.highlighting = highlighting;
            this.hierarchy = tokenHierarchy;
            this.endOffset1 = n;
        }

        public boolean moveNext() {
            this.attributeSet = new SimpleAttributeSet();
            this.startOffset1 = this.endOffset1;
            TokenSequence tokenSequence = this.hierarchy.tokenSequence();
            AttributeSet attributeSet = null;
            while (true) {
                TokenSequence tokenSequence2;
                tokenSequence.move(this.startOffset1);
                if (!tokenSequence.moveNext()) {
                    return this.endOffset1 > this.startOffset1;
                }
                Token token = tokenSequence.token();
                if (tokenSequence.language() == null) {
                    throw new NullPointerException("ts.language()==null: TS " + tokenSequence + " : " + this.document.getProperty("mimeType"));
                }
                attributeSet = this.highlighting.get(tokenSequence.offset(), tokenSequence.offset() + token.length());
                if (attributeSet != null) {
                    this.attributeSet.addAttributes(attributeSet);
                    this.endOffset1 = tokenSequence.offset() + token.length();
                }
                if ((tokenSequence2 = tokenSequence.embedded()) != null) {
                    tokenSequence = tokenSequence2;
                    continue;
                }
                if (this.endOffset1 > this.startOffset1) {
                    return true;
                }
                this.endOffset1 = this.startOffset1 = tokenSequence.offset() + tokenSequence.token().length();
                if (this.startOffset1 >= this.endOffset) break;
            }
            return false;
        }

        public int getStartOffset() {
            return this.startOffset1;
        }

        public int getEndOffset() {
            return this.endOffset1;
        }

        public AttributeSet getAttributes() {
            return this.attributeSet;
        }
    }
}

