/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.languages.Highlighting;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.windows.TopComponent;

public class HighlighterSupport {
    private Color color;
    private Highlighting.Highlight highlight;
    private AttributeSet highlightAS = null;

    public HighlighterSupport(Color color) {
        this.color = color;
    }

    public void highlight(Document document, int n, int n2) {
        this.removeHighlight();
        this.highlight = Highlighting.getHighlighting(document).highlight(n, n2, this.getHighlightAS());
        HighlighterSupport.refresh(document, n);
    }

    private static void refresh(final Document document, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                    JEditorPane[] jEditorPaneArray;
                    EditorCookie editorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class);
                    if (editorCookie == null || (jEditorPaneArray = editorCookie.getOpenedPanes()) == null) continue;
                    int n2 = jEditorPaneArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (jEditorPaneArray[i].getDocument() != document) continue;
                        JEditorPane jEditorPane = jEditorPaneArray[i];
                        try {
                            jEditorPane.scrollRectToVisible(jEditorPane.modelToView(n));
                            continue;
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify((Throwable)badLocationException);
                        }
                    }
                }
            }
        });
    }

    public void removeHighlight() {
        if (this.highlight == null) {
            return;
        }
        this.highlight.remove();
        this.highlight = null;
    }

    private AttributeSet getHighlightAS() {
        if (this.highlightAS == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.Background, this.color);
            this.highlightAS = simpleAttributeSet;
        }
        return this.highlightAS;
    }
}

