/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatAction
extends BaseAction {
    public FormatAction() {
        super("Format");
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        try {
            NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent.getDocument();
            ASTNode aSTNode = ParserManagerImpl.get((Document)nbEditorDocument).getAST();
            if (aSTNode == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("i", "");
            hashMap.put("ii", "    ");
            FormatAction.indent(aSTNode, new ArrayList<ASTItem>(), stringBuilder, hashMap, null, false, nbEditorDocument);
            nbEditorDocument.remove(0, nbEditorDocument.getLength());
            nbEditorDocument.insertString(0, stringBuilder.toString(), null);
        }
        catch (ParseException parseException) {
            ErrorManager.getDefault().notify((Throwable)parseException);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private static void indent(ASTItem aSTItem, List<ASTItem> list, StringBuilder stringBuilder, Map<String, String> map, ASTToken aSTToken, boolean bl, NbEditorDocument nbEditorDocument) {
        Language language = (Language)aSTItem.getLanguage();
        list.add(aSTItem);
        ASTPath aSTPath = ASTPath.create(list);
        for (ASTItem aSTItem2 : aSTItem.getChildren()) {
            Object object;
            String string = null;
            if (aSTItem2 instanceof ASTToken) {
                object = (ASTToken)aSTItem2;
                if (language.getAnalyser().getSkipTokenTypes().contains(((ASTToken)object).getTypeID())) {
                    aSTToken = (ASTToken)aSTItem2;
                    bl = false;
                    continue;
                }
            }
            if ((object = language.getFeature("FORMAT", aSTPath)) != null) {
                string = (String)((Feature)object).getValue();
            }
            if (string != null && string.equals("NewLine")) {
                stringBuilder.append("\n");
            }
            if (aSTItem2 instanceof ASTToken) {
                stringBuilder.append(((ASTToken)aSTItem2).getIdentifier());
                continue;
            }
            FormatAction.indent((ASTNode)aSTItem2, list, stringBuilder, map, aSTToken, bl || string != null, null);
        }
        list.remove(list.size() - 1);
    }

    private static String chars(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

