/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

public class MinusStarPredicate
extends AbstractColumnPredicate {
    private final StarColumnPredicate plus;
    private final StarColumnPredicate minus;

    public MinusStarPredicate(StarColumnPredicate plus, StarColumnPredicate minus) {
        super(plus.getConstrainedColumn());
        assert (minus != null);
        this.plus = plus;
        this.minus = minus;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MinusStarPredicate) {
            MinusStarPredicate that = (MinusStarPredicate)obj;
            return this.plus.equals(that.plus) && this.minus.equals(that.minus);
        }
        return false;
    }

    public int hashCode() {
        return this.plus.hashCode() * 31 + this.minus.hashCode();
    }

    public RolapStar.Column getConstrainedColumn() {
        return this.plus.getConstrainedColumn();
    }

    public void values(Collection collection) {
        HashSet plusValues = new HashSet();
        this.plus.values(plusValues);
        ArrayList minusValues = new ArrayList();
        this.minus.values(minusValues);
        plusValues.removeAll(minusValues);
        collection.addAll(plusValues);
    }

    public boolean evaluate(Object value) {
        return this.plus.evaluate(value) && !this.minus.evaluate(value);
    }

    public void describe(StringBuilder buf) {
        buf.append("(").append(this.plus).append(" - ").append(this.minus).append(")");
    }

    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    public boolean mightIntersect(StarPredicate other) {
        return this.plus.mightIntersect(other);
    }

    public StarColumnPredicate minus(StarPredicate predicate) {
        ValueColumnPredicate valuePredicate;
        assert (predicate != null);
        if (predicate instanceof ValueColumnPredicate && !this.evaluate((valuePredicate = (ValueColumnPredicate)predicate).getValue())) {
            return this;
        }
        if (this.minus instanceof ListColumnPredicate) {
            ListColumnPredicate minusList = (ListColumnPredicate)this.minus;
            RolapStar.Column column = this.plus.getConstrainedColumn();
            if (predicate instanceof ListColumnPredicate) {
                ListColumnPredicate list = (ListColumnPredicate)predicate;
                ArrayList<StarColumnPredicate> unionList = new ArrayList<StarColumnPredicate>();
                unionList.addAll(minusList.getPredicates());
                unionList.addAll(list.getPredicates());
                return new MinusStarPredicate(this.plus, new ListColumnPredicate(column, unionList));
            }
            if (predicate instanceof ValueColumnPredicate) {
                ValueColumnPredicate valuePredicate2 = (ValueColumnPredicate)predicate;
                if (!this.evaluate(valuePredicate2.getValue())) {
                    return this;
                }
                ArrayList<StarColumnPredicate> unionList = new ArrayList<StarColumnPredicate>();
                unionList.addAll(minusList.getPredicates());
                unionList.add(new ValueColumnPredicate(column, valuePredicate2.getValue()));
                return new MinusStarPredicate(this.plus, new ListColumnPredicate(column, unionList));
            }
        }
        return new MinusStarPredicate(this, (StarColumnPredicate)predicate);
    }
}

