/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import javax.olap.OLAPException;
import javax.olap.query.dimensionfilters.AttributeFilter;
import javax.olap.query.enumerations.OperatorType;
import javax.olap.query.enumerations.OperatorTypeEnum;
import mondrian.jolap.MondrianDimensionFilter;
import mondrian.jolap.MondrianDimensionStepManager;
import mondrian.jolap.MondrianJolapDimension;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.Literal;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import org.omg.java.cwm.objectmodel.core.Attribute;

class MondrianAttributeFilter
extends MondrianDimensionFilter
implements AttributeFilter {
    private OperatorType op;
    private Object rhs;
    private Attribute attribute;

    public MondrianAttributeFilter(MondrianDimensionStepManager manager) {
        super(manager);
    }

    Exp convert(Exp exp) throws OLAPException {
        return this.combine(exp, new UnresolvedFunCall("Filter", new Exp[]{exp, this.getCondition()}));
    }

    Exp getCondition() throws OLAPException {
        MondrianJolapDimension dimension = (MondrianJolapDimension)this.getDimensionStepManager().getDimensionView().getDimension();
        return new UnresolvedFunCall(this.getFunName(this.getOp()), this.getFunSyntacticType(this.getOp()), new Exp[]{new UnresolvedFunCall("CurrentMember", Syntax.Property, new Exp[]{new DimensionExpr(dimension.dimension)}), this.getExp(this.rhs)});
    }

    private Exp getExp(Object rhs) {
        if (rhs instanceof String) {
            return Literal.createString((String)rhs);
        }
        throw Util.newInternal("Cannot _convert '" + rhs + "' (" + rhs.getClass() + ") to an Exp");
    }

    private String getFunName(OperatorType op) {
        if (op == OperatorTypeEnum.EQ) {
            return "=";
        }
        if (op == OperatorTypeEnum.GE) {
            return ">=";
        }
        if (op == OperatorTypeEnum.GT) {
            return ">";
        }
        if (op == OperatorTypeEnum.LE) {
            return "<=";
        }
        if (op == OperatorTypeEnum.LT) {
            return "<";
        }
        if (op == OperatorTypeEnum.NE) {
            return "!=";
        }
        throw Util.newInternal("Unknown operator type " + op);
    }

    private Syntax getFunSyntacticType(OperatorType op) {
        return Syntax.Infix;
    }

    public OperatorType getOp() throws OLAPException {
        return this.op;
    }

    public void setOp(OperatorType input) throws OLAPException {
        this.op = input;
    }

    public Object getRhs() throws OLAPException {
        return this.rhs;
    }

    public void setRhs(Object input) throws OLAPException {
        this.rhs = input;
    }

    public void setAttribute(Attribute input) throws OLAPException {
        this.attribute = input;
    }

    public Attribute getAttribute() throws OLAPException {
        return this.attribute;
    }
}

