/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import mondrian.gui.ListRenderer;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.Workbench;

public class SchemaPropertyCellRenderer
extends DefaultTableCellRenderer {
    JLabel stringRenderer = new JLabel();
    JCheckBox booleanRenderer;
    JLabel integerRenderer;
    JTable tableRenderer;
    JComboBox listRenderer;
    JComboBox relationList;
    JTable relationTable;
    JPanel relationRenderer;
    JPanel rlPanel;
    JScrollPane jScrollPaneT;
    public static Color attributeBackground;

    public SchemaPropertyCellRenderer() {
        super.setBackground(attributeBackground);
        this.stringRenderer.setFont(Font.decode("Dialog"));
        this.booleanRenderer = new JCheckBox();
        this.booleanRenderer.setBackground(Color.white);
        this.integerRenderer = new JLabel();
        this.integerRenderer.setHorizontalAlignment(4);
        this.integerRenderer.setFont(Font.decode("Courier"));
        this.listRenderer = new JComboBox<String>(MondrianGuiDef.Measure._aggregator_values);
        this.listRenderer.setMaximumSize(this.stringRenderer.getMaximumSize());
        this.listRenderer.setFont(Font.decode("Dialog"));
        this.listRenderer.setBackground(Color.white);
        this.listRenderer.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.listRenderer.setRenderer(new ListRenderer(this.listRenderer.getRenderer()));
        this.relationRenderer = new JPanel();
        this.rlPanel = new JPanel();
        this.relationList = new JComboBox<String>(new String[]{"Join", "Table"});
        this.relationList.setMaximumSize(new Dimension(55, 22));
        this.relationList.setPreferredSize(new Dimension(55, 22));
        this.relationList.setMinimumSize(new Dimension(55, 22));
        this.relationList.setFont(Font.decode("Dialog"));
        this.relationList.setBackground(Color.white);
        this.relationTable = new JTable();
        this.relationTable.setBackground(new Color(255, 204, 204));
        this.relationTable.setTableHeader(null);
        this.jScrollPaneT = new JScrollPane();
        this.jScrollPaneT.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 0, 255), 2));
        this.jScrollPaneT.setVerticalScrollBarPolicy(21);
        this.jScrollPaneT.setViewportView(this.relationTable);
        this.relationRenderer.setLayout(new BorderLayout());
        this.rlPanel.add(this.relationList);
        this.relationRenderer.add((Component)this.rlPanel, "West");
        this.relationRenderer.add((Component)this.jScrollPaneT, "Center");
        this.relationRenderer.setBackground(Color.white);
        this.tableRenderer = new JTable();
    }

    public JCheckBox getBooleanRenderer() {
        return this.booleanRenderer;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 1) {
            this.stringRenderer.setOpaque(false);
            this.stringRenderer.setToolTipText(null);
            this.stringRenderer.setBackground(Color.white);
            if (value instanceof String) {
                this.stringRenderer.setText((String)value);
                return this.stringRenderer;
            }
            if (value instanceof Boolean) {
                this.booleanRenderer.setSelected((Boolean)value);
                return this.booleanRenderer;
            }
            if (value instanceof Integer) {
                this.integerRenderer.setText(value.toString());
                return this.integerRenderer;
            }
            if (value == null) {
                return null;
            }
            if (value.getClass() == MondrianGuiDef.Join.class) {
                this.stringRenderer.setText(this.generateJoinStr(value));
                this.stringRenderer.setToolTipText("Select the Join/Table object from Schema tree to edit.");
                this.stringRenderer.setOpaque(true);
                this.stringRenderer.setBackground(Color.LIGHT_GRAY);
                return this.stringRenderer;
            }
            if (value.getClass() == MondrianGuiDef.OrdinalExpression.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel((Object)((MondrianGuiDef.OrdinalExpression)((Object)value)).expressions[0], SchemaExplorer.DEF_SQL);
                this.tableRenderer.setModel(ptm);
                this.tableRenderer.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableRenderer.getColumnModel().getColumn(0).setMinWidth(100);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianGuiDef.Formula.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_FORMULA);
                this.tableRenderer.setModel(ptm);
                this.tableRenderer.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableRenderer.getColumnModel().getColumn(0).setMinWidth(100);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianGuiDef.CalculatedMemberProperty.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_CALCULATED_MEMBER_PROPERTY);
                this.tableRenderer.setModel(ptm);
                this.tableRenderer.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableRenderer.getColumnModel().getColumn(0).setMinWidth(100);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianGuiDef.Relation.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_RELATION);
                this.tableRenderer.setModel(ptm);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianGuiDef.Table.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_TABLE);
                this.tableRenderer.setModel(ptm);
                this.tableRenderer.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableRenderer.getColumnModel().getColumn(0).setMinWidth(100);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianGuiDef.AggFactCount.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_AGG_FACT_COUNT);
                this.tableRenderer.setModel(ptm);
                this.tableRenderer.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableRenderer.getColumnModel().getColumn(0).setMinWidth(100);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianGuiDef.Closure.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_CLOSURE);
                this.tableRenderer.setModel(ptm);
                this.tableRenderer.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableRenderer.getColumnModel().getColumn(0).setMinWidth(100);
                this.setTableRendererHeight(this.tableRenderer, null);
                return this.tableRenderer;
            }
            if (value.getClass() == MondrianGuiDef.Property.class) {
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
                this.tableRenderer.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(value, SchemaExplorer.DEF_PROPERTY);
                this.tableRenderer.setModel(ptm);
                return this.tableRenderer;
            }
            return null;
        }
        if (value instanceof String) {
            PropertyTableModel tableModel = (PropertyTableModel)table.getModel();
            String className = tableModel.target.getClass().getName();
            int pos = className.lastIndexOf("$");
            String tooltip = null;
            if (pos > 0) {
                String tipName = className.substring(pos + 1) + "," + tableModel.getRowName(row);
                tooltip = Workbench.getTooltip(tipName);
            }
            this.stringRenderer.setToolTipText(tooltip);
            this.stringRenderer.setText((String)value);
            this.stringRenderer.setOpaque(true);
            this.stringRenderer.setBackground(new Color(221, 221, 221));
            if (isSelected && hasFocus) {
                table.editCellAt(row, 1);
            }
            return this.stringRenderer;
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    private String generateJoinStr(Object value) {
        MondrianGuiDef.Join currentJoin = (MondrianGuiDef.Join)((Object)value);
        String joinStr = "<html>" + this.generateLeftRightStr((Object)currentJoin.left) + " <b>JOIN</b> " + this.generateLeftRightStr((Object)currentJoin.right) + "</html>";
        return joinStr;
    }

    private String generateLeftRightStr(Object value) {
        MondrianGuiDef.Relation currentObj = (MondrianGuiDef.Relation)((Object)value);
        if (currentObj instanceof MondrianGuiDef.Table) {
            return ((MondrianGuiDef.Table)currentObj).alias == null || ((MondrianGuiDef.Table)currentObj).alias.equals("") ? ((MondrianGuiDef.Table)currentObj).name : ((MondrianGuiDef.Table)currentObj).alias;
        }
        MondrianGuiDef.Join currentJoin = (MondrianGuiDef.Join)currentObj;
        String joinStr = "(" + this.generateLeftRightStr((Object)currentJoin.left) + " <b>JOIN</b> " + this.generateLeftRightStr((Object)currentJoin.right) + ")";
        return joinStr;
    }

    void setTableRendererHeight(JTable relationTable, JPanel relationRenderer) {
        int tableH = 0;
        int tableW = 0;
        Object value = null;
        for (int i = 0; i < relationTable.getRowCount(); ++i) {
            TableCellRenderer renderer = relationTable.getCellRenderer(i, 1);
            Component comp = renderer.getTableCellRendererComponent(relationTable, relationTable.getValueAt(i, 1), false, false, i, 1);
            try {
                int height = 0;
                int width = 0;
                if (comp != null) {
                    height = comp.getMaximumSize().height;
                    width = comp.getMaximumSize().width;
                    relationTable.setRowHeight(i, height);
                }
                if ((value = relationTable.getValueAt(i, 1)) instanceof MondrianGuiDef.Relation) {
                    tableH += comp.getPreferredSize().height;
                    tableW = Math.max(tableW, comp.getPreferredSize().width + this.stringRenderer.getMaximumSize().width);
                    continue;
                }
                if (value == null) {
                    tableH += this.stringRenderer.getMaximumSize().height;
                    tableW = Math.max(tableW, this.stringRenderer.getMaximumSize().width * 2);
                    continue;
                }
                tableH += height;
                tableW = Math.max(tableW, width * 2);
                continue;
            }
            catch (Exception ea) {
                // empty catch block
            }
        }
        relationTable.setPreferredSize(new Dimension(tableW, tableH));
        relationTable.setPreferredScrollableViewportSize(relationTable.getPreferredSize());
        if (relationRenderer != null) {
            relationRenderer.setPreferredSize(this.jScrollPaneT.getPreferredSize());
            relationRenderer.setMaximumSize(this.jScrollPaneT.getPreferredSize());
        }
    }
}

