/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class CloneableEditor
extends CloneableTopComponent
implements CloneableEditorSupport.Pane {
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    protected JEditorPane pane;
    private CloneableEditorSupport support;
    private boolean initialized;
    private int cursorPosition = -1;
    private Component customComponent;
    private JToolBar customToolbar;

    public CloneableEditor() {
        this(null);
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport) {
        this.support = cloneableEditorSupport;
        this.updateName();
        this._setCloseOperation();
    }

    private void _setCloseOperation() {
        this.setCloseOperation(0);
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx;
        EditorKit editorKit = this.support.cesKit();
        HelpCtx helpCtx2 = helpCtx = editorKit == null ? null : HelpCtx.findHelp((Object)editorKit);
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose() {
        boolean bl = super.canClose();
        return bl;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.initialize();
    }

    private void initialize() {
        Object object;
        if (this.initialized || this.discard()) {
            return;
        }
        this.initialized = true;
        Task task = this.support.prepareDocument();
        task.waitFinished();
        StyledDocument styledDocument = this.support.getDocument();
        this.setLayout(new BorderLayout());
        QuietEditorPane quietEditorPane = new QuietEditorPane();
        quietEditorPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CloneableEditor.class, (String)"ACS_CloneableEditor_QuietEditorPane", (Object)this.getName()));
        quietEditorPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneableEditor.class, (String)"ACSD_CloneableEditor_QuietEditorPane", (Object)this.getAccessibleContext().getAccessibleDescription()));
        this.pane = quietEditorPane;
        ActionMap actionMap = this.getActionMap();
        ActionMap actionMap2 = quietEditorPane.getActionMap();
        actionMap.setParent(actionMap2);
        actionMap2.put("cut-to-clipboard", this.getAction("cut-to-clipboard"));
        actionMap2.put("copy-to-clipboard", this.getAction("copy-to-clipboard"));
        actionMap2.put("delete", this.getAction("delete-next"));
        actionMap2.put("paste-from-clipboard", this.getAction("paste-from-clipboard"));
        quietEditorPane.setEditorKit(this.support.cesKit());
        quietEditorPane.setDocument(styledDocument);
        if (styledDocument instanceof NbDocument.CustomEditor) {
            object = (NbDocument.CustomEditor)((Object)styledDocument);
            this.customComponent = object.createEditor(quietEditorPane);
            if (this.customComponent == null) {
                throw new IllegalStateException("Document:" + styledDocument + " implementing NbDocument.CustomEditor may not" + " return null component");
            }
            this.add(this.support.wrapEditorComponent(this.customComponent), "Center");
        } else {
            object = new JScrollPane(quietEditorPane);
            quietEditorPane.setBorder(null);
            this.add(this.support.wrapEditorComponent((Component)object), "Center");
        }
        if (styledDocument instanceof NbDocument.CustomToolbar) {
            object = (NbDocument.CustomToolbar)((Object)styledDocument);
            this.customToolbar = object.createToolbar(quietEditorPane);
            if (this.customToolbar == null) {
                throw new IllegalStateException("Document:" + styledDocument + " implementing NbDocument.CustomToolbar may not" + " return null toolbar");
            }
            Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
            this.customToolbar.setBorder(border);
            this.add(this.customToolbar, "North");
        }
        quietEditorPane.setWorking(3);
        if (this.cursorPosition != -1 && (object = quietEditorPane.getCaret()) != null) {
            object.setDot(this.cursorPosition);
        }
        this.support.ensureAnnotationsLoaded();
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    protected void componentOpened() {
        super.componentOpened();
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
        }
    }

    protected void componentClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CloneableEditor.this.removeAll();
                CloneableEditor.this.customComponent = null;
                CloneableEditor.this.customToolbar = null;
                CloneableEditor.this.pane = null;
                CloneableEditor.this.initialized = false;
            }
        });
        super.componentClosed();
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
        }
    }

    public void open(Workspace workspace) {
        if (this.discard()) {
            Logger.getAnonymousLogger().warning("Can not open " + this + " component," + " its support environment is not valid" + " [support=" + (Object)((Object)this.support) + ", env=" + (this.support == null ? null : this.support.cesEnv()) + "]");
        } else {
            this.dockIfNeeded();
            super.open(workspace);
        }
    }

    protected boolean closeLast() {
        if (!this.support.canClose()) {
            return false;
        }
        this.support.notifyClosed();
        if (this.support.getLastSelected() == this) {
            this.support.setLastSelected(null);
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public Action[] getActions() {
        Action[] actionArray = super.getActions();
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Class<SystemAction> clazz = Class.forName("org.openide.actions.FileSystemAction", true, classLoader).asSubclass(SystemAction.class);
            SystemAction systemAction = (SystemAction)SystemAction.findObject(clazz, (boolean)true);
            Action[] actionArray2 = new Action[actionArray.length + 1];
            System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
            actionArray2[actionArray.length] = systemAction;
            return actionArray2;
        }
        catch (Exception exception) {
            return actionArray;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            this.customComponent.requestFocus();
        } else if (this.pane != null) {
            this.pane.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public boolean requestDefaultFocus() {
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(rectangle.width / 2, rectangle.height / 2);
    }

    private Action getAction(String string) {
        if (string == null) {
            return null;
        }
        EditorKit editorKit = this.support.cesKit();
        if (editorKit == null) {
            return null;
        }
        Action[] actionArray = editorKit.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!string.equals(actionArray[i].getValue("Name"))) continue;
            return actionArray[i];
        }
        return null;
    }

    protected void componentActivated() {
        this.support.setLastSelected(this);
    }

    public void updateName() {
        final CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    String string = cloneableEditorSupport.messageHtmlName();
                    CloneableEditor.this.setHtmlDisplayName(string);
                    string = cloneableEditorSupport.messageName();
                    CloneableEditor.this.setDisplayName(string);
                    CloneableEditor.this.setName(string);
                    CloneableEditor.this.setToolTipText(cloneableEditorSupport.messageToolTip());
                }
            });
        }
    }

    protected String preferredID() {
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.documentID();
        }
        return "";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.support != null ? this.support.cesEnv() : null);
        int n = 0;
        JEditorPane jEditorPane = this.pane;
        if (jEditorPane != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret != null) {
                n = caret.getDot();
            } else if (jEditorPane instanceof QuietEditorPane) {
                int n2 = ((QuietEditorPane)jEditorPane).getLastPosition();
                if (n2 == -1) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Pane=" + jEditorPane + "was not initialized yet!"));
                } else {
                    n = n2;
                }
            } else {
                StyledDocument styledDocument;
                StyledDocument styledDocument2 = styledDocument = this.support != null ? this.support.getDocument() : null;
                if (styledDocument != null) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Caret is null in editor pane=" + jEditorPane + "\nsupport=" + (Object)((Object)this.support) + "\ndoc=" + styledDocument));
                }
            }
        }
        objectOutput.writeObject(new Integer(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof CloneableOpenSupport.Env) {
            CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)object;
            CloneableOpenSupport cloneableOpenSupport = env.findCloneableOpenSupport();
            this.support = (CloneableEditorSupport)cloneableOpenSupport;
        }
        int n = (Integer)objectInput.readObject();
        if (!this.discard()) {
            this.cursorPosition = n;
        }
        this.updateName();
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.support.initializeCloneableEditor(this);
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.cesEnv().isValid();
    }

    private void dockIfNeeded() {
        Mode mode = WindowManager.getDefault().findMode((TopComponent)this);
        if (null == mode) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (null != topComponent) {
                mode = WindowManager.getDefault().findMode(topComponent);
                if (!WindowManager.getDefault().isEditorMode(mode)) {
                    mode = null;
                }
            }
            if (null == mode) {
                mode = WindowManager.getDefault().findMode("editor");
            }
            if (null != mode) {
                mode.dockInto((TopComponent)this);
            } else {
                Logger.getAnonymousLogger().warning("The window system cannot find the default editor mode.");
            }
        }
    }

    public CloneableTopComponent getComponent() {
        return this;
    }

    public JEditorPane getEditorPane() {
        this.initialize();
        return this.pane;
    }

    public void ensureVisible() {
        this.open();
        this.requestVisible();
    }
}

