/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;

public abstract class AbstractEntityLoader
extends OuterJoinLoader {
    private final OuterJoinLoadable persister;
    private String alias;

    public AbstractEntityLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, Map enabledFilters) {
        super(factory, enabledFilters);
        this.persister = persister;
        this.alias = this.generateRootAlias(persister.getEntityName());
    }

    protected final void initAll(String whereString, String orderByString, LockMode lockMode) throws MappingException {
        List associations = this.walkEntityTree(this.persister, this.getAlias());
        ArrayList<OuterJoinableAssociation> allAssociations = new ArrayList<OuterJoinableAssociation>();
        allAssociations.addAll(associations);
        allAssociations.add(new OuterJoinableAssociation(this.persister.getEntityType(), null, null, this.alias, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(allAssociations, lockMode);
        this.initStatementString(associations, whereString, orderByString, lockMode);
    }

    protected final void initProjection(String projectionString, String whereString, String orderByString, String groupByString, LockMode lockMode) throws MappingException {
        List associations = this.walkEntityTree(this.persister, this.getAlias());
        this.persisters = new Loadable[0];
        this.initStatementString(associations, projectionString, whereString, orderByString, groupByString, lockMode);
    }

    private void initStatementString(List associations, String condition, String orderBy, LockMode lockMode) throws MappingException {
        this.initStatementString(associations, null, condition, orderBy, "", lockMode);
    }

    private void initStatementString(List associations, String projection, String condition, String orderBy, String groupBy, LockMode lockMode) throws MappingException {
        int joins = AbstractEntityLoader.countEntityPersisters(associations);
        this.suffixes = AbstractEntityLoader.generateSuffixes(joins + 1);
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select(this.getDialect()).setLockMode(lockMode).setSelectClause(projection == null ? this.persister.selectFragment(this.alias, this.suffixes[joins]) + this.selectString(associations) : projection).setFromClause(this.persister.fromTableFragment(this.alias) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(condition).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + this.getWhereFragment()).setOrderByClause(this.orderBy(associations, orderBy)).setGroupByClause(groupBy);
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment(this.getComment());
        }
        this.sql = select.toStatementString();
    }

    protected String getWhereFragment() throws MappingException {
        return this.persister.whereJoinFragment(this.alias, true, true);
    }

    protected final Loadable getPersister() {
        return this.persister;
    }

    protected final String getAlias() {
        return this.alias;
    }

    protected boolean isJoinedFetchEnabled(AssociationType type, FetchMode config) {
        return this.isJoinedFetchEnabledInMapping(config, type);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getPersister().getEntityName() + ')';
    }

    public abstract String getComment();
}

