/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class AuthenticationDialog
extends JDialog
implements LanguageChangedListener {
    JTextField username;
    JPasswordField password;
    JLabel lblUserName;
    JLabel lblPassword;
    JButton jb;

    public AuthenticationDialog(JDialog owner) {
        super((Frame)null, I18n.getString("frame.authentication"), true);
        JPanel jp = new JPanel(new GridLayout(2, 2));
        this.lblUserName = new JLabel(I18n.getString("label.userName"));
        this.lblPassword = new JLabel(I18n.getString("label.password"));
        this.jb = new JButton(I18n.getString("btn.ok"));
        jp.add(this.lblUserName);
        this.username = new JTextField();
        this.username.setFont(new Font("Monospaced", 1, 16));
        jp.add(this.username);
        jp.add(this.lblPassword);
        this.password = new JPasswordField();
        this.password.setFont(new Font("Monospaced", 1, 16));
        jp.add(this.password);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jp, "Center");
        this.jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                S.out("disposing...");
                AuthenticationDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.jb, "South");
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(sd.width / 2 - 125, sd.height / 2 - 60);
        this.setResizable(false);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        this.setSize(250, 120);
        this.setVisible(true);
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public char[] getPasswordCA() {
        return this.password.getPassword();
    }

    public String getUsername() {
        return this.username.getText();
    }

    public static void main(String[] args) {
        new AuthenticationDialog(null);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.lblUserName.setText(I18n.getString("label.userName"));
        this.lblPassword.setText(I18n.getString("label.password"));
        this.jb.setText(I18n.getString("btn.ok"));
    }
}

