/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.XOMUtil;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class W3CDOMWrapper
implements DOMWrapper {
    private Node node;

    public W3CDOMWrapper(Node node) {
        this.node = node;
    }

    public int getType() {
        short s = this.node.getNodeType();
        switch (s) {
            case 1: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public String getTagName() {
        if (this.getType() != 2) {
            return null;
        }
        return ((Element)this.node).getTagName();
    }

    public String getAttribute(String string) {
        if (this.getType() != 2) {
            return null;
        }
        String string2 = ((Element)this.node).getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public String[] getAttributeNames() {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        int n = namedNodeMap.getLength();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = namedNodeMap.item(i).getLocalName();
        }
        return stringArray;
    }

    public String getText() {
        if (this.node instanceof Comment) {
            return ((Comment)this.node).getData();
        }
        StringBuffer stringBuffer = new StringBuffer();
        W3CDOMWrapper.appendNodeText(this.node, stringBuffer);
        return stringBuffer.toString();
    }

    public String toXML() {
        boolean bl = false;
        return XOMUtil.wrapperToXml(this, bl);
    }

    private static void appendNodeText(Node node, StringBuffer stringBuffer) {
        if (!(node instanceof Comment)) {
            if (node instanceof CharacterData) {
                stringBuffer.append(((CharacterData)node).getData());
            } else if (node instanceof Element) {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    W3CDOMWrapper.appendNodeText(nodeList.item(i), stringBuffer);
                }
            }
        }
    }

    public DOMWrapper[] getChildren() {
        if (this.getType() != 2) {
            return new DOMWrapper[0];
        }
        NodeList nodeList = this.node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) && !(node instanceof Text)) continue;
            ++n;
        }
        DOMWrapper[] dOMWrapperArray = new DOMWrapper[n];
        n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) && !(node instanceof Text)) continue;
            dOMWrapperArray[n++] = new W3CDOMWrapper(node);
        }
        return dOMWrapperArray;
    }

    public DOMWrapper[] getElementChildren() {
        if (this.getType() != 2) {
            return new DOMWrapper[0];
        }
        NodeList nodeList = this.node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            ++n;
        }
        DOMWrapper[] dOMWrapperArray = new DOMWrapper[n];
        n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            dOMWrapperArray[n++] = new W3CDOMWrapper(node);
        }
        return dOMWrapperArray;
    }
}

