/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.lib.lexer.IntegerCache;

public abstract class LAState {
    private static final LAState EMPTY = new NoState(0);
    private static final LAState INIT_STATE = new NoState(0);
    int gapStart;
    int gapLength;

    public static LAState empty() {
        return EMPTY;
    }

    public static LAState initState() {
        return INIT_STATE;
    }

    static int withExtraCapacity(int n) {
        return n * 3 / 2 + 4;
    }

    static boolean isByteState(Object object) {
        int n;
        return object.getClass() == Integer.class && (n = ((Integer)object).intValue()) >= 0 && n <= 127;
    }

    public LAState(int n) {
        this.gapLength = n;
    }

    public abstract int lookahead(int var1);

    public abstract Object state(int var1);

    public final LAState trimToSize() {
        if (this.gapLength > 0) {
            LAState lAState = this.upgrade(this.size(), this.getClass());
            this.reallocate(lAState, this.size());
            return lAState;
        }
        return this;
    }

    public final int size() {
        return this.capacity() - this.gapLength;
    }

    public final LAState add(int n, Object object) {
        LAState lAState;
        if (this.gapLength > 0) {
            this.moveGap(this.size());
            lAState = this;
        } else {
            lAState = this.upgrade(this.capacity() + 1 << 1, this.getClass());
            this.reallocate(lAState, this.size());
        }
        Class clazz = lAState.addToGapStart(n, object);
        if (clazz != null) {
            lAState = this.upgrade(this.capacity() + 1, clazz);
            this.reallocate(lAState, this.size());
            lAState.addToGapStart(n, object);
        }
        ++lAState.gapStart;
        --lAState.gapLength;
        return lAState;
    }

    public final LAState addAll(int n, LAState lAState) {
        LAState lAState2;
        int n2 = lAState.size();
        if (!this.isUpgrade(lAState.getClass()) && this.gapLength > n2) {
            this.moveGap(n);
            lAState2 = this;
        } else {
            lAState2 = this.upgrade((int)((long)(this.capacity() + n2) * 110L / 100L), lAState.getClass());
            this.reallocate(lAState2, n);
        }
        lAState.copyData(0, lAState2, lAState2.gapStart, lAState.gapStart);
        int n3 = lAState.gapStart + lAState.gapLength;
        lAState.copyData(n3, lAState2, lAState2.gapStart + lAState.gapStart, lAState.capacity() - n3);
        lAState2.gapStart += n2;
        lAState2.gapLength -= n2;
        return lAState2;
    }

    protected abstract LAState upgrade(int var1, Class var2);

    protected abstract boolean isUpgrade(Class var1);

    protected abstract Class addToGapStart(int var1, Object var2);

    public final void remove(int n, int n2) {
        this.moveGap(n + n2);
        this.removeUpdate(n, n2);
        this.gapStart -= n2;
        this.gapLength += n2;
    }

    protected void removeUpdate(int n, int n2) {
    }

    protected final int rawIndex(int n) {
        return n < this.gapStart ? n : n + this.gapLength;
    }

    final void reallocate(LAState lAState, int n) {
        lAState.gapStart = n;
        lAState.gapLength = this.gapLength + lAState.capacity() - this.capacity();
        int n2 = this.gapStart + this.gapLength;
        if (n < this.gapStart) {
            this.copyData(0, lAState, 0, n);
            int n3 = n + lAState.gapLength;
            int n4 = this.gapStart - n;
            this.copyData(n, lAState, n3, n4);
            this.copyData(n2, lAState, n3 += n4, this.capacity() - n2);
        } else {
            this.copyData(0, lAState, 0, this.gapStart);
            int n5 = n - this.gapStart;
            this.copyData(n2, lAState, this.gapStart, n5);
            this.copyData(n2 += n5, lAState, n + lAState.gapLength, this.capacity() - n2);
        }
    }

    protected abstract void copyData(int var1, LAState var2, int var3, int var4);

    protected abstract int capacity();

    final void moveGap(int n) {
        if (n == this.gapStart) {
            return;
        }
        if (this.gapLength > 0) {
            if (n < this.gapStart) {
                int n2 = this.gapStart - n;
                this.moveData(n, this.gapStart + this.gapLength - n2, n2);
            } else {
                int n3 = this.gapStart + this.gapLength;
                int n4 = n - this.gapStart;
                this.moveData(n3, this.gapStart, n4);
                if (n < n3) {
                    // empty if block
                }
            }
        }
        this.gapStart = n;
    }

    protected abstract void moveData(int var1, int var2, int var3);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.lookahead(i));
            stringBuilder.append(", ");
            stringBuilder.append(this.state(i));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static final class LargeState
    extends LAState {
        int[] lookaheads;
        Object[] states;

        LargeState(int n) {
            super(n);
            this.lookaheads = new int[n];
            this.states = new Object[n];
        }

        public int lookahead(int n) {
            return this.lookaheads[this.rawIndex(n)];
        }

        public Object state(int n) {
            return this.states[this.rawIndex(n)];
        }

        protected LAState upgrade(int n, Class clazz) {
            return new LargeState(n);
        }

        protected boolean isUpgrade(Class clazz) {
            return false;
        }

        protected void copyData(int n, LAState lAState, int n2, int n3) {
            System.arraycopy(this.lookaheads, n, ((LargeState)lAState).lookaheads, n2, n3);
            System.arraycopy(this.states, n, ((LargeState)lAState).states, n2, n3);
        }

        protected void moveData(int n, int n2, int n3) {
            System.arraycopy(this.lookaheads, n, this.lookaheads, n2, n3);
            System.arraycopy(this.states, n, this.states, n2, n3);
        }

        protected Class addToGapStart(int n, Object object) {
            this.lookaheads[this.gapStart] = n;
            this.states[this.gapStart] = object;
            return null;
        }

        protected void removeUpdate(int n, int n2) {
            while (--n2 >= 0) {
                this.states[n + n2] = null;
            }
        }

        protected int capacity() {
            return this.lookaheads.length;
        }
    }

    static final class ByteState
    extends LAState {
        short[] laStateShorts;

        ByteState(int n) {
            super(n);
            this.laStateShorts = new short[n];
        }

        public int lookahead(int n) {
            return this.laStateShorts[this.rawIndex(n)] & 0xFF;
        }

        public Object state(int n) {
            int n2 = this.laStateShorts[this.rawIndex(n)] & 0xFF00;
            return n2 == 65280 ? null : IntegerCache.integer(n2 >> 8);
        }

        protected LAState upgrade(int n, Class clazz) {
            if (clazz == LargeState.class) {
                return new LargeState(n);
            }
            return new ByteState(n);
        }

        protected boolean isUpgrade(Class clazz) {
            return clazz == LargeState.class;
        }

        protected void copyData(int n, LAState lAState, int n2, int n3) {
            if (lAState.getClass() == this.getClass()) {
                System.arraycopy(this.laStateShorts, n, ((ByteState)lAState).laStateShorts, n2, n3);
            } else {
                int[] nArray = ((LargeState)lAState).lookaheads;
                Object[] objectArray = ((LargeState)lAState).states;
                while (--n3 >= 0) {
                    int n4 = this.laStateShorts[n++] & 0xFFFF;
                    nArray[n2] = n4 & 0xFF;
                    if ((n4 &= 0xFF00) != 65280) {
                        objectArray[n2] = IntegerCache.integer(n4 >> 8);
                    }
                    ++n2;
                }
            }
        }

        protected void moveData(int n, int n2, int n3) {
            System.arraycopy(this.laStateShorts, n, this.laStateShorts, n2, n3);
        }

        protected Class addToGapStart(int n, Object object) {
            if (n <= 127) {
                int n2;
                if (object == null) {
                    n2 = 65280;
                } else if (ByteState.isByteState(object)) {
                    n2 = (Integer)object << 8;
                } else {
                    return LargeState.class;
                }
                this.laStateShorts[this.gapStart] = (short)(n2 | n);
                return null;
            }
            return LargeState.class;
        }

        protected int capacity() {
            return this.laStateShorts.length;
        }
    }

    static final class NoState
    extends LAState {
        byte[] laBytes;

        NoState(int n) {
            super(n);
            this.laBytes = new byte[n];
        }

        public int lookahead(int n) {
            int n2 = this.rawIndex(n);
            return this.laBytes[n2];
        }

        public Object state(int n) {
            return null;
        }

        protected LAState upgrade(int n, Class clazz) {
            if (clazz == LargeState.class) {
                return new LargeState(n);
            }
            if (clazz == ByteState.class) {
                return new ByteState(n);
            }
            return new NoState(n);
        }

        protected boolean isUpgrade(Class clazz) {
            return clazz == LargeState.class || clazz == ByteState.class;
        }

        protected void copyData(int n, LAState lAState, int n2, int n3) {
            if (lAState.getClass() == this.getClass()) {
                System.arraycopy(this.laBytes, n, ((NoState)lAState).laBytes, n2, n3);
            } else if (lAState.getClass() == ByteState.class) {
                short[] sArray = ((ByteState)lAState).laStateShorts;
                while (--n3 >= 0) {
                    sArray[n2++] = (short)(this.laBytes[n++] | 0xFF00);
                }
            } else {
                int[] nArray = ((LargeState)lAState).lookaheads;
                while (--n3 >= 0) {
                    nArray[n2++] = this.laBytes[n++];
                }
            }
        }

        protected void moveData(int n, int n2, int n3) {
            System.arraycopy(this.laBytes, n, this.laBytes, n2, n3);
        }

        protected Class addToGapStart(int n, Object object) {
            if (n <= 127) {
                if (object == null) {
                    this.laBytes[this.gapStart] = (byte)n;
                    return null;
                }
                if (NoState.isByteState(object)) {
                    return ByteState.class;
                }
            }
            return LargeState.class;
        }

        protected int capacity() {
            return this.laBytes.length;
        }
    }
}

