/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.PrintContainer;

interface DrawGraphics {
    public void setForeColor(Color var1);

    public void setBackColor(Color var1);

    public void setDefaultBackColor(Color var1);

    public void setStrikeThroughColor(Color var1);

    public void setUnderlineColor(Color var1);

    public void setWaveUnderlineColor(Color var1);

    public void setFont(Font var1);

    public void setX(int var1);

    public void setY(int var1);

    public void setLineHeight(int var1);

    public void setLineAscent(int var1);

    public Graphics getGraphics();

    public boolean supportsLineNumbers();

    public void init(DrawContext var1);

    public void finish();

    public void fillRect(int var1);

    public void drawChars(int var1, int var2, int var3);

    public void drawTabs(int var1, int var2, int var3, int var4);

    public void setBuffer(char[] var1);

    public boolean targetOffsetReached(int var1, char var2, int var3, int var4, DrawContext var5);

    public void eol();

    public void setView(View var1);

    public static final class PrintDG
    extends SimpleDG {
        PrintContainer container;
        boolean lineInited;

        public PrintDG(PrintContainer printContainer) {
            this.container = printContainer;
        }

        public boolean supportsLineNumbers() {
            return true;
        }

        public void drawChars(int n, int n2, int n3) {
            if (n2 > 0) {
                this.lineInited = true;
                char[] cArray = new char[n2];
                System.arraycopy(this.buffer, n, cArray, 0, n2);
                this.container.add(cArray, this.font, this.foreColor, this.backColor);
            }
        }

        private void printSpaces(int n) {
            char[] cArray = new char[n];
            System.arraycopy(Analyzer.getSpacesBuffer(n), 0, cArray, 0, n);
            this.container.add(cArray, this.font, this.foreColor, this.backColor);
        }

        public void drawTabs(int n, int n2, int n3, int n4) {
            this.lineInited = true;
            this.printSpaces(n3);
        }

        public void eol() {
            if (!this.lineInited && this.container.initEmptyLines()) {
                this.printSpaces(1);
            }
            this.container.eol();
            this.lineInited = false;
        }
    }

    public static final class GraphicsDG
    extends SimpleDG {
        private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.draw.graphics");
        private Graphics graphics;
        private int startOffset = -1;
        private int endOffset;
        private int startX;
        private int startY;
        private int width;
        private Color strikeThroughColor;
        private Color underlineColor;
        private Color waveUnderlineColor;
        private int lastDrawnAnnosY;
        private int lastDrawnAnnosX;
        private AnnotationDesc[] passiveAnnosAtY;
        private AlphaComposite alpha = null;
        private Annotations annos = null;
        private boolean drawTextLimitLine;
        private int textLimitWidth;
        private int defaultSpaceWidth;
        private Color textLimitLineColor;
        private int absoluteX;
        private int maxWidth;
        private View view;
        private int bufferStartOffset;
        private int frameStartOffset;
        private int frameEndOffset = this.frameStartOffset = Integer.MAX_VALUE;
        private JTextComponent component;
        private PropertyChangeListener componentListener;

        GraphicsDG(Graphics graphics) {
            this.graphics = graphics;
            this.y = -1;
        }

        public void setForeColor(Color color) {
            if (!color.equals(this.foreColor)) {
                this.flush();
                this.foreColor = color;
            }
        }

        public void setBackColor(Color color) {
            if (!color.equals(this.backColor)) {
                this.flush();
                this.backColor = color;
            }
        }

        public void setStrikeThroughColor(Color color) {
            if (!(color == this.strikeThroughColor || color != null && color.equals(this.strikeThroughColor))) {
                this.flush();
                this.strikeThroughColor = color;
            }
        }

        public void setUnderlineColor(Color color) {
            if (!(color == this.underlineColor || color != null && color.equals(this.underlineColor))) {
                this.flush();
                this.underlineColor = color;
            }
        }

        public void setWaveUnderlineColor(Color color) {
            if (!(color == this.waveUnderlineColor || color != null && color.equals(this.waveUnderlineColor))) {
                this.flush();
                this.waveUnderlineColor = color;
            }
        }

        public void setFont(Font font) {
            if (!font.equals(this.font)) {
                this.flush();
                this.font = font;
            }
        }

        public void setX(int n) {
            if (n != this.x) {
                this.flush();
                this.x = n;
            }
        }

        public void setY(int n) {
            if (n != this.y) {
                this.flush();
                this.y = n;
            }
        }

        public void init(DrawContext drawContext) {
            this.component = drawContext.getEditorUI().getComponent();
            this.annos = drawContext.getEditorUI().getDocument().getAnnotations();
            this.drawTextLimitLine = drawContext.getEditorUI().textLimitLineVisible;
            this.textLimitWidth = drawContext.getEditorUI().textLimitWidth();
            this.defaultSpaceWidth = drawContext.getEditorUI().defaultSpaceWidth;
            this.textLimitLineColor = drawContext.getEditorUI().textLimitLineColor;
            this.absoluteX = drawContext.getEditorUI().getTextMargin().left;
            this.maxWidth = drawContext.getEditorUI().getExtentBounds().width;
            this.componentListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("text-frame-start-position".equals(propertyChangeEvent.getPropertyName())) {
                        if (propertyChangeEvent.getNewValue() instanceof Position) {
                            GraphicsDG.this.frameStartOffset = ((Position)propertyChangeEvent.getNewValue()).getOffset();
                        } else {
                            GraphicsDG.this.frameStartOffset = Integer.MAX_VALUE;
                        }
                    }
                    if ("text-frame-end-position".equals(propertyChangeEvent.getPropertyName())) {
                        if (propertyChangeEvent.getNewValue() instanceof Position) {
                            GraphicsDG.this.frameEndOffset = ((Position)propertyChangeEvent.getNewValue()).getOffset();
                        } else {
                            GraphicsDG.this.frameEndOffset = Integer.MAX_VALUE;
                        }
                    }
                }
            };
            this.component.addPropertyChangeListener(this.componentListener);
        }

        public void finish() {
            if (this.component != null) {
                this.component.removePropertyChangeListener(this.componentListener);
            }
        }

        public void setView(View view) {
            this.view = view;
        }

        private void flush() {
            this.flush(false);
        }

        private void flush(boolean bl) {
            int n;
            Object object;
            Object object2;
            if (this.y < 0) {
                return;
            }
            if (this.startOffset >= 0 && this.startOffset != this.endOffset) {
                this.fillRectImpl(this.startX, this.startY, this.x - this.startX);
            }
            if (this.lastDrawnAnnosY != this.y) {
                this.lastDrawnAnnosY = this.y;
                this.lastDrawnAnnosX = 0;
                if (AnnotationTypes.getTypes().isBackgroundDrawing().booleanValue()) {
                    if (this.alpha == null) {
                        this.alpha = AlphaComposite.getInstance(3, (float)AnnotationTypes.getTypes().getBackgroundGlyphAlpha().intValue() / 100.0f);
                    }
                    if (this.view != null) {
                        this.passiveAnnosAtY = this.annos.getPassiveAnnotations(this.view.getStartOffset());
                    }
                } else {
                    this.passiveAnnosAtY = null;
                }
            }
            int n2 = 2;
            if (this.passiveAnnosAtY != null) {
                object2 = (Graphics2D)this.graphics;
                Shape shape = this.graphics.getClip();
                object = ((Graphics2D)object2).getComposite();
                ((Graphics2D)object2).setComposite(this.alpha);
                int n3 = bl ? Integer.MAX_VALUE : this.x;
                int n4 = Math.min(this.lastDrawnAnnosX, this.startX);
                Rectangle rectangle = new Rectangle(n4, this.y, n3 - n4, this.lineHeight);
                this.lastDrawnAnnosX = n3;
                rectangle = rectangle.intersection(shape.getBounds());
                this.graphics.setClip(rectangle);
                for (n = 0; n < this.passiveAnnosAtY.length; ++n) {
                    ((Graphics)object2).drawImage(this.passiveAnnosAtY[n].getGlyph(), n2, this.y, null);
                    n2 += this.passiveAnnosAtY[n].getGlyph().getWidth(null) + 1;
                }
                this.graphics.setClip(shape);
                ((Graphics2D)object2).setComposite((Composite)object);
            }
            if (this.startOffset < 0 || this.startOffset >= this.endOffset || this.endOffset > this.buffer.length) {
                this.startOffset = -1;
                return;
            }
            if (this.drawTextLimitLine) {
                object2 = this.graphics.getClipBounds();
                int n5 = this.absoluteX + this.textLimitWidth * this.defaultSpaceWidth;
                if (n5 >= this.startX && n5 <= this.x) {
                    object = this.graphics.getColor();
                    this.graphics.setColor(this.textLimitLineColor);
                    this.graphics.drawLine(n5, this.startY, n5, this.startY + this.lineHeight);
                    this.graphics.setColor((Color)object);
                }
            }
            if (this.frameStartOffset != Integer.MAX_VALUE && this.bufferStartOffset != -1) {
                if (this.bufferStartOffset + this.startOffset == this.frameStartOffset) {
                    this.graphics.drawLine(this.startX, this.startY, this.startX, this.startY + this.lineHeight);
                }
                if (this.bufferStartOffset + this.startOffset >= this.frameStartOffset && this.bufferStartOffset + this.endOffset <= this.frameEndOffset) {
                    this.graphics.drawLine(this.startX, this.startY, this.x, this.startY);
                    this.graphics.drawLine(this.startX, this.startY, this.x, this.startY + this.lineHeight);
                }
                if (this.bufferStartOffset + this.endOffset == this.frameEndOffset) {
                    this.graphics.drawLine(this.x, this.startY, this.x, this.startY + this.lineHeight);
                }
            }
            this.graphics.setColor(this.foreColor);
            this.graphics.setFont(this.font);
            if (debug) {
                object2 = new String(this.buffer, this.startOffset, this.endOffset - this.startOffset);
                System.out.println("DrawGraphics: text='" + (String)object2 + "', text.length=" + ((String)object2).length() + ", x=" + this.startX + ", y=" + this.startY + ", ascent=" + this.lineAscent + ", clip=" + this.graphics.getClipBounds() + ", color=" + this.graphics.getColor());
            }
            this.graphics.drawChars(this.buffer, this.startOffset, this.endOffset - this.startOffset, this.startX, this.startY + this.lineAscent);
            if (this.strikeThroughColor != null) {
                object2 = FontMetricsCache.getInfo(this.font);
                this.graphics.setColor(this.strikeThroughColor);
                this.graphics.fillRect(this.startX, (int)((double)((float)this.startY + object2.getStrikethroughOffset(this.graphics) + (float)this.lineAscent) + 1.5), this.x - this.startX, Math.max(1, Math.round(object2.getStrikethroughThickness(this.graphics))));
            }
            if (this.waveUnderlineColor != null) {
                object2 = FontMetricsCache.getInfo(this.font);
                this.graphics.setColor(this.waveUnderlineColor);
                int n6 = this.x - this.startX;
                if (n6 > 0) {
                    object = new int[]{0, 0, -1, -1};
                    int[] nArray = new int[n6 + 1];
                    int[] nArray2 = new int[n6 + 1];
                    int n7 = (int)((double)((float)this.startY + object2.getUnderlineOffset(this.graphics) + (float)this.lineAscent) + 1.5);
                    for (n = 0; n <= n6; ++n) {
                        nArray[n] = this.startX + n;
                        nArray2[n] = n7 + object[nArray[n] % 4];
                    }
                    this.graphics.drawPolyline(nArray, nArray2, n6);
                }
            }
            if (this.underlineColor != null) {
                object2 = FontMetricsCache.getInfo(this.font);
                this.graphics.setColor(this.underlineColor);
                this.graphics.fillRect(this.startX, (int)((double)((float)this.startY + object2.getUnderlineOffset(this.graphics) + (float)this.lineAscent) + 1.5), this.x - this.startX, Math.max(1, Math.round(object2.getUnderlineThickness(this.graphics))));
            }
            this.startOffset = -1;
        }

        public Graphics getGraphics() {
            return this.graphics;
        }

        public boolean supportsLineNumbers() {
            return true;
        }

        public void fillRect(int n) {
            this.fillRectImpl(this.x, this.y, n);
            this.x += n;
        }

        private void fillRectImpl(int n, int n2, int n3) {
            if (n3 > 0 && !this.backColor.equals(this.defaultBackColor)) {
                this.graphics.setColor(this.backColor);
                this.graphics.fillRect(n, n2, n3, this.lineHeight);
            }
        }

        public void drawChars(int n, int n2, int n3) {
            if (n2 >= 0) {
                if (this.startOffset < 0) {
                    this.startOffset = n;
                    this.endOffset = n + n2;
                    this.startX = this.x;
                    this.startY = this.y;
                    this.width = n3;
                } else {
                    this.endOffset += n2;
                }
            }
            this.x += n3;
        }

        public void drawTabs(int n, int n2, int n3, int n4) {
            if (n4 > 0) {
                this.flush();
                this.fillRectImpl(this.x, this.y, n4);
                this.x += n4;
            }
        }

        public void setBuffer(char[] cArray) {
            this.flush();
            this.buffer = cArray;
            this.startOffset = -1;
            this.bufferStartOffset = -1;
        }

        void setBufferStartOffset(int n) {
            this.bufferStartOffset = n;
        }

        public void eol() {
            int n;
            if (this.drawTextLimitLine && (n = this.absoluteX + this.textLimitWidth * this.defaultSpaceWidth) >= this.x - this.defaultSpaceWidth) {
                Color color = this.graphics.getColor();
                this.graphics.setColor(this.textLimitLineColor);
                Rectangle rectangle = this.graphics.getClipBounds();
                if (rectangle.width + rectangle.x <= n && rectangle.x < this.maxWidth) {
                    this.graphics.setClip(rectangle.x, rectangle.y, this.maxWidth - rectangle.x, rectangle.height);
                    this.graphics.drawLine(n, this.y, n, this.y + this.lineHeight);
                    this.graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    this.graphics.drawLine(n, this.y, n, this.y + this.lineHeight);
                }
                this.graphics.setColor(color);
            }
            this.flush(true);
        }
    }

    public static class SimpleDG
    extends AbstractDG {
        public Graphics getGraphics() {
            return null;
        }

        public boolean supportsLineNumbers() {
            return false;
        }

        public void init(DrawContext drawContext) {
        }

        public void finish() {
        }

        public void fillRect(int n) {
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            return true;
        }

        public void eol() {
        }
    }

    public static abstract class AbstractDG
    implements DrawGraphics {
        Color foreColor;
        Color backColor;
        Color defaultBackColor;
        Font font;
        char[] buffer;
        int x;
        int y;
        int lineHeight;
        int lineAscent;

        public Color getForeColor() {
            return this.foreColor;
        }

        public void setForeColor(Color color) {
            this.foreColor = color;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public void setBackColor(Color color) {
            this.backColor = color;
        }

        public Color getDefaultBackColor() {
            return this.defaultBackColor;
        }

        public void setDefaultBackColor(Color color) {
            this.defaultBackColor = color;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public int getLineHeight() {
            return this.lineHeight;
        }

        public void setLineHeight(int n) {
            this.lineHeight = n;
        }

        public int getLineAscent() {
            return this.lineAscent;
        }

        public void setLineAscent(int n) {
            this.lineAscent = n;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public void setBuffer(char[] cArray) {
            this.buffer = cArray;
        }

        public void drawChars(int n, int n2, int n3) {
            this.x += n3;
        }

        public void drawTabs(int n, int n2, int n3, int n4) {
            this.x += n4;
        }

        public void setStrikeThroughColor(Color color) {
        }

        public void setUnderlineColor(Color color) {
        }

        public void setWaveUnderlineColor(Color color) {
        }

        public void setView(View view) {
        }
    }
}

