/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import javax.swing.JViewport;

final class AutoscrollSupport
implements Autoscroll {
    Component comp;
    JViewport viewport;
    Insets insets;
    Insets scrollUnits;
    Insets autoscrollInsets;

    AutoscrollSupport(Component component) {
        this.comp = component;
        this.insets = new Insets(20, 10, 20, 10);
        this.scrollUnits = new Insets(20, 10, 20, 10);
    }

    public void autoscroll(Point point) {
        JViewport jViewport = this.getViewport();
        if (jViewport == null) {
            return;
        }
        Point point2 = jViewport.getViewPosition();
        int n = jViewport.getExtentSize().height;
        int n2 = jViewport.getExtentSize().width;
        if (point.y - point2.y < this.insets.top) {
            jViewport.setViewPosition(new Point(point2.x, Math.max(point2.y - this.scrollUnits.top, 0)));
        } else if (point2.y + n - point.y < this.insets.bottom) {
            jViewport.setViewPosition(new Point(point2.x, Math.min(point2.y + this.scrollUnits.bottom, this.comp.getHeight() - n)));
        } else if (point.x - point2.x < this.insets.left) {
            jViewport.setViewPosition(new Point(Math.max(point2.x - this.scrollUnits.left, 0), point2.y));
        } else if (point2.x + n2 - point.x < this.insets.right) {
            jViewport.setViewPosition(new Point(Math.min(point2.x + this.scrollUnits.right, this.comp.getWidth() - n2), point2.y));
        }
    }

    public Insets getAutoscrollInsets() {
        if (this.autoscrollInsets == null) {
            int n = this.comp.getHeight();
            int n2 = this.comp.getWidth();
            this.autoscrollInsets = new Insets(n, n2, n, n2);
        }
        return this.autoscrollInsets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getScrollUnits() {
        return this.scrollUnits;
    }

    public void setScrollUnits(Insets insets) {
        this.scrollUnits = insets;
    }

    JViewport getViewport() {
        if (this.viewport == null) {
            Component component;
            for (component = this.comp; !(component instanceof JViewport) && component != null; component = component.getParent()) {
            }
            this.viewport = (JViewport)component;
        }
        return this.viewport;
    }
}

