/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringExtensionsRegistry
implements ExtensionsRegistry {
    private static final Log log = LogFactory.getLog((Class)SpringExtensionsRegistry.class);
    private final ListableBeanFactory beanFactory;

    public SpringExtensionsRegistry(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public List getExtensions(Class extensionType) {
        String[] beanNames = this.beanFactory.getBeanNamesForType(extensionType);
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.length);
        for (int i = 0; i < beanNames.length; ++i) {
            String name = beanNames[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting bean " + name + " as extension of type " + extensionType.getName()));
            }
            Object bean = this.beanFactory.getBean(name, extensionType);
            beans.add(bean);
        }
        return beans;
    }
}

