/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;

public class JRDesignGenericElement
extends JRDesignElement
implements JRGenericElement {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_GENERIC_TYPE = "genericType";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP_NAME = "evaluationGroupName";
    public static final String PROPERTY_PARAMETERS = "parameters";
    private JRGenericElementType genericType;
    private List parameters = new ArrayList();
    private byte evaluationTime = 1;
    private String evaluationGroupName;

    public JRDesignGenericElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public JRGenericElementParameter[] getParameters() {
        return this.parameters.toArray(new JRGenericElementParameter[this.parameters.size()]);
    }

    public List getParamtersList() {
        return this.parameters;
    }

    public void addParameter(JRGenericElementParameter parameter) {
        this.parameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, this.parameters.size() - 1);
    }

    public boolean removeParameter(JRGenericElementParameter parameter) {
        int idx = this.parameters.indexOf(parameter);
        if (idx >= 0) {
            this.parameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, parameter, idx);
            return true;
        }
        return false;
    }

    public JRGenericElementParameter removeParameter(String parameterName) {
        JRGenericElementParameter removed = null;
        ListIterator it = this.parameters.listIterator();
        while (it.hasNext()) {
            JRGenericElementParameter parameter = (JRGenericElementParameter)it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            removed = parameter;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, parameter, it.nextIndex());
            break;
        }
        return removed;
    }

    public JRGenericElementType getGenericType() {
        return this.genericType;
    }

    public void setGenericType(JRGenericElementType genericType) {
        JRGenericElementType old = this.genericType;
        this.genericType = genericType;
        this.getEventSupport().firePropertyChange(PROPERTY_GENERIC_TYPE, old, this.genericType);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitGenericElement(this);
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(byte evaluationTime) {
        byte old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    public String getEvaluationGroupName() {
        return this.evaluationGroupName;
    }

    public void setEvaluationGroupName(String evaluationGroupName) {
        String old = this.evaluationGroupName;
        this.evaluationGroupName = evaluationGroupName;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP_NAME, old, this.evaluationGroupName);
    }
}

