/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Schema;
import mondrian.olap.Util;

public class Role {
    private boolean mutable = true;
    private final Map<Schema, Access> schemaGrants = new HashMap<Schema, Access>();
    private final Map<Cube, Access> cubeGrants = new HashMap<Cube, Access>();
    private final Map<Dimension, Access> dimensionGrants = new HashMap<Dimension, Access>();
    private final Map<Hierarchy, HierarchyAccess> hierarchyGrants = new HashMap<Hierarchy, HierarchyAccess>();

    protected Role clone() {
        Role role = new Role();
        role.mutable = this.mutable;
        role.schemaGrants.putAll(this.schemaGrants);
        role.cubeGrants.putAll(this.cubeGrants);
        role.dimensionGrants.putAll(this.dimensionGrants);
        for (Map.Entry<Hierarchy, HierarchyAccess> entry : this.hierarchyGrants.entrySet()) {
            role.hierarchyGrants.put(entry.getKey(), entry.getValue().clone());
        }
        return role;
    }

    public Role makeMutableClone() {
        Role role = this.clone();
        role.mutable = true;
        return role;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void grant(Schema schema, Access access) {
        assert (schema != null);
        assert (access == Access.ALL || access == Access.NONE || access == Access.ALL_DIMENSIONS);
        assert (this.isMutable());
        this.schemaGrants.put(schema, access);
    }

    public Access getAccess(Schema schema) {
        assert (schema != null);
        return Role.toAccess(this.schemaGrants.get(schema));
    }

    private static Access toAccess(Access access) {
        return access == null ? Access.NONE : access;
    }

    public void grant(Cube cube, Access access) {
        Util.assertPrecondition(cube != null, "cube != null");
        assert (access == Access.ALL || access == Access.NONE);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.cubeGrants.put(cube, access);
    }

    public Access getAccess(Cube cube) {
        assert (cube != null);
        Access access = this.cubeGrants.get(cube);
        if (access == null) {
            access = this.schemaGrants.get(cube.getSchema());
        }
        return Role.toAccess(access);
    }

    public void grant(Dimension dimension, Access access) {
        assert (dimension != null);
        assert (access == Access.ALL || access == Access.NONE);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.dimensionGrants.put(dimension, access);
    }

    public Access getAccess(Dimension dimension) {
        assert (dimension != null);
        Access access = this.dimensionGrants.get(dimension);
        if (access != null) {
            return Role.toAccess(access);
        }
        for (Map.Entry<Cube, Access> cubeGrant : this.cubeGrants.entrySet()) {
            Dimension[] dimensions;
            access = Role.toAccess(cubeGrant.getValue());
            if (access == Access.NONE) continue;
            for (Dimension dimension1 : dimensions = cubeGrant.getKey().getDimensions()) {
                if (dimension1 != dimension) continue;
                return access;
            }
        }
        switch (this.getAccess(dimension.getSchema())) {
            case ALL: 
            case ALL_DIMENSIONS: {
                return Access.ALL;
            }
        }
        return Access.NONE;
    }

    public void grant(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        assert (access != null);
        Util.assertPrecondition(access == Access.CUSTOM || topLevel == null && bottomLevel == null, "access == Access.CUSTOM) || (topLevel == null && bottomLevel == null)");
        Util.assertPrecondition(topLevel == null || topLevel.getHierarchy() == hierarchy, "topLevel == null || topLevel.getHierarchy() == hierarchy");
        Util.assertPrecondition(bottomLevel == null || bottomLevel.getHierarchy() == hierarchy, "bottomLevel == null || bottomLevel.getHierarchy() == hierarchy");
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.hierarchyGrants.put(hierarchy, new HierarchyAccess(hierarchy, access, topLevel, bottomLevel));
    }

    public Access getAccess(Hierarchy hierarchy) {
        assert (hierarchy != null);
        HierarchyAccess access = this.hierarchyGrants.get(hierarchy);
        if (access != null) {
            return access.access;
        }
        return this.getAccess(hierarchy.getDimension());
    }

    public HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        return this.hierarchyGrants.get(hierarchy);
    }

    public Access getAccess(Level level) {
        assert (level != null);
        HierarchyAccess access = this.hierarchyGrants.get(level.getHierarchy());
        if (access != null) {
            if (access.topLevel != null && level.getDepth() < access.topLevel.getDepth()) {
                return Access.NONE;
            }
            if (access.bottomLevel != null && level.getDepth() > access.bottomLevel.getDepth()) {
                return Access.NONE;
            }
            return access.access;
        }
        return this.getAccess(level.getDimension());
    }

    public void grant(Member member, Access access) {
        Util.assertPrecondition(member != null, "member != null");
        assert (Util.isValid(Access.class, access));
        assert (this.isMutable());
        assert (this.getAccess(member.getHierarchy()) == Access.CUSTOM);
        HierarchyAccess hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        assert (hierarchyAccess != null);
        assert (hierarchyAccess.access == Access.CUSTOM);
        hierarchyAccess.grant(member, access);
    }

    public Access getAccess(Member member) {
        assert (member != null);
        HierarchyAccess hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        if (hierarchyAccess != null) {
            return hierarchyAccess.getAccess(member);
        }
        return this.getAccess(member.getDimension());
    }

    public Access getAccess(NamedSet set) {
        Util.assertPrecondition(set != null, "set != null");
        return Access.ALL;
    }

    public boolean canAccess(OlapElement olapElement) {
        Util.assertPrecondition(olapElement != null, "olapElement != null");
        if (olapElement instanceof Cube) {
            return this.getAccess((Cube)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Dimension) {
            return this.getAccess((Dimension)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Hierarchy) {
            return this.getAccess((Hierarchy)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Level) {
            return this.getAccess((Level)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Member) {
            return this.getAccess((Member)olapElement) != Access.NONE;
        }
        if (olapElement instanceof NamedSet) {
            return this.getAccess((NamedSet)olapElement) != Access.NONE;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HierarchyAccess {
        private final Hierarchy hierarchy;
        private final Level topLevel;
        private final Access access;
        private final Level bottomLevel;
        private final Map<Member, Access> memberGrants = new HashMap<Member, Access>();

        HierarchyAccess(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel) {
            assert (access != null);
            this.hierarchy = hierarchy;
            this.access = access;
            this.topLevel = topLevel;
            this.bottomLevel = bottomLevel;
        }

        public HierarchyAccess clone() {
            HierarchyAccess hierarchyAccess = new HierarchyAccess(this.hierarchy, this.access, this.topLevel, this.bottomLevel);
            hierarchyAccess.memberGrants.putAll(this.memberGrants);
            return hierarchyAccess;
        }

        void grant(Member member, Access access) {
            Member m;
            Util.assertTrue(member.getHierarchy() == this.hierarchy);
            Iterator<Member> memberIter = this.memberGrants.keySet().iterator();
            while (memberIter.hasNext()) {
                Member m2 = memberIter.next();
                if (!m2.isChildOrEqualTo(member)) continue;
                memberIter.remove();
            }
            this.memberGrants.put(member, access);
            if (access == Access.NONE) {
                for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    Access memberAccess = this.memberGrants.get(m);
                    if (memberAccess == null) {
                        if (this.childGrantsExist(m)) {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue;
                        }
                    } else if (memberAccess == Access.CUSTOM) {
                        if (this.childGrantsExist(m)) {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue;
                        }
                    } else if (memberAccess != Access.NONE && memberAccess != Access.ALL) {
                        continue;
                    }
                    break;
                }
            } else {
                block5: for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    switch (Role.toAccess(this.memberGrants.get(m))) {
                        case NONE: {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue block5;
                        }
                    }
                }
            }
        }

        private boolean childGrantsExist(Member parent) {
            for (Member member : this.memberGrants.keySet()) {
                Access access;
                if (member.getParentMember() != parent || (access = Role.toAccess(this.memberGrants.get(member))) == Access.NONE) continue;
                return true;
            }
            return false;
        }

        public Access getAccess(Member member) {
            if (this.access != Access.CUSTOM) {
                return this.access;
            }
            if (this.topLevel != null && member.getLevel().getDepth() < this.topLevel.getDepth()) {
                return Access.NONE;
            }
            if (this.bottomLevel != null && member.getLevel().getDepth() > this.bottomLevel.getDepth()) {
                return Access.NONE;
            }
            for (Member m = member; m != null; m = m.getParentMember()) {
                Access memberAccess = this.memberGrants.get(m);
                if (memberAccess == null) continue;
                if (memberAccess == Access.CUSTOM && m != member) {
                    return Access.NONE;
                }
                return memberAccess;
            }
            return Access.NONE;
        }

        public Hierarchy getHierarchy() {
            return this.hierarchy;
        }

        public Level getTopLevel() {
            return this.topLevel;
        }

        public Level getBottomLevel() {
            return this.bottomLevel;
        }

        public Map<Member, Access> getMemberGrants() {
            return Collections.unmodifiableMap(this.memberGrants);
        }
    }
}

