/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.router;

import org.netbeans.api.visual.router.CollisionsCollector;
import org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.modules.visual.router.DirectRouter;
import org.netbeans.modules.visual.router.FreeRouter;
import org.netbeans.modules.visual.router.OrthogonalSearchRouter;
import org.netbeans.modules.visual.router.WidgetsCollisionCollector;

public final class RouterFactory {
    private static final Router ROUTER_DIRECT = new DirectRouter();
    private static final Router ROUTER_FREE = new FreeRouter();

    private RouterFactory() {
    }

    public static Router createDirectRouter() {
        return ROUTER_DIRECT;
    }

    public static Router createFreeRouter() {
        return ROUTER_FREE;
    }

    public static Router createOrthogonalSearchRouter(LayerWidget ... layerWidgetArray) {
        return RouterFactory.createOrthogonalSearchRouter(RouterFactory.createWidgetsCollisionCollector(layerWidgetArray));
    }

    public static Router createOrthogonalSearchRouter(CollisionsCollector collisionsCollector) {
        assert (collisionsCollector != null);
        return new OrthogonalSearchRouter(collisionsCollector);
    }

    private static CollisionsCollector createWidgetsCollisionCollector(LayerWidget ... layerWidgetArray) {
        return new WidgetsCollisionCollector(layerWidgetArray);
    }

    public static Router createOrthogonalSearchRouter(ConnectionWidgetCollisionsCollector connectionWidgetCollisionsCollector) {
        assert (connectionWidgetCollisionsCollector != null);
        return new OrthogonalSearchRouter(connectionWidgetCollisionsCollector);
    }
}

