/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.execution.DefaultSysProcess;
import org.netbeans.core.execution.ExecutionEvent;
import org.netbeans.core.execution.ExecutionListener;
import org.netbeans.core.execution.ExecutorTaskImpl;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.IOTable;
import org.netbeans.core.execution.OutputStreamWriter;
import org.netbeans.core.execution.RunClassThread;
import org.netbeans.core.execution.SysIn;
import org.netbeans.core.execution.TaskIO;
import org.netbeans.core.execution.TaskThreadGroup;
import org.netbeans.core.execution.WindowTable;
import org.netbeans.core.execution.WriterPrintStream;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionEngine
extends org.openide.execution.ExecutionEngine {
    public static final ThreadGroup base = new ThreadGroup("base");
    private int number = 1;
    public static final TaskIO systemIO = new TaskIO();
    private static IOTable taskIOs;
    private static WindowTable wtable;
    private HashSet<ExecutionListener> executionListeners = new HashSet();
    private List<ExecutorTask> runningTasks = Collections.synchronizedList(new ArrayList(5));
    static final long serialVersionUID = 9072488605180080803L;

    public ExecutionEngine() {
        System.setIn(new SysIn());
        System.setOut(ExecutionEngine.createPrintStream(true));
        System.setErr(ExecutionEngine.createPrintStream(false));
    }

    public static ExecutionEngine getExecutionEngine() {
        ExecutionEngine executionEngine = (ExecutionEngine)((Object)Lookup.getDefault().lookup(ExecutionEngine.class));
        if (executionEngine != null) {
            return executionEngine;
        }
        org.openide.execution.ExecutionEngine executionEngine2 = (org.openide.execution.ExecutionEngine)Lookup.getDefault().lookup(org.openide.execution.ExecutionEngine.class);
        if (executionEngine2 instanceof ExecutionEngine) {
            return (ExecutionEngine)executionEngine2;
        }
        return null;
    }

    public Collection<ExecutorTask> getRunningTasks() {
        return Arrays.asList(this.runningTasks.toArray(new ExecutorTask[0]));
    }

    public String getRunningTaskName(ExecutorTask executorTask) {
        if (!this.runningTasks.contains(executorTask) || !(executorTask instanceof DefaultSysProcess)) {
            return null;
        }
        return ((DefaultSysProcess)executorTask).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(String string, Runnable runnable, InputOutput inputOutput) {
        TaskThreadGroup taskThreadGroup = new TaskThreadGroup(base, "exec_" + string + "_" + this.number);
        taskThreadGroup.setDaemon(true);
        ExecutorTaskImpl executorTaskImpl = new ExecutorTaskImpl();
        Object object = executorTaskImpl.lock;
        synchronized (object) {
            try {
                int n = this.number++;
                new RunClassThread(taskThreadGroup, string, n, inputOutput, this, executorTaskImpl, runnable);
                executorTaskImpl.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException.getMessage());
            }
        }
        return executorTaskImpl;
    }

    protected NbClassPath createLibraryPath() {
        NbTopManager.getUninitialized();
        List list = NbTopManager.getModuleJars();
        return new NbClassPath(list.toArray(new File[list.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExecutionListener(ExecutionListener executionListener) {
        HashSet<ExecutionListener> hashSet = this.executionListeners;
        synchronized (hashSet) {
            this.executionListeners.add(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExecutionListener(ExecutionListener executionListener) {
        HashSet<ExecutionListener> hashSet = this.executionListeners;
        synchronized (hashSet) {
            this.executionListeners.remove(executionListener);
        }
    }

    protected final PermissionCollection createPermissions(CodeSource codeSource, InputOutput inputOutput) {
        PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(codeSource);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        return new IOPermissionCollection(inputOutput, permissionCollection, threadGroup instanceof TaskThreadGroup ? (TaskThreadGroup)threadGroup : null);
    }

    protected final void fireExecutionStarted(ExecutionEvent executionEvent) {
        this.runningTasks.add(executionEvent.getProcess());
        for (ExecutionListener executionListener : (HashSet)this.executionListeners.clone()) {
            executionListener.startedExecution(executionEvent);
        }
    }

    protected final void fireExecutionFinished(ExecutionEvent executionEvent) {
        this.runningTasks.remove((Object)executionEvent.getProcess());
        for (ExecutionListener executionListener : (HashSet)this.executionListeners.clone()) {
            executionListener.finishedExecution(executionEvent);
        }
        executionEvent.getProcess().destroyThreadGroup(base);
    }

    static void putWindow(Window window, TaskThreadGroup taskThreadGroup) {
        wtable.putTaskWindow(window, taskThreadGroup);
    }

    static void closeGroup(ThreadGroup threadGroup) {
        wtable.closeGroup(threadGroup);
    }

    static boolean hasWindows(ThreadGroup threadGroup) {
        return wtable.hasWindows(threadGroup);
    }

    static IOTable getTaskIOs() {
        if (taskIOs == null) {
            taskIOs = new IOTable(base, systemIO);
        }
        return taskIOs;
    }

    public static ThreadGroup findGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = null;
        for (threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null && threadGroup != base; threadGroup = threadGroup.getParent()) {
            threadGroup2 = threadGroup;
        }
        return threadGroup == null ? null : threadGroup2;
    }

    static PrintStream createPrintStream(boolean bl) {
        return new WriterPrintStream(new SysOut(bl), bl);
    }

    static {
        wtable = new WindowTable();
        ExecutionEngine.systemIO.out = new OutputStreamWriter(System.out);
        ExecutionEngine.systemIO.err = new OutputStreamWriter(System.err);
        ExecutionEngine.systemIO.in = new InputStreamReader(System.in);
    }

    static class SysOut
    extends OutputStream {
        boolean std;

        SysOut(boolean bl) {
            this.std = bl;
        }

        public void write(int n) throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().write(n);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(n);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            String string = new String(byArray, n, n2);
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().write(string.toCharArray(), 0, string.length());
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(string.toCharArray(), 0, string.length());
            }
        }

        public void flush() throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().flush();
            } else {
                ExecutionEngine.getTaskIOs().getErr().flush();
            }
        }

        public void close() throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().close();
            } else {
                ExecutionEngine.getTaskIOs().getErr().close();
            }
        }
    }
}

