/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class SimpleMessageListenerContainer
extends AbstractMessageListenerContainer {
    private boolean pubSubNoLocal = false;
    private int concurrentConsumers = 1;
    private Set sessions;
    private Set consumers;

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    protected void registerListener() throws JMSException {
        this.sessions = new HashSet(this.concurrentConsumers);
        this.consumers = new HashSet(this.concurrentConsumers);
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            Session session = this.createSession(this.getConnection());
            MessageConsumer consumer = this.createListenerConsumer(session);
            this.sessions.add(session);
            this.consumers.add(consumer);
        }
    }

    protected MessageConsumer createListenerConsumer(final Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        MessageConsumer consumer = this.createConsumer(session, destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                SimpleMessageListenerContainer.this.executeListener(session, message);
            }
        });
        return consumer;
    }

    protected void destroyListener() throws JMSException {
        this.logger.debug((Object)"Closing JMS MessageConsumers");
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            MessageConsumer consumer = (MessageConsumer)it.next();
            JmsUtils.closeMessageConsumer(consumer);
        }
        this.logger.debug((Object)"Closing JMS Sessions");
        it = this.sessions.iterator();
        while (it.hasNext()) {
            Session session = (Session)it.next();
            JmsUtils.closeSession(session);
        }
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }
}

