/*
 * Decompiled with CFR 0.152.
 */
package rex.xmla;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import rex.exceptions.RexXMLADiscoverException;
import rex.exceptions.RexXMLAExecuteException;
import rex.graphics.AuthenticationDialog;
import rex.utils.DOM;
import rex.utils.S;
import rex.utils.XMLDocumentWriter;
import rex.xmla.RexXMLADiscoverProperties;
import rex.xmla.RexXMLADiscoverRestrictions;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;
import rex.xmla.XMLAPort;
import rex.xmla.XMLAProperties;
import rex.xmla.XMLARestrictions;

public class RexXMLAPort
implements XMLAPort {
    URL endpoint;
    boolean connOpen;
    HttpURLConnection urlConnection;
    private String requestType;
    DocumentBuilder builder;
    private boolean verbose;
    private String empty = "    ";

    public RexXMLAPort(URL _endpoint) throws ParserConfigurationException {
        this.endpoint = _endpoint;
        this.connOpen = false;
        this.verbose = System.getProperty("showsoap") != null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = factory.newDocumentBuilder();
    }

    private String getRequestType() {
        return this.requestType == null ? "DISCOVER_DATASOURCES" : this.requestType;
    }

    private void setRequestType(String _requestType) {
        this.requestType = _requestType;
    }

    private void setDiscoverMimeHeaders() {
        this.urlConnection.setRequestProperty("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Discover\"");
        this.urlConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        this.urlConnection.setRequestProperty("Accept", "application/soap+xml, application/dime, multipart/related, text/*");
    }

    private void setExecuteMimeHeaders() {
        this.urlConnection.setRequestProperty("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"");
        this.urlConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        this.urlConnection.setRequestProperty("Accept", "application/soap+xml, application/dime, multipart/related, text/*");
    }

    private boolean init() throws RexXMLAExecuteException {
        try {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    AuthenticationDialog ad = new AuthenticationDialog(null);
                    return new PasswordAuthentication(ad.getUsername(), ad.getPasswordCA());
                }
            });
            this.urlConnection = (HttpURLConnection)this.endpoint.openConnection();
            this.urlConnection.setRequestMethod("POST");
            this.urlConnection.setDoInput(true);
            this.urlConnection.setDoOutput(true);
            this.connOpen = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RexXMLAExecuteException(this.urlConnection.toString() + " is not available or not able to respond");
        }
        return true;
    }

    public static String xmlEncodeString(String orig) {
        if (orig == null) {
            return "";
        }
        char[] chars = orig.toCharArray();
        boolean needsEncoding = false;
        block11: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    needsEncoding = true;
                    break block11;
                }
                default: {
                    continue block11;
                }
            }
        }
        if (!needsEncoding) {
            return orig;
        }
        StringBuffer strBuf = new StringBuffer();
        block12: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '&': {
                    strBuf.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    strBuf.append("&quot;");
                    continue block12;
                }
                case '\'': {
                    strBuf.append("&apos;");
                    continue block12;
                }
                case '<': {
                    strBuf.append("&lt;");
                    continue block12;
                }
                case '\r': {
                    strBuf.append("&#xd;");
                    continue block12;
                }
                case '>': {
                    strBuf.append("&gt;");
                    continue block12;
                }
                default: {
                    if (chars[i] > '\u007f') {
                        strBuf.append("&#");
                        strBuf.append((int)chars[i]);
                        strBuf.append(";");
                        continue block12;
                    }
                    strBuf.append(chars[i]);
                }
            }
        }
        return strBuf.toString();
    }

    private boolean errorOccured(Document resultDOM, String typeOfError, XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException {
        NodeList faultList = resultDOM.getElementsByTagName("SOAP-ENV:Fault");
        if (faultList != null && faultList.getLength() > 0) {
            StringBuffer sBuffer = new StringBuffer("");
            NodeList faultStringList = resultDOM.getElementsByTagName("faultstring");
            if (faultStringList != null && faultStringList.getLength() > 0) {
                sBuffer.append("\n  faultstring = " + DOM.getTextFromDOMElement(faultStringList.item(0)));
            }
            if ((faultStringList = resultDOM.getElementsByTagName("desc")) != null && faultStringList.getLength() > 0) {
                sBuffer.append("\n  desc = " + DOM.getTextFromDOMElement(faultStringList.item(0)));
            }
            if (typeOfError.equals("Execute")) {
                throw new RexXMLAExecuteException(sBuffer.toString());
            }
            throw new RexXMLADiscoverException(sBuffer.toString());
        }
        NodeList errList = resultDOM.getElementsByTagName("Error");
        NodeList rowList = resultDOM.getElementsByTagName("row");
        if (errList != null && errList.getLength() > 0) {
            StringBuffer sBuffer = new StringBuffer("");
            for (int errListCounter = 0; errListCounter < errList.getLength(); ++errListCounter) {
                NamedNodeMap attrs = errList.item(errListCounter).getAttributes();
                for (int errAttributeListCounter = 0; errAttributeListCounter < attrs.getLength(); ++errAttributeListCounter) {
                    sBuffer.append("\n  " + attrs.item(errAttributeListCounter).getNodeName() + " = " + attrs.item(errAttributeListCounter).getNodeValue());
                }
            }
            if (typeOfError.equals("Execute")) {
                throw new RexXMLAExecuteException(sBuffer.toString());
            }
            throw new RexXMLADiscoverException(sBuffer.toString());
        }
        if (typeOfError.equals("Discover") && rowList.getLength() == 0) {
            return this.errorOccuredInDiscover(restrictions, properties);
        }
        return false;
    }

    public boolean errorOccuredInDiscover(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLADiscoverException {
        String propXML = properties.getPropertyListXML(this.empty);
        String restXML = restrictions.getRestrictionListXML(this.empty);
        String dataSourceInfo = propXML.substring(propXML.indexOf("<DataSourceInfo>") + "<DataSourceInfo>".length(), propXML.indexOf("</DataSourceInfo>"));
        String catalog = propXML.substring(propXML.indexOf("<Catalog>") + "<Catalog>".length(), propXML.indexOf("</Catalog>"));
        String cube = restXML.substring(restXML.indexOf("<CUBE_NAME>") + "<CUBE_NAME>".length(), restXML.indexOf("</CUBE_NAME>"));
        Object retVal = null;
        Object catalogs = null;
        RexXMLADiscoverProperties tempDiscProp = new RexXMLADiscoverProperties();
        RexXMLADiscoverRestrictions tempDiscRest = new RexXMLADiscoverRestrictions();
        try {
            int index;
            tempDiscProp.setDataSourceInfo(dataSourceInfo);
            String[] result = this.getCatalogListAsString(tempDiscRest, tempDiscProp);
            int checkCatalog = 0;
            for (index = 0; index < result.length; ++index) {
                if (!catalog.equals(result[index])) continue;
                ++checkCatalog;
            }
            if (checkCatalog == 0) {
                throw new RexXMLADiscoverException(catalog + " Catalog not found in URL " + this.urlConnection.getURL().toString());
            }
            tempDiscProp.setCatalog(catalog);
            result = this.getCubeListAsString(tempDiscRest, tempDiscProp);
            int checkCube = 0;
            for (index = 0; index < result.length; ++index) {
                S.out(result[index]);
                if (!cube.equals(result[index])) continue;
                ++checkCube;
            }
            if (checkCube == 0) {
                throw new RexXMLADiscoverException(cube + " cube not found in " + catalog + " catalog.");
            }
        }
        catch (Exception e) {
            throw new RexXMLADiscoverException(e.toString());
        }
        return false;
    }

    public Document execute(String mdx, XMLAExecuteProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        if (!this.init()) {
            return null;
        }
        StringBuffer request = new StringBuffer("");
        request.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SOAP-ENV:Envelope\n  xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\n  SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n  <SOAP-ENV:Body>\n    <Execute  xmlns=\"urn:schemas-microsoft-com:xml-analysis\"\n              SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        request.append("\n   <Command>\n      <Statement>\n         " + RexXMLAPort.xmlEncodeString(mdx) + "\n      </Statement>" + "\n   </Command>");
        request.append(properties.getXML("    "));
        request.append("\n    </Execute>");
        request.append("\n  </SOAP-ENV:Body>");
        request.append("\n</SOAP-ENV:Envelope>");
        this.setExecuteMimeHeaders();
        try {
            byte[] b = request.toString().getBytes("UTF8");
            if (this.verbose) {
                S.out("\nSENDING FOLLOWING SOAP MESSAGE (" + GregorianCalendar.getInstance().getTime() + "):\n" + request);
            }
            this.writeToStream(b, this.urlConnection.getOutputStream());
            Document d = this.builder.parse(this.urlConnection.getInputStream());
            if (this.verbose) {
                XMLDocumentWriter dw = new XMLDocumentWriter();
                S.out("\nRECEIEVED SOAP MESSAGE (" + GregorianCalendar.getInstance().getTime() + "):\n");
                dw.write(d.getChildNodes().item(0));
            }
            if (this.errorOccured(d, "Execute", null, null)) {
                return null;
            }
            return d;
        }
        catch (SAXException e) {
            S.out("from SAXParser");
            e.printStackTrace();
            S.reportError(e);
        }
        catch (FileNotFoundException exc) {
            throw new RexXMLAExecuteException(this.urlConnection.getURL().toString() + " is not available or not able to respond");
        }
        this.urlConnection.disconnect();
        return null;
    }

    private Document discover(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        if (!this.init()) {
            return null;
        }
        StringBuffer request = new StringBuffer("");
        request.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SOAP-ENV:Envelope\n  xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\n  SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n  <SOAP-ENV:Body>\n    <Discover xmlns=\"urn:schemas-microsoft-com:xml-analysis\"\n              SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        request.append("\n    <RequestType>" + this.getRequestType() + "</RequestType>");
        request.append(restrictions.getXML("    "));
        request.append(properties.getXML("    "));
        request.append("\n    </Discover>");
        request.append("\n  </SOAP-ENV:Body>");
        request.append("\n</SOAP-ENV:Envelope>");
        this.setDiscoverMimeHeaders();
        try {
            byte[] b = request.toString().getBytes("UTF8");
            if (this.verbose) {
                S.out("\nSENDING SOAP MESSAGE (" + GregorianCalendar.getInstance().getTime() + "):\n" + request);
            }
            this.writeToStream(b, this.urlConnection.getOutputStream());
            Document d = this.builder.parse(this.urlConnection.getInputStream());
            if (this.verbose) {
                XMLDocumentWriter dw = new XMLDocumentWriter();
                S.out("\nRECEIEVED SOAP MESSAGE (" + GregorianCalendar.getInstance().getTime() + "):\n");
                dw.write(d.getChildNodes().item(0));
            }
            if (this.errorOccured(d, "Discover", restrictions, properties)) {
                return null;
            }
            return d;
        }
        catch (SAXException e) {
            e.printStackTrace();
            S.reportError(e);
        }
        catch (FileNotFoundException exc) {
            throw new RexXMLAExecuteException(this.urlConnection.getURL().toString() + " is not available or not able to respond");
        }
        this.urlConnection.disconnect();
        return null;
    }

    private InputStream discoverAsStream(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        if (!this.init()) {
            return null;
        }
        StringBuffer request = new StringBuffer("");
        request.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SOAP-ENV:Envelope\n  xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\n  SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n  <SOAP-ENV:Body>\n    <Discover xmlns=\"urn:schemas-microsoft-com:xml-analysis\"\n              SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        request.append("\n    <RequestType>" + this.getRequestType() + "</RequestType>");
        request.append(restrictions.getXML("    "));
        request.append(properties.getXML("    "));
        request.append("\n    </Discover>");
        request.append("\n  </SOAP-ENV:Body>");
        request.append("\n</SOAP-ENV:Envelope>");
        this.setDiscoverMimeHeaders();
        byte[] b = request.toString().getBytes("UTF8");
        if (this.verbose) {
            S.out("SENDING SOAP MESSAGE (" + GregorianCalendar.getInstance().getTime() + "):\n" + request);
        }
        this.writeToStream(b, this.urlConnection.getOutputStream());
        return this.urlConnection.getInputStream();
    }

    public Document discoverDataSources(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("DISCOVER_DATASOURCES");
        return this.discover(restrictions, properties);
    }

    public String[] discoverDataSourcesAsString(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        String[] dataSourceName = null;
        this.setRequestType("DISCOVER_DATASOURCES");
        Document result = this.discover(restrictions, properties);
        NodeList nlist = result.getElementsByTagName("row");
        if (nlist != null && nlist.getLength() > 0) {
            dataSourceName = new String[nlist.getLength()];
            for (int nlistCounter = 0; nlistCounter < nlist.getLength(); ++nlistCounter) {
                NodeList nodelist = nlist.item(nlistCounter).getChildNodes();
                for (int j = 0; j < nodelist.getLength(); ++j) {
                    if (nodelist.item(j).getNodeType() != 1 || !nodelist.item(j).getNodeName().equals("DataSourceName")) continue;
                    dataSourceName[nlistCounter] = DOM.getTextFromDOMElement(nodelist.item(j));
                }
            }
        }
        return dataSourceName;
    }

    public Document getCatalogList(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("DBSCHEMA_CATALOGS");
        return this.discover(restrictions, properties);
    }

    public String[] getCatalogListAsString(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        String[] catalogName = null;
        this.setRequestType("DBSCHEMA_CATALOGS");
        Document result = this.discover(restrictions, properties);
        NodeList nlist = result.getElementsByTagName("row");
        if (nlist != null && nlist.getLength() > 0) {
            catalogName = new String[nlist.getLength()];
            for (int nlistCounter = 0; nlistCounter < nlist.getLength(); ++nlistCounter) {
                NodeList nodelist = nlist.item(nlistCounter).getChildNodes();
                for (int j = 0; j < nodelist.getLength(); ++j) {
                    if (nodelist.item(j).getNodeType() != 1 || !nodelist.item(j).getNodeName().equals("CATALOG_NAME")) continue;
                    catalogName[nlistCounter] = DOM.getTextFromDOMElement(nodelist.item(j));
                }
            }
        }
        return catalogName;
    }

    public Document getCubeList(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("MDSCHEMA_CUBES");
        return this.discover(restrictions, properties);
    }

    public String[] getCubeListAsString(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        String[] cubeName = null;
        this.setRequestType("MDSCHEMA_CUBES");
        Document result = this.discover(restrictions, properties);
        NodeList nlist = result.getElementsByTagName("row");
        if (nlist != null && nlist.getLength() > 0) {
            cubeName = new String[nlist.getLength()];
            for (int nlistCounter = 0; nlistCounter < nlist.getLength(); ++nlistCounter) {
                NodeList nodelist = nlist.item(nlistCounter).getChildNodes();
                for (int j = 0; j < nodelist.getLength(); ++j) {
                    if (nodelist.item(j).getNodeType() != 1 || !nodelist.item(j).getNodeName().equals("CUBE_NAME")) continue;
                    cubeName[nlistCounter] = DOM.getTextFromDOMElement(nodelist.item(j));
                }
            }
        }
        return cubeName;
    }

    public Document getDimensionList(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("MDSCHEMA_DIMENSIONS");
        return this.discover(restrictions, properties);
    }

    public Document getHierarchyList(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("MDSCHEMA_HIERARCHIES");
        return this.discover(restrictions, properties);
    }

    public Document getLevelList(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("MDSCHEMA_LEVELS");
        return this.discover(restrictions, properties);
    }

    public Document getMeasureList(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("MDSCHEMA_MEASURES");
        return this.discover(restrictions, properties);
    }

    public Document getMemberList(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("MDSCHEMA_MEMBERS");
        return this.discover(restrictions, properties);
    }

    public InputStream getMemberListAsStream(XMLARestrictions restrictions, XMLAProperties properties) throws RexXMLAExecuteException, RexXMLADiscoverException, IOException {
        this.setRequestType("MDSCHEMA_MEMBERS");
        return this.discoverAsStream(restrictions, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromStream(InputStream urlInputStream) throws IOException {
        BufferedInputStream in = null;
        ByteArrayOutputStream bout = null;
        try {
            in = new BufferedInputStream(urlInputStream);
            bout = new ByteArrayOutputStream();
            int counter = 0;
            byte b = 0;
            int len = 0;
            while (len != -1) {
                len = in.available();
                if (len == 0) {
                    b = (byte)in.read();
                    if (b != -1) {
                        bout.write(b);
                        counter = 0;
                        continue;
                    }
                    if (counter > 100) {
                        throw new EOFException();
                    }
                    ++counter;
                    continue;
                }
                len = in.available();
                byte[] bp = new byte[len];
                in.read(bp);
                bout.write(bp);
                counter = 0;
            }
        }
        catch (EOFException e) {
            S.reportError(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (urlInputStream != null) {
                    urlInputStream.close();
                }
            }
            catch (IOException e) {
                S.reportError(e);
            }
        }
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToStream(byte[] data, OutputStream urlOutputStream) throws IOException {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(urlOutputStream);
            os.write(data);
            os.flush();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (urlOutputStream != null) {
                    urlOutputStream.close();
                }
            }
            catch (IOException e) {
                S.reportError(e);
            }
        }
    }

    public static void main(String[] args) {
        XMLADiscoverRestrictions rest = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties prop = XMLAObjectsFactory.newXMLADiscoverProperties();
        RexXMLAPort svm = null;
        XMLAExecuteProperties execPropFoodMart = XMLAObjectsFactory.newXMLAExecuteProperties();
        execPropFoodMart.setDataSourceInfo("FoodMartSource");
        execPropFoodMart.setCatalog("FoodMart");
        ((RexXMLADiscoverProperties)prop).setDataSourceInfo("FoodMartSource");
        ((RexXMLADiscoverProperties)prop).setCatalog("FoodMart");
        ((RexXMLADiscoverRestrictions)rest).setCubeName("Sale");
        ((RexXMLADiscoverProperties)prop).setFormat("Tabular");
        ((RexXMLADiscoverProperties)prop).setContent("SchemaData");
        String mdxQuerySales = "SELECT NON EMPTY {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY {[Time].[1997]} ON ROWS FROM [Sales]";
        try {
            svm = new RexXMLAPort(new URL("http://localhost:8080/mondrian/xmla"));
        }
        catch (ParserConfigurationException pce) {
            S.reportError(pce);
        }
        catch (MalformedURLException mfe) {
            S.reportError(mfe);
        }
        try {
            svm.execute(mdxQuerySales, execPropFoodMart);
        }
        catch (RexXMLAExecuteException io) {
            S.reportError(io);
        }
        catch (RexXMLADiscoverException io) {
            S.reportError(io);
        }
        catch (IOException io) {
            S.reportError(io);
        }
    }
}

