/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.charts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.Pie3DPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.CategoryToPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Rotation;
import rex.graphics.charts.ExecuteResultToCategoryDatasetBridge;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;
import rex.utils.AppColors;
import rex.utils.S;

public class Chart
extends JPanel {
    private CubeSlicer cubeSlicer;
    private JFreeChart chart;
    private int chartType;
    private ExecuteResultToCategoryDatasetBridge bridge;
    public static final int BAR_VERTICAL = 0;
    public static final int BAR_HORIZONTAL = 1;
    public static final int BAR_3D_VERTICAL = 2;
    public static final int BAR_3D_HORIZONTAL = 3;
    public static final int PIE_3D = 4;
    public static final int COMBINED = 5;
    private static final ImageIcon[] icons = new ImageIcon[]{S.getAppIcon("chart_bar_vertical.gif"), S.getAppIcon("chart_bar_horizontal.gif"), S.getAppIcon("chart_bar_3d_vertical.gif"), S.getAppIcon("chart_bar_3d_horizontal.gif"), S.getAppIcon("chart_pie_3d.gif"), S.getAppIcon("chart_combined.gif")};

    public Chart(ExecuteResult _executeResult, CubeSlicer _cubeSlicer, int _chartType) {
        this.chartType = _chartType;
        this.cubeSlicer = _cubeSlicer;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanel(_executeResult, _cubeSlicer, _chartType), "Center");
    }

    public ImageIcon getIcon() {
        return icons[this.chartType];
    }

    public static ImageIcon getIconForType(int chartType) {
        return icons[chartType];
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setNewChartData(ExecuteResult _executeResult, CubeSlicer _cubeSlicer) {
        this.removeAll();
        this.add((Component)this.createPanel(_executeResult, _cubeSlicer, this.chartType), "Center");
    }

    private JPanel createPanel(ExecuteResult _executeResult, CubeSlicer _cubeSlicer, int _chartType) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        switch (this.chartType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.bridge = new ExecuteResultToCategoryDatasetBridge(_executeResult, _cubeSlicer);
                this.chart = this.createCategoryChart((CategoryDataset)this.bridge, this.chartType);
                ChartPanel chartPanel = new ChartPanel(this.chart);
                chartPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 700));
                panel.add((Component)chartPanel);
                break;
            }
            case 4: {
                this.bridge = new ExecuteResultToCategoryDatasetBridge(_executeResult, _cubeSlicer);
                JTabbedPane jtp = new JTabbedPane(4);
                for (int col = 0; col < this.bridge.getColumnCount(); ++col) {
                    this.chart = this.createPieChart((CategoryDataset)this.bridge, this.chartType, col, (String)((Object)this.bridge.getColumnKey(col)));
                    JPanel rowPanel = new JPanel();
                    rowPanel.setLayout(new BoxLayout(rowPanel, 0));
                    rowPanel.add(Box.createHorizontalGlue());
                    ChartPanel chartPanel = new ChartPanel(this.chart);
                    chartPanel.setPreferredSize(new Dimension(300, 270));
                    rowPanel.add((Component)chartPanel);
                    rowPanel.add(Box.createHorizontalGlue(), "East");
                    rowPanel.setBorder(AppColors.CELL_DEFAULT_BORDER);
                    rowPanel.setBackground(chartPanel.getBackground());
                    chartPanel.setOpaque(false);
                    jtp.addTab((String)((Object)this.bridge.getColumnKey(col)), rowPanel);
                }
                panel.add(jtp);
                break;
            }
            case 5: {
                this.bridge = new ExecuteResultToCategoryDatasetBridge(_executeResult, _cubeSlicer);
                this.chart = this.createCombinedChart((CategoryDataset)this.bridge, this.chartType);
                JPanel rowPanel = new JPanel();
                rowPanel.setLayout(new BoxLayout(rowPanel, 0));
                rowPanel.add(Box.createHorizontalGlue());
                ChartPanel chartPanel = new ChartPanel(this.chart);
                chartPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 700));
                rowPanel.add((Component)chartPanel);
                rowPanel.add(Box.createHorizontalGlue(), "East");
                rowPanel.setBorder(AppColors.CELL_DEFAULT_BORDER);
                rowPanel.setBackground(chartPanel.getBackground());
                panel.add(rowPanel);
            }
        }
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private JFreeChart createCategoryChart(CategoryDataset dataset, int chartType) {
        CategoryPlot plot;
        JFreeChart chart = null;
        switch (chartType) {
            case 0: {
                chart = ChartFactory.createBarChart((String)(this.bridge.getVerticalChartCaption() + " vs. " + this.bridge.getHorizontalChartCaption()), (String)this.bridge.getHorizontalChartCaption(), (String)this.bridge.getVerticalChartCaption(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 1: {
                chart = ChartFactory.createBarChart((String)(this.bridge.getVerticalChartCaption() + " vs. " + this.bridge.getHorizontalChartCaption()), (String)this.bridge.getVerticalChartCaption(), (String)this.bridge.getHorizontalChartCaption(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 2: {
                chart = ChartFactory.createBarChart3D((String)(this.bridge.getVerticalChartCaption() + " vs. " + this.bridge.getHorizontalChartCaption()), (String)this.bridge.getHorizontalChartCaption(), (String)this.bridge.getVerticalChartCaption(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                plot = chart.getCategoryPlot();
                CategoryAxis axis = plot.getDomainAxis();
                CategoryLabelPosition position = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_RIGHT, TextAnchor.TOP_RIGHT, -0.39269908169872414);
                axis.setBottomCategoryLabelPosition(position);
                break;
            }
            case 3: {
                chart = ChartFactory.createBarChart3D((String)(this.bridge.getVerticalChartCaption() + " vs. " + this.bridge.getHorizontalChartCaption()), (String)this.bridge.getVerticalChartCaption(), (String)this.bridge.getHorizontalChartCaption(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
            }
        }
        chart.setBackgroundPaint((Paint)new Color(0xBBBBDD));
        plot = chart.getCategoryPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.BLACK);
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.lightGray);
        GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.lightGray);
        renderer.setSeriesPaint(0, (Paint)gp0);
        renderer.setSeriesPaint(1, (Paint)gp1);
        renderer.setSeriesPaint(2, (Paint)gp2);
        return chart;
    }

    private JFreeChart createPieChart(CategoryDataset dataset, int chartType, int col, String title) {
        JFreeChart chart = null;
        switch (chartType) {
            case 4: {
                chart = ChartFactory.createPie3DChart((String)title, (PieDataset)new CategoryToPieDataset(dataset, 1, col), (boolean)true, (boolean)true, (boolean)false);
            }
        }
        chart.setBackgroundPaint((Paint)Color.yellow);
        Pie3DPlot plot = (Pie3DPlot)chart.getPlot();
        plot.setStartAngle(270.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("No data to display");
        return chart;
    }

    private JFreeChart createCombinedChart(CategoryDataset dataset, int chartType) {
        NumberAxis rangeAxis1 = new NumberAxis("Value");
        rangeAxis1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer1 = new LineAndShapeRenderer();
        renderer1.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        CategoryPlot subplot1 = new CategoryPlot(dataset, null, (ValueAxis)rangeAxis1, (CategoryItemRenderer)renderer1);
        subplot1.setDomainGridlinesVisible(true);
        NumberAxis rangeAxis2 = new NumberAxis("Value");
        rangeAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer2 = new BarRenderer();
        renderer2.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        CategoryPlot subplot2 = new CategoryPlot(dataset, null, (ValueAxis)rangeAxis2, (CategoryItemRenderer)renderer2);
        subplot2.setDomainGridlinesVisible(true);
        CategoryAxis domainAxis = new CategoryAxis("Category");
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
        plot.add(subplot1, 2);
        plot.add(subplot2, 1);
        JFreeChart result = new JFreeChart("Combined Domain Category Plot Demo", new Font("SansSerif", 1, 12), (Plot)plot, true);
        result.getLegend().setAnchor(3);
        return result;
    }
}

