/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.openide.util.Exceptions;

public class DeleteGroupUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignGroup group = null;
    private JRDesignDataset dataset = null;
    private int index = 0;

    public DeleteGroupUndoableEdit(JRDesignGroup group, JRDesignDataset dataset, int index) {
        this.group = group;
        this.dataset = dataset;
        this.index = index;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.getDataset().addGroup(this.getGroup());
            this.getDataset().getGroupsList().remove(this.getGroup());
            this.getDataset().getGroupsList().add(this.index, this.getGroup());
            this.getDataset().getEventSupport().fireCollectionElementAddedEvent("groups", (Object)this.group, this.getDataset().getGroupsList().size() - 1);
        }
        catch (JRException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new CannotRedoException();
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.getDataset().removeGroup((JRGroup)this.getGroup());
    }

    public String getPresentationName() {
        String groupName = "";
        if (this.getGroup() != null && this.getGroup().getName() != null) {
            groupName = this.getGroup().getName();
        }
        return "Delete group " + groupName;
    }

    public JRDesignGroup getGroup() {
        return this.group;
    }

    public void setGroup(JRDesignGroup group) {
        this.group = group;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }
}

