/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;

public class AddStyleUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignStyle style = null;
    private JasperDesign jasperDesign = null;
    private int index = -1;

    public AddStyleUndoableEdit(JRDesignStyle style, JasperDesign jasperDesign) {
        this.style = style;
        this.jasperDesign = jasperDesign;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.index = this.jasperDesign.getStylesList().indexOf(this.getStyle());
        this.jasperDesign.removeStyle((JRStyle)this.getStyle());
    }

    public void redo() throws CannotRedoException {
        super.redo();
        if (this.index > -1) {
            this.jasperDesign.getStylesList().add(this.index, this.getStyle());
        } else {
            this.jasperDesign.getStylesList().add(this.getStyle());
        }
        this.jasperDesign.getEventSupport().firePropertyChange("styles", null, null);
    }

    public String getPresentationName() {
        return "Add Style " + this.getStyle().getName();
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public JRDesignStyle getStyle() {
        return this.style;
    }

    public void setStyle(JRDesignStyle style) {
        this.style = style;
    }
}

