/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SchemaPanel
extends JPanel {
    private ConnectionDialogMediator mediator;
    private DatabaseConnection dbcon;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private JTextArea commentTextArea;
    private JPanel connectProgressPanel;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JButton schemaButton;
    private JComboBox schemaComboBox;
    private JLabel schemaLabel;

    public SchemaPanel(ConnectionDialogMediator connectionDialogMediator, DatabaseConnection databaseConnection) {
        this.mediator = connectionDialogMediator;
        this.dbcon = databaseConnection;
        this.initComponents();
        this.initAccessibility();
        ConnectionProgressListener connectionProgressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                SchemaPanel.this.startProgress();
            }

            public void connectionStep(String string) {
                SchemaPanel.this.setProgressMessage(string);
            }

            public void connectionFinished() {
                SchemaPanel.this.stopProgress(true);
            }

            public void connectionFailed() {
                SchemaPanel.this.stopProgress(false);
            }
        };
        connectionDialogMediator.addConnectionProgressListener(connectionProgressListener);
    }

    private void initAccessibility() {
        this.schemaLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_SchemaDialogTextA11yDesc"));
        this.schemaComboBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_SchemaDialogTextComboBoxA11yName"));
        this.commentTextArea.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_SchemaPanelCommentA11yName"));
        this.commentTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_SchemaPanelCommentA11yDesc"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectionProgressBarA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectionProgressBarA11yDesc"));
        this.schemaButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_GetSchemasButtonA11yName"));
        this.schemaButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_GetSchemasButtonA11yDesc"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_GetSchemasPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_GetSchemasPanelA11yDesc"));
    }

    private void initComponents() {
        this.commentTextArea = new JTextArea();
        this.schemaLabel = new JLabel();
        this.schemaComboBox = new JComboBox();
        this.schemaButton = new JButton();
        this.connectProgressPanel = new JPanel();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.commentTextArea.setEditable(false);
        this.commentTextArea.setFont(UIManager.getFont("Label.font"));
        this.commentTextArea.setLineWrap(true);
        this.commentTextArea.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("MSG_SchemaPanelComment"));
        this.commentTextArea.setWrapStyleWord(true);
        this.commentTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.commentTextArea.setEnabled(false);
        this.commentTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.commentTextArea, gridBagConstraints);
        this.schemaLabel.setLabelFor(this.schemaComboBox);
        Mnemonics.setLocalizedText((JLabel)this.schemaLabel, (String)NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("SchemaDialogText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.schemaLabel, gridBagConstraints);
        this.schemaComboBox.setToolTipText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_SchemaDialogTextComboBoxA11yDesc"));
        this.schemaComboBox.setEnabled(false);
        this.schemaComboBox.setPrototypeDisplayValue("wwwwwwwwww");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.schemaComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.schemaButton, (String)NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("SchemaDialogGetButton"));
        this.schemaButton.setToolTipText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_GetSchemasButtonA11yDesc"));
        this.schemaButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.schemaButton, gridBagConstraints);
        this.connectProgressPanel.setToolTipText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectionProgressBarA11yDesc"));
        this.connectProgressPanel.setLayout(new BorderLayout(0, 5));
        Mnemonics.setLocalizedText((JLabel)this.progressMessageLabel, (String)" ");
        this.connectProgressPanel.add((Component)this.progressMessageLabel, "North");
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        this.connectProgressPanel.add((Component)this.progressContainerPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.connectProgressPanel, gridBagConstraints);
    }

    private void schemaButtonActionPerformed(ActionEvent actionEvent) {
        this.schemaComboBox.setEnabled(false);
        this.schemaComboBox.removeAllItems();
        Connection connection = this.dbcon.getConnection();
        try {
            if (connection == null || connection.isClosed()) {
                this.dbcon.connect();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        SchemaPanel.this.mediator.fireConnectionStarted();
                        SchemaPanel.this.mediator.retrieveSchemas(SchemaPanel.this, SchemaPanel.this.dbcon, SchemaPanel.this.dbcon.getUser());
                        SchemaPanel.this.mediator.fireConnectionFinished();
                    }
                });
            }
        }
        catch (SQLException sQLException) {
            this.dbcon.connect();
        }
    }

    public String getSchema() {
        Object object = this.schemaComboBox.getSelectedItem();
        if (object != null && !object.toString().equals(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("TXT_NoSchema"))) {
            return object.toString();
        }
        return null;
    }

    public boolean setSchemas(Vector vector, String string) {
        int n;
        this.schemaComboBox.removeAllItems();
        for (n = 0; n < vector.size(); ++n) {
            this.schemaComboBox.addItem(vector.elementAt(n));
        }
        if (vector.size() == 0) {
            this.schemaComboBox.addItem(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("TXT_NoSchema"));
            this.schemaComboBox.setEnabled(false);
        } else {
            this.schemaComboBox.setEnabled(true);
        }
        if (vector.size() == 1) {
            return true;
        }
        n = vector.indexOf(string);
        if (n == -1) {
            n = vector.indexOf(string.toLowerCase());
        }
        if (n == -1) {
            n = vector.indexOf(string.toUpperCase());
        }
        if (n != -1) {
            this.schemaComboBox.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    public void setComment(String string) {
        this.commentTextArea.setText(string);
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaPanel.this.progressHandle = ProgressHandleFactory.createHandle(null);
                SchemaPanel.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)SchemaPanel.this.progressHandle);
                SchemaPanel.this.progressContainerPanel.add((Component)SchemaPanel.this.progressComponent, "Center");
                SchemaPanel.this.progressHandle.start();
                SchemaPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectionProgress_Connecting"));
                SchemaPanel.this.schemaButton.setEnabled(false);
            }
        });
    }

    private void setProgressMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaPanel.this.progressMessageLabel.setText(string);
                SchemaPanel.this.schemaButton.setEnabled(false);
            }
        });
    }

    private void stopProgress(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaPanel.this.progressHandle.finish();
                SchemaPanel.this.progressContainerPanel.remove(SchemaPanel.this.progressComponent);
                SchemaPanel.this.progressContainerPanel.repaint();
                if (bl) {
                    SchemaPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectionProgress_Established"));
                } else {
                    SchemaPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectionProgress_Failed"));
                }
                SchemaPanel.this.schemaButton.setEnabled(true);
            }
        });
    }

    public void resetProgress() {
        this.progressMessageLabel.setText(" ");
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SchemaPanel.this.schemaButton) {
                SchemaPanel.this.schemaButtonActionPerformed(actionEvent);
            }
        }
    }
}

