/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTuplePredicate
implements StarPredicate {
    private final Bound[] bounds;
    private final List<RolapStar.Column> columnList;

    public MemberTuplePredicate(Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapMember lower, boolean lowerStrict, RolapMember upper, boolean upperStrict) {
        this.columnList = this.computeColumnList(lower != null ? lower : upper, levelToColumnMap);
        if (lower == null) {
            assert (upper != null);
            this.bounds = new Bound[]{new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE)};
        } else {
            this.bounds = upper == null ? new Bound[]{new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE)} : new Bound[]{new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE), new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE)};
        }
    }

    public MemberTuplePredicate(Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapMember member) {
        this.columnList = this.computeColumnList(member, levelToColumnMap);
        this.bounds = new Bound[]{new Bound(member, RelOp.EQ)};
    }

    public int hashCode() {
        return ((Object)this.columnList).hashCode() * 31 + Arrays.hashCode(this.bounds) * 31;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MemberTuplePredicate) {
            MemberTuplePredicate that = (MemberTuplePredicate)obj;
            return ((Object)this.columnList).equals(that.columnList) && Arrays.equals(this.bounds, that.bounds);
        }
        return false;
    }

    private List<RolapStar.Column> computeColumnList(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap) {
        ArrayList<RolapStar.Column> columnList = new ArrayList<RolapStar.Column>();
        while (true) {
            RolapLevel level = member.getLevel();
            columnList.add(0, levelToColumnMap.get(level));
            if (level.isUnique()) {
                return columnList;
            }
            member = member.getParentMember();
        }
    }

    @Override
    public List<RolapStar.Column> getConstrainedColumnList() {
        return this.columnList;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate minus(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        for (Bound bound : this.bounds) {
            block7: for (int k = 0; k < bound.values.length; ++k) {
                Object value = valueList.get(k);
                if (value == WILDCARD) {
                    return false;
                }
                Object boundValue = bound.values[k];
                RelOp relOp = bound.relOps[k];
                int c = Util.compareKey(value, boundValue);
                switch (relOp) {
                    case GT: {
                        if (c > 0) continue block7;
                        return false;
                    }
                    case GE: {
                        if (c > 0) {
                            return true;
                        }
                        if (c == 0) continue block7;
                        return false;
                    }
                    case LT: {
                        if (c < 0) continue block7;
                        return false;
                    }
                    case LE: {
                        if (c < 0) {
                            return true;
                        }
                        if (c == 0) continue block7;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void describe(StringBuilder buf) {
        int k = 0;
        for (Bound bound : this.bounds) {
            if (k++ > 0) {
                buf.append(" AND ");
            }
            buf.append(bound.relOps[bound.relOps.length - 1].getOp());
            buf.append(' ');
            buf.append(bound.member);
        }
    }

    private static class Bound {
        private final RolapMember member;
        private final Object[] values;
        private final RelOp[] relOps;

        Bound(RolapMember member, RelOp relOp) {
            this.member = member;
            ArrayList<Object> valueList = new ArrayList<Object>();
            ArrayList<RelOp> relOpList = new ArrayList<RelOp>();
            while (true) {
                valueList.add(0, member.getKey());
                relOpList.add(0, relOp);
                if (member.getLevel().isUnique()) break;
                member = member.getParentMember();
                switch (relOp) {
                    case GT: {
                        relOp = RelOp.GE;
                        break;
                    }
                    case LT: {
                        relOp = RelOp.LE;
                    }
                }
            }
            this.values = valueList.toArray(new Object[valueList.size()]);
            this.relOps = relOpList.toArray(new RelOp[relOpList.size()]);
        }

        public int hashCode() {
            int h = this.member.hashCode();
            h = h * 31 + Arrays.hashCode(this.values);
            h = h * 31 + Arrays.hashCode((Object[])this.relOps);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bound) {
                Bound that = (Bound)obj;
                return this.member.equals((OlapElement)that.member) && Arrays.equals(this.values, that.values) && Arrays.equals((Object[])this.relOps, (Object[])that.relOps);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RelOp {
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">="),
        EQ("=");

        private final String op;

        private RelOp(String op) {
            this.op = op;
        }

        String getOp() {
            return this.op;
        }
    }
}

