/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jca.cci.connection.DelegatingConnectionFactory;

public class SingleConnectionFactory
extends DelegatingConnectionFactory
implements DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Connection target;
    private Connection connection;
    static /* synthetic */ Class class$javax$resource$cci$Connection;

    public SingleConnectionFactory() {
    }

    public SingleConnectionFactory(Connection target) {
        this.target = target;
        this.connection = this.getCloseSuppressingConnectionProxy(target);
        this.afterPropertiesSet();
    }

    public SingleConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.setTargetConnectionFactory(targetConnectionFactory);
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        if (this.connection == null && this.getTargetConnectionFactory() == null) {
            throw new IllegalArgumentException("connection or targetConnectionFactory is required");
        }
    }

    protected void init() throws ResourceException {
        if (this.getTargetConnectionFactory() == null) {
            throw new IllegalStateException("targetConnectionFactory is required for lazily initializing a connection");
        }
        Connection target = this.doCreateConnection();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created single connection: " + target));
        }
        this.target = target;
        this.connection = this.getCloseSuppressingConnectionProxy(target);
    }

    protected Connection doCreateConnection() throws ResourceException {
        return this.getTargetConnectionFactory().getConnection();
    }

    public void destroy() throws ResourceException {
        if (this.target != null) {
            this.target.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws ResourceException {
        SingleConnectionFactory singleConnectionFactory = this;
        synchronized (singleConnectionFactory) {
            if (this.connection == null) {
                this.init();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning single connection: " + this.connection));
        }
        return this.connection;
    }

    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        throw new NotSupportedException("SingleConnectionFactory does not support custom ConnectionSpec");
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        return this.getTargetConnectionFactory().getRecordFactory();
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return this.getTargetConnectionFactory().getMetaData();
    }

    public void setReference(Reference reference) {
        this.getTargetConnectionFactory().setReference(reference);
    }

    public Reference getReference() throws NamingException {
        return this.getTargetConnectionFactory().getReference();
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance((class$javax$resource$cci$Connection == null ? (class$javax$resource$cci$Connection = SingleConnectionFactory.class$("javax.resource.cci.Connection")) : class$javax$resource$cci$Connection).getClassLoader(), new Class[]{class$javax$resource$cci$Connection == null ? (class$javax$resource$cci$Connection = SingleConnectionFactory.class$("javax.resource.cci.Connection")) : class$javax$resource$cci$Connection}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        private CloseSuppressingInvocationHandler(Connection source) {
            this.target = source;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

