/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.File;
import java.io.Serializable;
import net.sf.jasperreports.compilers.JRBshEvaluator;
import net.sf.jasperreports.compilers.JRBshGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;

public class JRBshCompiler
extends JRAbstractCompiler {
    public static final String LANGUAGE_BSH = "bsh";

    public JRBshCompiler() {
        super(false);
    }

    protected JREvaluator loadEvaluator(Serializable compileData, String unitName) throws JRException {
        return new JRBshEvaluator((String)((Object)compileData));
    }

    protected void checkLanguage(String language) throws JRException {
        if (!LANGUAGE_BSH.equals(language) && !"java".equals(language)) {
            throw new JRException("Language \"" + language + "\" not supported by this report compiler.\n" + "Expecting \"bsh\" or \"java\" instead.");
        }
    }

    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return new JRDefaultCompilationSourceCode(JRBshGenerator.generateScript(sourceTask), null);
    }

    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        this.verifyScripts(units);
        for (int i = 0; i < units.length; ++i) {
            String script = units[i].getSourceCode();
            units[i].setCompileData((Serializable)((Object)script));
        }
        return null;
    }

    private void verifyScripts(JRCompilationUnit[] units) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(JRCalculator.class.getName());
        }
        catch (ClassNotFoundException e) {
            classLoader = this.getClass().getClassLoader();
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        for (int i = 0; i < units.length; ++i) {
            String script = units[i].getSourceCode();
            JRBshEvaluator bshEvaluator = new JRBshEvaluator(script);
            bshEvaluator.verify(units[i].getExpressions());
        }
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
    }

    protected String getSourceFileName(String unitName) {
        return unitName + ".bsh";
    }
}

