/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanDefinitionRegistryBuilder {
    private final BeanDefinitionRegistry registry;

    public BeanDefinitionRegistryBuilder(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    public BeanDefinitionBuilder register(String name, BeanDefinitionBuilder builder) {
        builder.assignBeanName(name);
        this.registry.registerBeanDefinition(name, builder.getBeanDefinition());
        return builder;
    }

    public BeanDefinitionBuilder register(BeanDefinitionBuilder builder) {
        String generatedBeanName = BeanDefinitionReaderUtils.generateBeanName(builder.getBeanDefinition(), this.registry, false);
        return this.register(generatedBeanName, builder);
    }
}

