/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.StringUtils;

public class AspectJAdviceParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static final String THIS_JOIN_POINT = "thisJoinPoint";
    private static final String THIS_JOIN_POINT_STATIC_PART = "thisJoinPointStaticPart";
    private static final int STEP_JOIN_POINT_BINDING = 1;
    private static final int STEP_THROWING_BINDING = 2;
    private static final int STEP_ANNOTATION_BINDING = 3;
    private static final int STEP_RETURNING_BINDING = 4;
    private static final int STEP_PRIMITIVE_ARGS_BINDING = 5;
    private static final int STEP_THIS_TARGET_ARGS_BINDING = 6;
    private static final int STEP_FINISHED = 7;
    private static final Set singleValuedAnnotationPcds = new HashSet();
    private static Class annotationClass;
    private boolean raiseExceptions = false;
    private String returningName = null;
    private String throwingName = null;
    private String pointcutExpression = null;
    private Class[] argumentTypes;
    private String[] parameterNameBindings;
    private int numberOfRemainingUnboundArguments;
    private int algorithmicStep = 1;
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint;
    static /* synthetic */ Class class$org$aspectj$lang$ProceedingJoinPoint;
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint$StaticPart;
    static /* synthetic */ Class class$java$lang$Throwable;

    public AspectJAdviceParameterNameDiscoverer(String pointcutExpression) {
        this.pointcutExpression = pointcutExpression;
    }

    public void setRaiseExceptions(boolean shouldRaise) {
        this.raiseExceptions = shouldRaise;
    }

    public void setReturningName(String returningName) {
        this.returningName = returningName;
    }

    public void setThrowingName(String throwingName) {
        this.throwingName = throwingName;
    }

    public String[] getParameterNames(Method method, Class clazz) {
        this.argumentTypes = method.getParameterTypes();
        this.numberOfRemainingUnboundArguments = this.argumentTypes.length;
        this.parameterNameBindings = new String[this.numberOfRemainingUnboundArguments];
        this.algorithmicStep = 1;
        int minimumNumberUnboundArgs = 0;
        if (this.returningName != null) {
            ++minimumNumberUnboundArgs;
        }
        if (this.throwingName != null) {
            ++minimumNumberUnboundArgs;
        }
        if (this.numberOfRemainingUnboundArguments < minimumNumberUnboundArgs) {
            throw new IllegalStateException("Not enough arguments in method to satisfy binding of returning and throwing variables");
        }
        try {
            block11: while (this.numberOfRemainingUnboundArguments > 0 && this.algorithmicStep < 7) {
                switch (this.algorithmicStep++) {
                    case 1: {
                        if (this.maybeBindThisJoinPoint()) continue block11;
                        this.maybeBindThisJoinPointStaticPart();
                        continue block11;
                    }
                    case 2: {
                        this.maybeBindThrowingVariable();
                        continue block11;
                    }
                    case 3: {
                        this.maybeBindAnnotationsFromPointcutExpression();
                        continue block11;
                    }
                    case 4: {
                        this.maybeBindReturningVariable();
                        continue block11;
                    }
                    case 5: {
                        this.maybeBindPrimitiveArgsFromPointcutExpression();
                        continue block11;
                    }
                    case 6: {
                        this.maybeBindThisOrTargetOrArgsFromPointcutExpression();
                        continue block11;
                    }
                }
                throw new IllegalStateException("Unknown algorithmic step: " + (this.algorithmicStep - 1));
            }
        }
        catch (AmbiguousBindingException ambigEx) {
            if (this.raiseExceptions) {
                throw ambigEx;
            }
            return null;
        }
        catch (IllegalArgumentException illArgEx) {
            if (this.raiseExceptions) {
                throw illArgEx;
            }
            return null;
        }
        if (this.numberOfRemainingUnboundArguments == 0) {
            return this.parameterNameBindings;
        }
        if (this.raiseExceptions) {
            throw new IllegalStateException("Failed to bind all argument names: " + this.numberOfRemainingUnboundArguments + " argument(s) could not be bound");
        }
        return null;
    }

    public String[] getParameterNames(Constructor ctor) {
        if (this.raiseExceptions) {
            throw new UnsupportedOperationException("An advice method can never be a constructor");
        }
        return null;
    }

    private void bindParameterName(int index, String name) {
        this.parameterNameBindings[index] = name;
        --this.numberOfRemainingUnboundArguments;
    }

    private boolean maybeBindThisJoinPoint() {
        if (this.argumentTypes[0] == (class$org$aspectj$lang$JoinPoint == null ? (class$org$aspectj$lang$JoinPoint = AspectJAdviceParameterNameDiscoverer.class$("org.aspectj.lang.JoinPoint")) : class$org$aspectj$lang$JoinPoint) || this.argumentTypes[0] == (class$org$aspectj$lang$ProceedingJoinPoint == null ? (class$org$aspectj$lang$ProceedingJoinPoint = AspectJAdviceParameterNameDiscoverer.class$("org.aspectj.lang.ProceedingJoinPoint")) : class$org$aspectj$lang$ProceedingJoinPoint)) {
            this.bindParameterName(0, THIS_JOIN_POINT);
            return true;
        }
        return false;
    }

    private void maybeBindThisJoinPointStaticPart() {
        if (this.argumentTypes[0] == (class$org$aspectj$lang$JoinPoint$StaticPart == null ? (class$org$aspectj$lang$JoinPoint$StaticPart = AspectJAdviceParameterNameDiscoverer.class$("org.aspectj.lang.JoinPoint$StaticPart")) : class$org$aspectj$lang$JoinPoint$StaticPart)) {
            this.bindParameterName(0, THIS_JOIN_POINT_STATIC_PART);
        }
    }

    private void maybeBindThrowingVariable() {
        if (this.throwingName == null) {
            return;
        }
        int throwableIndex = -1;
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (!this.isUnbound(i) || !this.isSubtypeOf(class$java$lang$Throwable == null ? AspectJAdviceParameterNameDiscoverer.class$("java.lang.Throwable") : class$java$lang$Throwable, i)) continue;
            if (throwableIndex == -1) {
                throwableIndex = i;
                continue;
            }
            throw new AmbiguousBindingException("Binding of throwing parameter '" + this.throwingName + "' is ambiguous: could be bound to argument " + throwableIndex + " or argument " + i);
        }
        if (throwableIndex == -1) {
            throw new IllegalStateException("Binding of throwing parameter '" + this.throwingName + "' could not be completed as no available arguments are a subtype of Throwable");
        }
        this.bindParameterName(throwableIndex, this.throwingName);
    }

    private void maybeBindReturningVariable() {
        if (this.numberOfRemainingUnboundArguments == 0) {
            throw new IllegalStateException("algorithm assumes that there must be at least one unbound parameter on entry to this method");
        }
        if (this.returningName != null) {
            if (this.numberOfRemainingUnboundArguments > 1) {
                throw new AmbiguousBindingException("Binding of returning parameter '" + this.returningName + "' is ambiguous, there are " + this.numberOfRemainingUnboundArguments + " candidates.");
            }
            for (int i = 0; i < this.parameterNameBindings.length; ++i) {
                if (this.parameterNameBindings[i] != null) continue;
                this.bindParameterName(i, this.returningName);
                break;
            }
        }
    }

    private void maybeBindAnnotationsFromPointcutExpression() {
        ArrayList<String> varNames = new ArrayList<String>();
        String[] tokens = StringUtils.tokenizeToStringArray(this.pointcutExpression, " ");
        for (int i = 0; i < tokens.length; ++i) {
            PointcutBody body;
            String toMatch = tokens[i];
            int firstParenIndex = toMatch.indexOf("(");
            if (firstParenIndex != -1) {
                toMatch = toMatch.substring(0, firstParenIndex);
            }
            if (singleValuedAnnotationPcds.contains(toMatch)) {
                body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                String varName = this.maybeExtractVariableName(body.text);
                if (varName == null) continue;
                varNames.add(varName);
                continue;
            }
            if (!tokens[i].startsWith("@args(") && !tokens[i].equals("@args")) continue;
            body = this.getPointcutBody(tokens, i);
            i += body.numTokensConsumed;
            this.maybeExtractVariableNamesFromArgs(body.text, varNames);
        }
        this.bindAnnotationsFromVarNames(varNames);
    }

    private void bindAnnotationsFromVarNames(List varNames) {
        if (!varNames.isEmpty()) {
            int numAnnotationSlots = this.countNumberOfUnboundAnnotationArguments();
            if (numAnnotationSlots > 1) {
                throw new AmbiguousBindingException("Found " + varNames.size() + " potential annotation variable(s), and " + numAnnotationSlots + " potential argument slots");
            }
            if (numAnnotationSlots == 1) {
                if (varNames.size() == 1) {
                    this.findAndBind(annotationClass, (String)varNames.get(0));
                } else {
                    throw new IllegalArgumentException("Found " + varNames.size() + " candidate annotation binding variables" + " but only one potential argument binding slot");
                }
            }
        }
    }

    private String maybeExtractVariableName(String candidateToken) {
        if (candidateToken == null) {
            return null;
        }
        if (Character.isJavaIdentifierStart(candidateToken.charAt(0))) {
            char[] tokenChars = candidateToken.toCharArray();
            for (int i = 0; i < tokenChars.length; ++i) {
                if (Character.isJavaIdentifierPart(tokenChars[i])) continue;
                return null;
            }
            return candidateToken;
        }
        return null;
    }

    private void maybeExtractVariableNamesFromArgs(String argsSpec, List varNames) {
        if (argsSpec == null) {
            return;
        }
        String[] tokens = StringUtils.tokenizeToStringArray(argsSpec, ",");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = StringUtils.trimWhitespace(tokens[i]);
            String varName = this.maybeExtractVariableName(tokens[i]);
            if (varName == null) continue;
            varNames.add(varName);
        }
    }

    private void maybeBindThisOrTargetOrArgsFromPointcutExpression() {
        if (this.numberOfRemainingUnboundArguments > 1) {
            throw new AmbiguousBindingException("Still " + this.numberOfRemainingUnboundArguments + " unbound args at this(),target(),args() binding stage, with no way to determine between them");
        }
        ArrayList<String> varNames = new ArrayList<String>();
        String[] tokens = StringUtils.tokenizeToStringArray(this.pointcutExpression, " ");
        for (int i = 0; i < tokens.length; ++i) {
            PointcutBody body;
            if (tokens[i].equals("this") || tokens[i].startsWith("this(") || tokens[i].equals("target") || tokens[i].startsWith("target(")) {
                body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                String varName = this.maybeExtractVariableName(body.text);
                if (varName == null) continue;
                varNames.add(varName);
                continue;
            }
            if (!tokens[i].equals("args") && !tokens[i].startsWith("args(")) continue;
            body = this.getPointcutBody(tokens, i);
            i += body.numTokensConsumed;
            ArrayList candidateVarNames = new ArrayList();
            this.maybeExtractVariableNamesFromArgs(body.text, candidateVarNames);
            Iterator iter = candidateVarNames.iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                if (this.alreadyBound(varName)) continue;
                varNames.add(varName);
            }
        }
        if (varNames.size() > 1) {
            throw new AmbiguousBindingException("Found " + varNames.size() + " candidate this(), target() or args() variables but only one unbound argument slot");
        }
        if (varNames.size() == 1) {
            for (int j = 0; j < this.parameterNameBindings.length; ++j) {
                if (!this.isUnbound(j)) continue;
                this.bindParameterName(j, (String)varNames.get(0));
                break;
            }
        }
    }

    private PointcutBody getPointcutBody(String[] tokens, int startIndex) {
        int numTokensConsumed = 0;
        String currentToken = tokens[startIndex];
        int bodyStart = currentToken.indexOf(40);
        if (currentToken.charAt(currentToken.length() - 1) == ')') {
            return new PointcutBody(0, currentToken.substring(bodyStart + 1, currentToken.length() - 1));
        }
        StringBuffer sb = new StringBuffer();
        if (bodyStart >= 0 && bodyStart != currentToken.length() - 1) {
            sb.append(currentToken.substring(bodyStart + 1));
            sb.append(" ");
        }
        int currentIndex = startIndex + ++numTokensConsumed;
        while (currentIndex < tokens.length) {
            if (tokens[currentIndex].equals("(")) continue;
            if (tokens[currentIndex].endsWith(")")) {
                sb.append(tokens[currentIndex].substring(0, tokens[currentIndex].length() - 1));
                return new PointcutBody(numTokensConsumed, sb.toString().trim());
            }
            String toAppend = tokens[currentIndex];
            if (toAppend.startsWith("(")) {
                toAppend = toAppend.substring(1);
            }
            sb.append(toAppend);
            sb.append(" ");
            ++currentIndex;
            ++numTokensConsumed;
        }
        return new PointcutBody(numTokensConsumed, null);
    }

    private void maybeBindPrimitiveArgsFromPointcutExpression() {
        int numUnboundPrimitives = this.countNumberOfUnboundPrimitiveArguments();
        if (numUnboundPrimitives > 1) {
            throw new AmbiguousBindingException("Found '" + numUnboundPrimitives + "' unbound primitive arguments with no way to distinguish between them.");
        }
        if (numUnboundPrimitives == 1) {
            int i;
            ArrayList varNames = new ArrayList();
            String[] tokens = StringUtils.tokenizeToStringArray(this.pointcutExpression, " ");
            for (i = 0; i < tokens.length; ++i) {
                if (!tokens[i].equals("args") && !tokens[i].startsWith("args(")) continue;
                PointcutBody body = this.getPointcutBody(tokens, i);
                i += body.numTokensConsumed;
                this.maybeExtractVariableNamesFromArgs(body.text, varNames);
            }
            if (varNames.size() > 1) {
                throw new AmbiguousBindingException("Found " + varNames.size() + " candidate variable names but only one candidate binding slot when matching primitive args");
            }
            if (varNames.size() == 0) {
                throw new IllegalArgumentException("Unable to find args match for unbound primitive argument");
            }
            for (i = 0; i < this.argumentTypes.length; ++i) {
                if (!this.isUnbound(i) || !this.argumentTypes[i].isPrimitive()) continue;
                this.bindParameterName(i, (String)varNames.get(0));
                break;
            }
        }
    }

    private boolean isUnbound(int i) {
        return this.parameterNameBindings[i] == null;
    }

    private boolean alreadyBound(String varName) {
        for (int i = 0; i < this.parameterNameBindings.length; ++i) {
            if (this.isUnbound(i) || !varName.equals(this.parameterNameBindings[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOf(Class supertype, int argumentNumber) {
        return supertype.isAssignableFrom(this.argumentTypes[argumentNumber]);
    }

    private int countNumberOfUnboundAnnotationArguments() {
        if (annotationClass == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (!this.isUnbound(i) || !this.isSubtypeOf(annotationClass, i)) continue;
            ++count;
        }
        return count;
    }

    private int countNumberOfUnboundPrimitiveArguments() {
        int count = 0;
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (!this.isUnbound(i) || !this.argumentTypes[i].isPrimitive()) continue;
            ++count;
        }
        return count;
    }

    private void findAndBind(Class argumentType, String varName) {
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (!this.isUnbound(i) || !this.isSubtypeOf(argumentType, i)) continue;
            this.bindParameterName(i, varName);
            return;
        }
        throw new IllegalStateException("Expected to find an unbound argument of type '" + argumentType.getName() + "'");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        singleValuedAnnotationPcds.add("@this");
        singleValuedAnnotationPcds.add("@target");
        singleValuedAnnotationPcds.add("@within");
        singleValuedAnnotationPcds.add("@withincode");
        singleValuedAnnotationPcds.add("@annotation");
        try {
            annotationClass = Class.forName("java.lang.annotation.Annotation");
        }
        catch (ClassNotFoundException cnfEx) {
            annotationClass = null;
        }
    }

    private static class PointcutBody {
        int numTokensConsumed = 0;
        String text = null;

        public PointcutBody(int tokens, String text) {
            this.numTokensConsumed = tokens;
            this.text = text;
        }
    }

    public static class AmbiguousBindingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AmbiguousBindingException(String explanation) {
            super(explanation);
        }
    }
}

