/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java_cup.runtime.Symbol;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.bidirectional.AxisEmpty;
import rex.bidirectional.UnSupportedFunctions;
import rex.graphics.StatusBar;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.DimensionTree;
import rex.graphics.dimensiontree.DimensionTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.ColorMenu;
import rex.graphics.mdxeditor.MdxEditorToolbar;
import rex.graphics.mdxeditor.MdxFunctionTree;
import rex.graphics.mdxeditor.MdxResultViewer;
import rex.graphics.mdxeditor.jsp.ReadEnv;
import rex.graphics.mdxeditor.jsp.SaveJSPListener;
import rex.graphics.mdxeditor.mdxbuilder.HandlesMdxEditorSettings;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderListener;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderTree;
import rex.graphics.mdxeditor.mdxbuilder.dnd.DimensionTreeToMBTDragSource;
import rex.graphics.mdxeditor.mdxbuilder.dnd.FunctionTreeToMBTDragSource;
import rex.graphics.mdxeditor.mdxbuilder.dnd.MBTtoMBTDragSource;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTAxisNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTCalculatedMemberNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTWithMembersNode;
import rex.metadata.ExecuteResult;
import rex.metadata.Query;
import rex.metadata.ServerMetadata;
import rex.olap.mdxparse.Exp;
import rex.olap.mdxparse.Formula;
import rex.olap.mdxparse.Lexer;
import rex.olap.mdxparse.ParsedQuery;
import rex.olap.mdxparse.parser;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;

public class MdxEditor
extends JPanel
implements MdxBuilderListener,
HandlesMdxEditorSettings,
LanguageChangedListener {
    private XMLADiscoverProperties properties;
    private XMLADiscoverRestrictions restrictions;
    private ServerMetadata smd;
    private StatusBar statusBar;
    private DimensionTree dimTree;
    private String cubeName;
    private MdxBuilderTree builderTree;
    private DimensionTreeToMBTDragSource dimTreeDragSource;
    private MBTtoMBTDragSource builderTreeDragSource;
    private FunctionTreeToMBTDragSource functionTreeDragSource;
    private String defaultSaveDirectory;
    public JTextArea textArea;
    ColorMenu foregroundMenu;
    ColorMenu backgroundMenu;
    int x = 0;
    int y = 0;
    JMenuItem mnuSaveJSP = new JMenuItem(I18n.getString("menu.saveToJsp"));
    JMenuItem mnuCreateTree = new JMenuItem(I18n.getString("menu.updateMBTree"));
    boolean stopSearch;
    int[] setNum;
    private JLabel lblFileName;
    JPanel textPanel;
    JPopupMenu popup;
    MdxEditorToolbar toolbar;
    static Document document;
    JPanel editorPane;
    JPanel resultPane;
    private boolean isTabbed;
    MdxResultViewer resultViewer;
    JSplitPane jspDimAndFuncTree;
    private static HashMap keywords;

    public MdxEditor(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, String _cubeName) {
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.smd = _smd;
        this.cubeName = _cubeName;
        this.foregroundMenu = new ColorMenu(I18n.getString("menu.foregroundColor"));
        this.foregroundMenu.addActionListener(new ForegroundListener());
        this.backgroundMenu = new ColorMenu(I18n.getString("menu.backgroundColor"));
        this.backgroundMenu.addActionListener(new BackgroundListener());
        this.mnuSaveJSP.addActionListener(new SaveJSP());
        this.mnuCreateTree.addActionListener(new CreateTree());
        this.popup = new JPopupMenu();
        this.popup.add(this.foregroundMenu);
        this.popup.add(this.backgroundMenu);
        this.popup.add(this.mnuSaveJSP);
        this.popup.add(this.mnuCreateTree);
        this.dimTree = new DimensionTree(this.restrictions, this.properties, this.smd, this);
        this.dimTree.setPreferredSize(new Dimension((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 5.0), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.1)));
        this.dimTreeDragSource = new DimensionTreeToMBTDragSource(this.dimTree.getTree(), 3);
        this.builderTree = new MdxBuilderTree(this, this, this.cubeName);
        this.builderTree.setPreferredSize(new Dimension((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 5.0), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 1.1)));
        this.builderTreeDragSource = new MBTtoMBTDragSource(this.builderTree.getTree(), 3);
        this.textArea = new JTextArea();
        this.textArea.addMouseListener(new PopupListener());
        this.textArea.addKeyListener(new TextAreaKeyListener());
        this.toolbar = new MdxEditorToolbar(this);
        this.editorPane = new JPanel();
        this.editorPane.setLayout(new BorderLayout());
        MdxFunctionTree fTree = new MdxFunctionTree(this);
        this.functionTreeDragSource = new FunctionTreeToMBTDragSource(fTree.getTree(), 3);
        fTree.setPreferredSize(new Dimension((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 5.0), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.1)));
        this.jspDimAndFuncTree = new JSplitPane(0, this.dimTree, fTree);
        this.jspDimAndFuncTree.setOneTouchExpandable(true);
        this.jspDimAndFuncTree.setDividerSize(8);
        JSplitPane jspTrees = new JSplitPane(1, this.jspDimAndFuncTree, this.builderTree);
        jspTrees.setDividerSize(8);
        this.lblFileName = new JLabel("", 0);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)this.lblFileName, "North");
        textPanel.add((Component)new JScrollPane(this.textArea), "Center");
        JSplitPane jspTreesAndText = new JSplitPane(1, jspTrees, textPanel);
        jspTreesAndText.setDividerSize(8);
        this.editorPane.add((Component)this.toolbar, "North");
        this.editorPane.add((Component)jspTreesAndText, "Center");
        this.resultPane = new JPanel(){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.resultPane.setLayout(new BoxLayout(this.resultPane, 1));
        this.statusBar = new StatusBar();
        this.setLayout(new BorderLayout());
        this.add((Component)new JSplitPane(0, this.editorPane, this.resultPane), "Center");
        this.add((Component)this.statusBar, "South");
        this.initDefaults();
        jspTreesAndText.setDividerLocation((int)(this.dimTree.getPreferredSize().getWidth() + this.builderTree.getPreferredSize().getWidth() + (double)jspTreesAndText.getDividerSize() + (double)jspTrees.getDividerSize()));
        this.jspDimAndFuncTree.setDividerLocation((int)this.dimTree.getPreferredSize().getHeight() - 180);
    }

    protected void setSplitPaneView(int splitType) {
        this.isTabbed = false;
        this.removeAll();
        JSplitPane jsp = new JSplitPane(splitType, this.editorPane, this.resultPane);
        jsp.setDividerSize(8);
        if (splitType == 0) {
            jsp.setDividerLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 1.8));
        }
        this.add((Component)jsp, "Center");
        this.add((Component)this.statusBar, "South");
        this.invalidate();
        this.revalidate();
        this.repaint();
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "RESULT_POSITION");
        n.removeChild(n.getChildNodes().item(0));
        if (splitType == 0) {
            n.appendChild(document.createTextNode(MdxEditorToolbar.VERTICAL_SPLIT_PANE));
        } else {
            n.appendChild(document.createTextNode(MdxEditorToolbar.HORIZONTAL_SPLIT_PANE));
        }
        this.saveDefaults();
    }

    protected void setTabbedPaneView(int tabPlacement) {
        this.isTabbed = true;
        this.removeAll();
        JTabbedPane tp = new JTabbedPane(tabPlacement);
        tp.add("Editor", this.editorPane);
        tp.add("Result", this.resultPane);
        this.add((Component)tp, "Center");
        this.add((Component)this.statusBar, "South");
        this.invalidate();
        this.revalidate();
        this.repaint();
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "RESULT_POSITION");
        n.removeChild(n.getChildNodes().item(0));
        if (tabPlacement == 1) {
            n.appendChild(document.createTextNode(MdxEditorToolbar.TABBED_PANE_UP));
        } else if (tabPlacement == 3) {
            n.appendChild(document.createTextNode(MdxEditorToolbar.TABBED_PANE_BOTTOM));
        } else if (tabPlacement == 2) {
            n.appendChild(document.createTextNode(MdxEditorToolbar.TABBED_PANE_LEFT));
        } else if (tabPlacement == 4) {
            n.appendChild(document.createTextNode(MdxEditorToolbar.TABBED_PANE_RIGHT));
        }
        this.saveDefaults();
    }

    private void initDefaults() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return;
        }
        try {
            document = builder.parse(new File("mdxeditor.defaults.xml"));
        }
        catch (IOException ioe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fontName = new String("Courier New");
        int fontStyle = 0;
        int fontSize = 10;
        String[] recentURL = new String[4];
        NodeList nl = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("FONT_NAME")) {
                fontName = new String(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("FONT_SIZE")) {
                try {
                    fontSize = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("BOLD") && DOM.getTextFromDOMElement(nl.item(i)).equalsIgnoreCase("true")) {
                fontStyle |= 1;
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("ITALIC") && DOM.getTextFromDOMElement(nl.item(i)).equalsIgnoreCase("true")) {
                fontStyle |= 2;
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("TAB_SIZE")) {
                try {
                    int tabSize = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                    this.setTabSize(tabSize);
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("FOREGROUND_COLOR")) {
                try {
                    int rgb = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                    this.setForegroundColor(new Color(rgb));
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("BACKGROUND_COLOR")) {
                try {
                    int rgb = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                    this.setBackgroundColor(new Color(rgb));
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("RESULT_POSITION")) {
                String s = DOM.getTextFromDOMElement(nl.item(i));
                if (s.equals(MdxEditorToolbar.VERTICAL_SPLIT_PANE)) {
                    this.setSplitPaneView(0);
                    this.toolbar.setcbResultPosition(MdxEditorToolbar.VERTICAL_SPLIT_PANE);
                    continue;
                }
                if (s.equals(MdxEditorToolbar.HORIZONTAL_SPLIT_PANE)) {
                    this.setSplitPaneView(1);
                    this.toolbar.setcbResultPosition(MdxEditorToolbar.HORIZONTAL_SPLIT_PANE);
                    continue;
                }
                if (s.equals(MdxEditorToolbar.TABBED_PANE_UP)) {
                    this.setTabbedPaneView(1);
                    this.toolbar.setcbResultPosition(MdxEditorToolbar.TABBED_PANE_UP);
                    continue;
                }
                if (s.equals(MdxEditorToolbar.TABBED_PANE_LEFT)) {
                    this.setTabbedPaneView(2);
                    this.toolbar.setcbResultPosition(MdxEditorToolbar.TABBED_PANE_LEFT);
                    continue;
                }
                if (s.equals(MdxEditorToolbar.TABBED_PANE_RIGHT)) {
                    this.setTabbedPaneView(4);
                    this.toolbar.setcbResultPosition(MdxEditorToolbar.TABBED_PANE_RIGHT);
                    continue;
                }
                if (!s.equals(MdxEditorToolbar.TABBED_PANE_BOTTOM)) continue;
                this.setTabbedPaneView(3);
                this.toolbar.setcbResultPosition(MdxEditorToolbar.TABBED_PANE_BOTTOM);
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("SAVE_DIRECTORY")) {
                try {
                    this.defaultSaveDirectory = new String(DOM.getTextFromDOMElement(nl.item(i)));
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("RECENT_OPENED_FILE1")) {
                recentURL[0] = new String(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("RECENT_OPENED_FILE2")) {
                recentURL[1] = new String(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equalsIgnoreCase("RECENT_OPENED_FILE3")) {
                recentURL[2] = new String(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equalsIgnoreCase("RECENT_OPENED_FILE4")) continue;
            recentURL[3] = new String(DOM.getTextFromDOMElement(nl.item(i)));
        }
        Font newFont = new Font(fontName, fontStyle, fontSize);
        this.textArea.setFont(newFont);
        this.toolbar.setcbFont(fontName);
        this.toolbar.setcbSize(fontSize);
        this.toolbar.setBold((fontStyle & 1) == 1);
        this.toolbar.setItalic((fontStyle & 2) == 2);
        this.toolbar.setTabSize(this.textArea.getTabSize());
        this.toolbar.setRecentURL(recentURL);
    }

    private void saveDefaults() {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new BufferedWriter(new FileWriter(new File("mdxeditor.defaults.xml"))));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            S.out("Unable to save defaults:");
        }
    }

    public void setRecentURL(String[] url) {
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "RECENT_OPENED_FILE1");
        try {
            n.removeChild(n.getChildNodes().item(0));
            n.appendChild(document.createTextNode(url[0].trim().length() > 0 ? url[0] : " "));
        }
        catch (Exception exc) {
            n.appendChild(document.createTextNode(url[0].trim().length() > 0 ? url[0] : " "));
        }
        n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "RECENT_OPENED_FILE2");
        try {
            n.removeChild(n.getChildNodes().item(0));
            n.appendChild(document.createTextNode(url[1].trim().length() > 0 ? url[1] : " "));
        }
        catch (Exception exc) {
            n.appendChild(document.createTextNode(url[1].trim().length() > 0 ? url[1] : " "));
        }
        n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "RECENT_OPENED_FILE3");
        try {
            n.removeChild(n.getChildNodes().item(0));
            n.appendChild(document.createTextNode(url[2].trim().length() > 0 ? url[2] : " "));
        }
        catch (Exception exc) {
            n.appendChild(document.createTextNode(url[2].trim().length() > 0 ? url[2] : " "));
        }
        n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "RECENT_OPENED_FILE4");
        try {
            n.removeChild(n.getChildNodes().item(0));
            n.appendChild(document.createTextNode(url[3].trim().length() > 0 ? url[3] : " "));
        }
        catch (Exception exc) {
            n.appendChild(document.createTextNode(url[3].trim().length() > 0 ? url[3] : " "));
        }
        this.saveDefaults();
    }

    public void setLocaleEnabled(boolean b) {
        this.toolbar.setLocaleEnabled(b);
    }

    public MdxEditorToolbar getToolbar() {
        return this.toolbar;
    }

    void setTextToBold(boolean isBold) {
        Font font = this.textArea.getFont();
        String name = font.getName();
        int style = font.getStyle();
        int size = font.getSize();
        style = isBold ? (style |= 1) : (style &= 0xFFFFFFFE);
        Font newFont = new Font(name, style, size);
        this.textArea.setFont(newFont);
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "BOLD");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(isBold ? "true" : "false"));
        this.saveDefaults();
    }

    void setTextToItalic(boolean isItalic) {
        Font font = this.textArea.getFont();
        String name = font.getName();
        int style = font.getStyle();
        int size = font.getSize();
        style = isItalic ? (style |= 2) : (style &= 0xFFFFFFFD);
        Font newFont = new Font(name, style, size);
        this.textArea.setFont(newFont);
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "ITALIC");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(isItalic ? "true" : "false"));
        this.saveDefaults();
    }

    void setFontName(String fontName) {
        Font font = this.textArea.getFont();
        int style = font.getStyle();
        int size = font.getSize();
        Font newFont = new Font(fontName, style, size);
        this.textArea.setFont(newFont);
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "FONT_NAME");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(fontName));
        this.saveDefaults();
        this.textArea.requestFocus();
    }

    void setFontSize(int fontSize) {
        Font font = this.textArea.getFont();
        int style = font.getStyle();
        String name = font.getName();
        Font newFont = new Font(name, style, fontSize);
        this.textArea.setFont(newFont);
        this.textArea.requestFocus();
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "FONT_SIZE");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(Integer.toString(fontSize)));
        this.saveDefaults();
    }

    void setTabSize(int tabSize) {
        this.textArea.setTabSize(tabSize);
        this.textArea.requestFocus();
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "TAB_SIZE");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(Integer.toString(tabSize)));
        this.saveDefaults();
    }

    void setForegroundColor(Color newColor) {
        this.textArea.setForeground(newColor);
        this.textArea.requestFocus();
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "FOREGROUND_COLOR");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(Integer.toString(newColor.getRGB())));
        this.saveDefaults();
    }

    void setBackgroundColor(Color newColor) {
        this.textArea.setBackground(newColor);
        this.textArea.requestFocus();
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "BACKGROUND_COLOR");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(Integer.toString(newColor.getRGB())));
        this.saveDefaults();
    }

    public String getDefaultSaveDirectory() {
        return this.defaultSaveDirectory;
    }

    public void setDefaultSaveDirectory(String dir) {
        this.defaultSaveDirectory = dir;
        Node n = DOM.getFirstChildNodeWithName(document.getDocumentElement(), "SAVE_DIRECTORY");
        n.removeChild(n.getChildNodes().item(0));
        n.appendChild(document.createTextNode(dir));
        S.out("saving: " + this.defaultSaveDirectory);
        this.saveDefaults();
    }

    protected void setShowColumnTotalsOn(boolean newValue) {
        if (this.resultViewer != null) {
            this.resultViewer.setShowColumnTotalsOn(newValue);
        }
    }

    protected void setShowRowTotalsOn(boolean newValue) {
        if (this.resultViewer != null) {
            this.resultViewer.setShowRowTotalsOn(newValue);
        }
    }

    private String removeComments(String query) {
        int i = 0;
        while (query.indexOf("--") != -1) {
            ++i;
            if (query.indexOf("--") == 0) {
                query = query.substring(query.indexOf("\n") + 1);
                continue;
            }
            query = query.substring(0, query.indexOf("--")) + query.substring(query.indexOf("\n", query.indexOf("--")) + 1);
        }
        return query;
    }

    void runQuery(String q) {
        this.resultViewer = new MdxResultViewer(this.restrictions, this.properties, this.smd, this.removeComments(q), this.statusBar, this.toolbar.getShowRowTotalsOn(), this.toolbar.getShowColumnTotalsOn(), this, this.builderTree, this.dimTree);
        this.resultPane.removeAll();
        this.resultPane.add(this.resultViewer);
        this.resultPane.invalidate();
        this.resultPane.revalidate();
        this.resultPane.repaint();
        if (this.isTabbed && !this.resultViewer.getErrorOccured()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!(this.getComponent(i) instanceof JTabbedPane)) continue;
                ((JTabbedPane)this.getComponent(i)).setSelectedIndex(1);
            }
        }
    }

    void runAllQuery() {
        if (this.textArea.getText().trim().length() > 0) {
            this.runQuery(this.textArea.getText());
        }
    }

    void runSelectedQuery() {
        if (this.textArea.getSelectedText() != null) {
            this.runQuery(this.textArea.getSelectedText());
        }
    }

    void insertCodeSkeleton() {
        this.textArea.setText("" + this.textArea.getText() + "SELECT \nNON EMPTY\n{\n   Measures.AllMembers\n}\n ON COLUMNS,\nNON EMPTY\n{\n   \n}\nON ROWS\nFROM " + this.cubeName);
    }

    DimensionTree getDimensionTree() {
        return this.dimTree;
    }

    String getCubeName() {
        return this.cubeName;
    }

    public void mdxChanged(String newMdx) {
        int istart = this.textArea.getText().indexOf(MdxBuilderTree.OPEN_MDX_GENERATED_EXPRESSION_TAG);
        int iend = this.textArea.getText().indexOf(MdxBuilderTree.CLOSE_MDX_GENERATED_EXPRESSION_TAG);
        if (istart != -1 && iend != -1) {
            this.textArea.setText(this.textArea.getText().substring(0, istart) + MdxBuilderTree.OPEN_MDX_GENERATED_EXPRESSION_TAG + "\n-- ********* Generated(" + GregorianCalendar.getInstance().getTime() + "):  ********** \n" + "\n" + newMdx + "\n" + this.textArea.getText().substring(iend));
        } else {
            this.textArea.setText(MdxBuilderTree.OPEN_MDX_GENERATED_EXPRESSION_TAG + "\n-- ****** Generated(" + GregorianCalendar.getInstance().getTime() + "):  ****** \n" + "\n" + newMdx + "\n" + MdxBuilderTree.CLOSE_MDX_GENERATED_EXPRESSION_TAG + "\n\n" + this.textArea.getText());
        }
    }

    public void addTextToCurrentPosition(String s) {
        this.textArea.insert(s, this.textArea.getCaretPosition());
    }

    public void appendGeneratedMDX(String s) {
        if (this.toolbar.getAppendGeneratedMDX()) {
            this.textArea.append(s);
        }
    }

    private void parseQuery() {
        try {
            int childCount;
            int count;
            String[] str;
            String function = "";
            function = UnSupportedFunctions.searchFunctions(this.removeComments(this.textArea.getText()).toUpperCase());
            if (function != null) {
                JOptionPane.showMessageDialog(this, function + " " + I18n.getString("errorMessage.notImplemented"));
                return;
            }
            XMLAExecuteProperties execProperties = XMLAObjectsFactory.newXMLAExecuteProperties();
            execProperties.setDataSourceInfo(this.properties.getDataSourceInfo());
            execProperties.setCatalog(this.properties.getCatalog());
            Query q = new Query(this.getCubeName(), null);
            q.setQuery(new ExecuteResult(this.smd.execute(this.removeComments(this.textArea.getText()), execProperties), new Query(this.getCubeName(), null)));
            JTree bTree = this.builderTree.getTree();
            DefaultTreeModel treeModel = (DefaultTreeModel)bTree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                ((DefaultMBTNode)((DefaultMutableTreeNode)root.getChildAt(i)).getUserObject()).removeAllChildrenFromTheTree((DefaultMutableTreeNode)root.getChildAt(i), (DefaultTreeModel)bTree.getModel());
                ((DefaultTreeModel)bTree.getModel()).nodeChanged(root.getChildAt(i));
            }
            bTree.repaint();
            AxisEmpty axisEmpty = new AxisEmpty(this.removeComments(this.textArea.getText()));
            Object r = root.getUserObject();
            DefaultMutableTreeNode withTreeNode = (DefaultMutableTreeNode)root.getChildAt(0);
            DefaultMutableTreeNode colTreeNode = (DefaultMutableTreeNode)root.getChildAt(1);
            DefaultMutableTreeNode rowTreeNode = (DefaultMutableTreeNode)root.getChildAt(2);
            DefaultMutableTreeNode pageTreeNode = (DefaultMutableTreeNode)root.getChildAt(3);
            DefaultMutableTreeNode whereTreeNode = (DefaultMutableTreeNode)root.getChildAt(5);
            ((DefaultMBTAxisNode)((MBTNode)colTreeNode.getUserObject())).setNonEmpty(axisEmpty.isColumnEmpty());
            ((DefaultMBTAxisNode)((MBTNode)rowTreeNode.getUserObject())).setNonEmpty(axisEmpty.isRowEmpty());
            MBTNode[] children = ((MBTNode)r).getMdxBuilderTreeNodes();
            TreeElement dimTreeRoot = (TreeElement)((DimensionTreeModel)this.dimTree.getTree().getModel()).getRoot();
            int noOfDimension = dimTreeRoot.getChildCount();
            TreeElement[] dimTreeRootChild = new TreeElement[noOfDimension];
            for (int childCount2 = 0; childCount2 < noOfDimension; ++childCount2) {
                dimTreeRootChild[childCount2] = dimTreeRoot.getChildAt(childCount2);
            }
            SegregateMDXWithNWhere withNWhere = new SegregateMDXWithNWhere(this.removeComments(this.textArea.getText()));
            String[] with = withNWhere.getFormulas();
            String where = withNWhere.getSlicer();
            String[] columns = q.getMDXColumnsOnSelect();
            String[] rows = q.getMDXRowsOnSelect();
            String[] pages = q.getMDXPagesOnSelect();
            String[] dimensionOnWith = null;
            String[] calculatedFormula = null;
            String[] formatStringOnWith = null;
            Object memberOrSet = null;
            String[] calculatedMemberName = null;
            DefaultMutableTreeNode[] setNode = null;
            Object withSetName = null;
            Object withSetExp = null;
            String[] dimOnWith = null;
            String[] dimOnColumns = null;
            String[] dimOnRows = null;
            String[] dimOnPages = null;
            String dimOnWhere = null;
            int[] withOrSet = null;
            int countSet = 0;
            int setCounter = 0;
            String[] withSet = null;
            String[] setCalculatedMemberName = null;
            String[] setCalculatedFormula = null;
            StringBuffer[] tempSet = null;
            String member = "MEMBER";
            String set = "SET";
            String as = " AS ";
            String[][] setArray = null;
            String[][] setDimension = null;
            Object setAxisCount = null;
            Object axisSetCount = null;
            if (with != null && with.length != 0) {
                int countWith;
                withOrSet = new int[with.length];
                for (countWith = 0; countWith < with.length; ++countWith) {
                    if (with[countWith].toUpperCase().startsWith(member)) {
                        withOrSet[countWith] = 0;
                    }
                    if (!with[countWith].toUpperCase().startsWith(set)) continue;
                    withOrSet[countWith] = 1;
                    ++countSet;
                    ++setCounter;
                }
                if (setCounter != 0) {
                    withSet = new String[countSet];
                    tempSet = new StringBuffer[countSet];
                    setCalculatedMemberName = new String[countSet];
                    setCalculatedFormula = new String[countSet];
                    countSet = 0;
                    for (countWith = 0; countWith < with.length; ++countWith) {
                        if (withOrSet[countWith] != 1) continue;
                        withSet[countSet] = with[countWith].toString();
                        tempSet[countSet] = new StringBuffer(with[countWith].toString());
                        str = with[countWith].split(as);
                        setCalculatedMemberName[countSet] = str[0].replaceAll(set, "").trim();
                        setCalculatedMemberName[countSet] = setCalculatedMemberName[countSet].substring(1, setCalculatedMemberName[countSet].length() - 1);
                        setCalculatedFormula[countSet] = str[1].replaceAll("'", "").trim();
                        ++countSet;
                    }
                }
                calculatedFormula = new String[with.length];
                formatStringOnWith = new String[with.length];
                dimensionOnWith = new String[with.length];
                dimOnWith = new String[with.length];
                calculatedMemberName = new String[with.length];
                for (countWith = 0; countWith < with.length; ++countWith) {
                    if (with[countWith].toUpperCase().startsWith(member)) {
                        str = with[countWith].split(as);
                        str[0] = str[0].replaceAll(member, "").trim();
                        dimensionOnWith[countWith] = str[0].substring(0, str[0].indexOf(93) + 1);
                        dimOnWith[countWith] = dimensionOnWith[countWith].substring(1, dimensionOnWith[countWith].length() - 1);
                        calculatedMemberName[countWith] = str[0].substring(dimensionOnWith[countWith].length() + 1, str[0].length());
                        calculatedMemberName[countWith] = calculatedMemberName[countWith].substring(1, calculatedMemberName[countWith].length() - 1);
                        if (str[1].indexOf("FORMAT_STRING") == -1) {
                            calculatedFormula[countWith] = str[1].replaceAll("'", "").trim();
                        } else {
                            String[] temp = str[1].split("FORMAT_STRING");
                            calculatedFormula[countWith] = temp[0].replaceAll(",", "");
                            calculatedFormula[countWith] = calculatedFormula[countWith].replaceAll("'", "").trim();
                            formatStringOnWith[countWith] = "FORMAT_STRING" + temp[1].trim();
                        }
                    }
                    if (!with[countWith].startsWith(set)) continue;
                    str = with[countWith].split(as);
                    calculatedMemberName[countWith] = str[0].replaceAll(set, "").trim();
                    calculatedMemberName[countWith] = calculatedMemberName[countWith].substring(1, calculatedMemberName[countWith].length() - 1);
                    calculatedFormula[countWith] = str[1].replaceAll("'", "").trim();
                }
                if (setCounter != 0) {
                    setNode = new DefaultMutableTreeNode[withSet.length];
                    this.setNum = new int[withSet.length];
                }
            }
            if (columns != null) {
                dimOnColumns = new String[columns.length];
                for (count = 0; count < columns.length; ++count) {
                    str = columns[count].split("]");
                    dimOnColumns[count] = str[0].substring(1);
                }
            }
            if (rows != null) {
                dimOnRows = new String[rows.length];
                for (count = 0; count < rows.length; ++count) {
                    str = rows[count].split("]");
                    dimOnRows[count] = str[0].substring(1);
                }
            }
            if (pages != null) {
                dimOnPages = new String[pages.length];
                for (count = 0; count < pages.length; ++count) {
                    str = pages[count].split("]");
                    dimOnPages[count] = str[0].substring(1);
                }
            }
            if (where != null) {
                String[] str2 = where.split("]");
                dimOnWhere = str2[0].substring(2);
                where = where.substring(1, where.trim().length() - 1);
            }
            if (setCounter != 0) {
                for (int setCount = 0; setCount < tempSet.length; ++setCount) {
                    int count2;
                    if (columns != null) {
                        for (count2 = 0; count2 < columns.length; ++count2) {
                            if (tempSet[setCount] == null || tempSet[setCount].indexOf(columns[count2]) == -1) continue;
                            tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(columns[count2]), tempSet[setCount].indexOf(columns[count2]) + columns[count2].length(), "");
                            int n = setCount;
                            this.setNum[n] = this.setNum[n] + 1;
                        }
                    }
                    if (rows != null) {
                        for (count2 = 0; count2 < rows.length; ++count2) {
                            if (tempSet[setCount] == null || tempSet[setCount].indexOf(rows[count2]) == -1) continue;
                            tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(rows[count2]), tempSet[setCount].indexOf(rows[count2]) + rows[count2].length(), "");
                            int n = setCount;
                            this.setNum[n] = this.setNum[n] + 1;
                        }
                    }
                    if (pages != null) {
                        for (count2 = 0; count2 < pages.length; ++count2) {
                            if (tempSet[setCount] == null || tempSet[setCount].indexOf(pages[count2]) == -1) continue;
                            tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(pages[count2]), tempSet[setCount].indexOf(pages[count2]) + pages[count2].length(), "");
                            int n = setCount;
                            this.setNum[n] = this.setNum[n] + 1;
                        }
                    }
                    if (where == null || tempSet[setCount] == null || tempSet[setCount].indexOf(where) == -1) continue;
                    tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(where), tempSet[setCount].indexOf(where) + where.length(), "");
                    int n = setCount;
                    this.setNum[n] = this.setNum[n] + 1;
                }
            }
            if (setCounter != 0) {
                setArray = new String[this.setNum.length][];
                setDimension = new String[this.setNum.length][];
                setAxisCount = new int[this.setNum.length][];
                axisSetCount = new int[this.setNum.length][];
                for (int count3 = 0; count3 < setArray.length; ++count3) {
                    setArray[count3] = new String[this.setNum[count3]];
                    setDimension[count3] = new String[this.setNum[count3]];
                    setAxisCount[count3] = new int[4];
                    axisSetCount[count3] = new int[4];
                }
                countSet = 0;
                for (int countWith = 0; countWith < with.length; ++countWith) {
                    if (withOrSet[countWith] != 1) continue;
                    tempSet[countSet] = new StringBuffer(with[countWith].toString());
                    ++countSet;
                }
                for (int setCount = 0; setCount < tempSet.length; ++setCount) {
                    int count4;
                    int setElementCount = 0;
                    if (columns != null) {
                        for (count4 = 0; count4 < columns.length; ++count4) {
                            if (tempSet[setCount].indexOf(columns[count4]) != -1) {
                                tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(columns[count4]), tempSet[setCount].indexOf(columns[count4]) + columns[count4].length(), "");
                                setArray[setCount][setElementCount] = columns[count4];
                                setDimension[setCount][setElementCount] = dimOnColumns[count4];
                                columns[count4] = setCalculatedMemberName[setCount];
                                ++setElementCount;
                                int[] nArray = setAxisCount[setCount];
                                nArray[0] = nArray[0] + 1;
                            }
                            if (withSet[setCount].indexOf(columns[count4]) == -1) continue;
                            int[] nArray = axisSetCount[setCount];
                            nArray[0] = nArray[0] + 1;
                        }
                    }
                    if (rows != null) {
                        for (count4 = 0; count4 < rows.length; ++count4) {
                            if (tempSet[setCount].indexOf(rows[count4]) != -1) {
                                tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(rows[count4]), tempSet[setCount].indexOf(rows[count4]) + rows[count4].length(), "");
                                setArray[setCount][setElementCount] = rows[count4];
                                setDimension[setCount][setElementCount] = dimOnRows[count4];
                                rows[count4] = setCalculatedMemberName[setCount];
                                ++setElementCount;
                                int[] nArray = setAxisCount[setCount];
                                nArray[1] = nArray[1] + 1;
                            }
                            if (withSet[setCount].indexOf(rows[count4]) == -1) continue;
                            int[] nArray = axisSetCount[setCount];
                            nArray[1] = nArray[1] + 1;
                        }
                    }
                    if (pages != null) {
                        for (count4 = 0; count4 < pages.length; ++count4) {
                            if (tempSet[setCount].indexOf(pages[count4]) != -1) {
                                tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(pages[count4]), tempSet[setCount].indexOf(pages[count4]) + pages[count4].length(), "");
                                setArray[setCount][setElementCount] = pages[count4];
                                setDimension[setCount][setElementCount] = dimOnPages[count4];
                                pages[count4] = setCalculatedMemberName[setCount];
                                ++setElementCount;
                                int[] nArray = setAxisCount[setCount];
                                nArray[2] = nArray[2] + 1;
                            }
                            if (withSet[setCount].indexOf(pages[count4]) == -1) continue;
                            int[] nArray = axisSetCount[setCount];
                            nArray[2] = nArray[2] + 1;
                        }
                    }
                    if (where == null) continue;
                    if (tempSet[setCount].indexOf(where) != -1) {
                        tempSet[setCount] = tempSet[setCount].replace(tempSet[setCount].indexOf(where), tempSet[setCount].indexOf(where) + where.length(), "");
                        setArray[setCount][setElementCount] = where;
                        setDimension[setCount][setElementCount] = dimOnWhere;
                        where = setCalculatedMemberName[setCount];
                        ++setElementCount;
                        int[] nArray = setAxisCount[setCount];
                        nArray[3] = nArray[3] + 1;
                    }
                    if (withSet[setCount].indexOf(where) == -1) continue;
                    int[] nArray = axisSetCount[setCount];
                    nArray[3] = nArray[3] + 1;
                }
            }
            if (setCounter != 0) {
                for (int setCount = 0; setCount < setCalculatedMemberName.length; ++setCount) {
                    int count5;
                    int tempCount;
                    String[] tempForDimension;
                    String[] temp;
                    int noOfTimeSetInAxes;
                    if (axisSetCount[setCount][0] > 0) {
                        noOfTimeSetInAxes = axisSetCount[setCount][0] / setAxisCount[setCount][0];
                        temp = new String[columns.length - (setAxisCount[setCount][0] * noOfTimeSetInAxes - noOfTimeSetInAxes * 1)];
                        tempForDimension = new String[dimOnColumns.length - (setAxisCount[setCount][0] * noOfTimeSetInAxes - noOfTimeSetInAxes * 1)];
                        tempCount = 0;
                        for (count5 = 0; count5 < columns.length; ++count5) {
                            if (setCalculatedMemberName[setCount].indexOf(columns[count5]) != -1) {
                                temp[tempCount] = columns[count5 += setAxisCount[setCount][0] - 1];
                                tempForDimension[tempCount] = dimOnColumns[count5];
                            } else {
                                temp[tempCount] = columns[count5];
                                tempForDimension[tempCount] = dimOnColumns[count5];
                            }
                            ++tempCount;
                        }
                        columns = temp;
                        dimOnColumns = tempForDimension;
                    }
                    if (axisSetCount[setCount][1] > 0) {
                        noOfTimeSetInAxes = axisSetCount[setCount][1] / setAxisCount[setCount][1];
                        temp = new String[rows.length - (setAxisCount[setCount][1] * noOfTimeSetInAxes - noOfTimeSetInAxes * 1)];
                        tempForDimension = new String[dimOnRows.length - (setAxisCount[setCount][1] * noOfTimeSetInAxes - noOfTimeSetInAxes * 1)];
                        tempCount = 0;
                        for (count5 = 0; count5 < rows.length; ++count5) {
                            if (setCalculatedMemberName[setCount].indexOf(rows[count5]) != -1) {
                                temp[tempCount] = rows[count5 += setAxisCount[setCount][1] - 1];
                                tempForDimension[tempCount] = dimOnRows[count5];
                            } else {
                                temp[tempCount] = rows[count5];
                                tempForDimension[tempCount] = dimOnRows[count5];
                            }
                            ++tempCount;
                        }
                        rows = temp;
                        dimOnRows = tempForDimension;
                    }
                    if (axisSetCount[setCount][2] > 0) {
                        noOfTimeSetInAxes = axisSetCount[setCount][2] / setAxisCount[setCount][2];
                        temp = new String[pages.length - (setAxisCount[setCount][2] * noOfTimeSetInAxes - noOfTimeSetInAxes * 1)];
                        tempForDimension = new String[dimOnPages.length - (setAxisCount[setCount][2] * noOfTimeSetInAxes - noOfTimeSetInAxes * 1)];
                        tempCount = 0;
                        for (count5 = 0; count5 < pages.length; ++count5) {
                            if (setCalculatedMemberName[setCount].indexOf(pages[count5]) != -1) {
                                temp[tempCount] = pages[count5 += setAxisCount[setCount][2] - 1];
                                tempForDimension[tempCount] = dimOnPages[count5];
                            } else {
                                temp[tempCount] = pages[count5];
                                tempForDimension[tempCount] = dimOnPages[count5];
                            }
                            ++tempCount;
                        }
                        pages = temp;
                        dimOnPages = tempForDimension;
                    }
                    if (axisSetCount[setCount][3] > 0 && setCalculatedMemberName[setCount].indexOf(where) == -1) continue;
                }
            }
            if (setCounter != 0) {
                for (int setCount = 0; setCount < withSet.length; ++setCount) {
                    setNode[setCount] = ((MBTWithMembersNode)((MBTNode)withTreeNode.getUserObject())).handleSetDropFromQuery(withTreeNode, treeModel, setCalculatedMemberName[setCount]);
                }
            }
            for (childCount = 0; childCount < noOfDimension; ++childCount) {
                if (with.length == 0) continue;
                for (int countWith = 0; countWith < with.length; ++countWith) {
                    if (!with[countWith].startsWith(member) || !((Object)((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject())).toString().equalsIgnoreCase(dimOnWith[countWith].trim())) continue;
                    this.findWithMember((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject(), dimensionOnWith[countWith], calculatedMemberName[countWith], calculatedFormula[countWith], formatStringOnWith[countWith], withTreeNode, treeModel, children[0], bTree);
                }
            }
            for (childCount = 0; childCount < noOfDimension; ++childCount) {
                if (setCounter == 0) continue;
                for (int setCount = 0; setCount < setArray.length; ++setCount) {
                    for (int countSetElement = 0; countSetElement < setArray[setCount].length; ++countSetElement) {
                        if (!((Object)((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject())).toString().equalsIgnoreCase(setDimension[setCount][countSetElement].trim())) continue;
                        this.stopSearch = false;
                        this.findWithSet((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject(), setArray[setCount][countSetElement], bTree, treeModel, setNode[setCount], (MBTNode)setNode[setCount].getUserObject());
                    }
                }
            }
            for (childCount = 0; childCount < noOfDimension; ++childCount) {
                if (columns != null) {
                    for (int countCol = 0; countCol < columns.length; ++countCol) {
                        if (!((Object)((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject())).toString().equalsIgnoreCase(dimOnColumns[countCol].trim())) continue;
                        this.stopSearch = false;
                        this.find((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject(), columns[countCol].trim(), colTreeNode, treeModel, children[1], bTree, withTreeNode, setNode, setCalculatedMemberName);
                    }
                }
                if (rows != null) {
                    for (int countRow = 0; countRow < rows.length; ++countRow) {
                        if (!((Object)((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject())).toString().equalsIgnoreCase(dimOnRows[countRow].trim())) continue;
                        this.stopSearch = false;
                        this.find((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject(), rows[countRow].trim(), rowTreeNode, treeModel, children[2], bTree, withTreeNode, setNode, setCalculatedMemberName);
                    }
                }
                if (where == null || !((Object)((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject())).toString().equalsIgnoreCase(dimOnWhere.trim())) continue;
                this.stopSearch = false;
                this.find((DimensionTreeElement)dimTreeRootChild[childCount].getUserObject(), where.trim(), whereTreeNode, treeModel, children[5], bTree, withTreeNode, setNode, setCalculatedMemberName);
            }
            this.textArea.setText(this.builderTree.getMdx());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString());
        }
    }

    private void findWithMember(DimensionTreeElement element, String mdxElement, String calcMemberName, String withFormula, String formatStr, DefaultMutableTreeNode treeNode, DefaultTreeModel treeModel, MBTNode node, JTree bTree) {
        if (element.getUniqueName().trim().equalsIgnoreCase(mdxElement.trim())) {
            ((MBTWithMembersNode)node).handleMemberDropFromQuery(element, treeNode, treeModel, calcMemberName, withFormula, formatStr);
            ((DefaultTreeModel)bTree.getModel()).nodeChanged(treeNode);
            bTree.expandPath(new TreePath(treeNode.getPath()));
            bTree.repaint();
            this.stopSearch = true;
            return;
        }
    }

    private void findWithSet(DimensionTreeElement element, String mdxElement, JTree bTree, DefaultTreeModel treeModel, DefaultMutableTreeNode setNode, MBTNode node) {
        DimensionTreeElement[] dte = element.getChildren(true);
        for (int i = 0; dte != null && i < dte.length; ++i) {
            if (dte[i].getUniqueName().trim().equalsIgnoreCase(mdxElement.trim())) {
                node.handleDrop(dte[i], setNode, treeModel);
                ((DefaultTreeModel)bTree.getModel()).nodeChanged(setNode);
                bTree.expandPath(new TreePath(setNode.getPath()));
                bTree.repaint();
                this.stopSearch = true;
                return;
            }
            if (this.stopSearch) continue;
            this.findWithSet(dte[i], mdxElement, bTree, treeModel, setNode, node);
        }
    }

    private void find(DimensionTreeElement element, String mdxElement, DefaultMutableTreeNode treeNode, DefaultTreeModel treeModel, MBTNode node, JTree bTree, DefaultMutableTreeNode withNode, DefaultMutableTreeNode[] setNode, String[] set) {
        if (!this.stopSearch) {
            int kk;
            for (kk = 0; kk < withNode.getChildCount(); ++kk) {
                if (!((Object)((MBTNode)((DefaultMutableTreeNode)withNode.getChildAt(kk)).getUserObject())).toString().startsWith("MEMBER") || !((Object)((MBTNode)((DefaultMutableTreeNode)withNode.getChildAt(kk)).getUserObject())).toString().replaceAll("MEMBER", "").trim().equalsIgnoreCase(mdxElement.trim())) continue;
                node.handleDrop((MBTCalculatedMemberNode)((MBTNode)((DefaultMutableTreeNode)withNode.getChildAt(kk)).getUserObject()), treeNode, treeModel);
                ((DefaultTreeModel)bTree.getModel()).nodeChanged(treeNode);
                bTree.expandPath(new TreePath(treeNode.getPath()));
                bTree.repaint();
                this.stopSearch = true;
                return;
            }
            if (set != null) {
                for (kk = 0; kk < set.length; ++kk) {
                    if (!set[kk].trim().equalsIgnoreCase(mdxElement.trim())) continue;
                    node.handleDrop(setNode[kk].getUserObject(), treeNode, treeModel);
                    ((DefaultTreeModel)bTree.getModel()).nodeChanged(treeNode);
                    bTree.expandPath(new TreePath(treeNode.getPath()));
                    bTree.repaint();
                    this.stopSearch = true;
                    return;
                }
            }
        }
        DimensionTreeElement[] dte = element.getChildren(true);
        for (int i = 0; dte != null && i < dte.length; ++i) {
            if (dte[i].getUniqueName().trim().equalsIgnoreCase(mdxElement.trim())) {
                node.handleDrop(dte[i], treeNode, treeModel);
                ((DefaultTreeModel)bTree.getModel()).nodeChanged(treeNode);
                bTree.expandPath(new TreePath(treeNode.getPath()));
                bTree.repaint();
                this.stopSearch = true;
                return;
            }
            if (this.stopSearch) continue;
            this.find(dte[i], mdxElement, treeNode, treeModel, node, bTree, withNode, setNode, set);
        }
    }

    public String getDefaultQueryFileName() {
        int counter = 1;
        String parentDir = "";
        try {
            parentDir = ReadEnv.getEnvVars().getProperty("USERPROFILE");
        }
        catch (Exception exc) {
            // empty catch block
        }
        File file = new File(parentDir.concat("//query" + counter + ".mdx"));
        while (file.exists()) {
            file = new File(parentDir.concat("//query" + ++counter + ".mdx"));
        }
        return file.getAbsolutePath();
    }

    public String getFileName() {
        return this.lblFileName.getText();
    }

    public void setFileName(String fName) {
        this.lblFileName.setText(fName);
    }

    public String getTAContent() {
        return this.textArea.getText();
    }

    public void setTAContent(String fName) {
        this.textArea.setText(fName);
    }

    public void setLocale(Locale locale) {
        this.toolbar.setLocale(locale);
    }

    public Locale getLocale() {
        return this.toolbar.getLocale();
    }

    public static void main(String[] args) {
        String url = JOptionPane.showInputDialog("Please input an Foodmart 2000 service URL", (Object)"http://localhost:8080/xmla/msxisapi.dll");
        ServerMetadata svm = new ServerMetadata(url);
        XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
        restrictions.setCatalog("Foodmart 2000");
        restrictions.setCubeName("Sales");
        properties.setDataSourceInfo("Local Analysis Server");
        properties.setCatalog("Foodmart 2000");
        properties.setFormat("Tabular");
        properties.setContent("SchemaData");
        JFrame frame = new JFrame("Test mdx editor");
        frame.getContentPane().add((Component)new MdxEditor(restrictions, properties, svm, "Sales"), "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.mnuSaveJSP.setText(I18n.getString("menu.saveToJsp"));
        this.mnuCreateTree.setText(I18n.getString("menu.updateMBTree"));
        if (this.foregroundMenu instanceof ColorMenu) {
            this.foregroundMenu.setText(I18n.getString("menu.foregroundColor"));
            this.backgroundMenu.setText(I18n.getString("menu.backgroundColor"));
        }
        MdxEditorToolbar.resultPositions.put(MdxEditorToolbar.VERTICAL_SPLIT_PANE, I18n.getString("panel.vertSplit"));
        MdxEditorToolbar.resultPositions.put(MdxEditorToolbar.HORIZONTAL_SPLIT_PANE, I18n.getString("panel.horzSplit"));
        MdxEditorToolbar.resultPositions.put(MdxEditorToolbar.TABBED_PANE_UP, I18n.getString("panel.tabUp"));
        MdxEditorToolbar.resultPositions.put(MdxEditorToolbar.TABBED_PANE_LEFT, I18n.getString("panel.tabLeft"));
        MdxEditorToolbar.resultPositions.put(MdxEditorToolbar.TABBED_PANE_RIGHT, I18n.getString("panel.tabRight"));
        MdxEditorToolbar.resultPositions.put(MdxEditorToolbar.TABBED_PANE_BOTTOM, I18n.getString("panel.tabBottom"));
    }

    static {
        keywords = new HashMap();
        keywords.put("SELECT", "SELECT");
        keywords.put("FROM", "FROM");
        keywords.put("WHERE", "WHERE");
        keywords.put("NON", "NON");
        keywords.put("EMPTY", "EMPTY");
        keywords.put("COLUMNS", "COLUMNS");
        keywords.put("ROWS", "ROWS");
        keywords.put("PAGES", "PAGES");
        keywords.put("ON", "ON");
        keywords.put("WITH", "WITH");
        keywords.put("MEMBER", "MEMBER");
        keywords.put("AS", "AS");
        keywords.put("SETTOARRAY", "SetToArray");
        keywords.put("DIMENSION", "Dimension");
        keywords.put("DIMENSIONS", "Dimensions");
        keywords.put("HIERARCHY", "Hierarchy");
        keywords.put("LEVEL", "Level");
        keywords.put("LEVELS", "Levels");
        keywords.put("IS", "Is");
        keywords.put("ISANCESTOR", "IsAncestor");
        keywords.put("ISEMPTY", "IsEmpty");
        keywords.put("ISGENERATION", "IsGeneration");
        keywords.put("ISLEAF", "IsLeaf");
        keywords.put("ISSIBLING", "IsSibling");
        keywords.put("ANCESTOR", "Ancestor");
        keywords.put("CLOSINGPERIOD", "ClosingPeriod");
        keywords.put("COUSIN", "Cousin");
        keywords.put("CURRENTMEMBER", "CurrentMember");
        keywords.put("DATAMEMBER", "DataMember");
        keywords.put("DEFAULTMEMBER", "DefaultMember");
        keywords.put("FIRSTCHILD", "FirstChild");
        keywords.put("FIRSTSIBLING", "FirstSibling");
        keywords.put("ITEM", "Item");
        keywords.put("LAG", "Lag");
        keywords.put("LASTCHILD", "LastChild");
        keywords.put("LASTSIBLING", "LastSibling");
        keywords.put("LEAD", "Lead");
        keywords.put("LINKMEMBER", "LinkMember");
        keywords.put("MEMBERS", "Members");
        keywords.put("NEXTMEMBER", "NextMember");
        keywords.put("OPENINGPERIOD", "OpeningPeriod");
        keywords.put("PARALLELPERIOD", "ParallelPeriod");
        keywords.put("PARENT", "Parent");
        keywords.put("PREVMEMBER", "PrevMember");
        keywords.put("STRTOMEMBER", "StrToMember");
        keywords.put("VALIDMEASURE", "ValidMeasure");
        keywords.put("AGGREGATE", "Aggregate");
        keywords.put("AVG", "Avg");
        keywords.put("CALCULATIONCURRENTPASS", "CalculationCurrentPass");
        keywords.put("CALCULATIONPASSVALUE", "CalculationPassValue");
        keywords.put("COALESCEEMPTY", "CoalesceEmpty");
        keywords.put("CORRELATION", "Correlation");
        keywords.put("COUNT", "Count");
        keywords.put("COVARIANCE", "Covariance");
        keywords.put("COVARIANCEN", "CovarianceN");
        keywords.put("DISTINCTCOUNT", "DistinctCount");
        keywords.put("IIF", "IIf");
        keywords.put("LINREGINTERCEPT", "LinRegIntercept");
        keywords.put("LINREGPOINT", "LinRegPoint");
        keywords.put("LINREGR2", "LinRegR2");
        keywords.put("LINREGSLOPE", "LinRegSlope");
        keywords.put("LINREGVARIANCE", "LinRegVariance");
        keywords.put("LOOKUPCUBE", "LookupCube");
        keywords.put("MAX", "Max");
        keywords.put("MEDIAN", "Median");
        keywords.put("MIN", "Min");
        keywords.put("ORDINAL", "Ordinal");
        keywords.put("PREDICT", "Predict");
        keywords.put("RANK", "Rank");
        keywords.put("ROLLUPCHILDREN", "RollupChildren");
        keywords.put("STDDEV", "Stddev");
        keywords.put("STDDEVP", "StddevP");
        keywords.put("STDEV", "Stdev");
        keywords.put("STDEVP", "StdevP");
        keywords.put("STRTOVALUE", "StrToValue");
        keywords.put("SUM", "Sum");
        keywords.put("VALUE", "Value");
        keywords.put("VAR", "Var");
        keywords.put("VARIANCE", "Variance");
        keywords.put("VARIANCEP", "VarianceP");
        keywords.put("VARP", "VarP");
        keywords.put("CALL", "Call");
        keywords.put("ADDCALCULATEDMEMBERS", "AddCalculatedMembers");
        keywords.put("ALLMEMBERS", "AllMembers");
        keywords.put("ANCESTORS", "Ancestors");
        keywords.put("ASCENDANTS", "Ascendants");
        keywords.put("AXIS", "Axis");
        keywords.put("BOTTOMCOUNT", "BottomCount");
        keywords.put("BOTTOMPERCENT", "BottomPercent");
        keywords.put("BOTTOMSUM", "BottomSum");
        keywords.put("CHILDREN", "Children");
        keywords.put("CROSSJOIN", "Crossjoin");
        keywords.put("DESCENDANTS", "Descendants");
        keywords.put("DISTINCT", "Distinct");
        keywords.put("DRILLDOWNLEVEL", "DrilldownLevel");
        keywords.put("DRILLDOWNLEVELBOTTOM", "DrilldownLevelBottom");
        keywords.put("DRILLDOWNLEVELTOP", "DrilldownLevelTop");
        keywords.put("DRILLDOWNMEMBER", "DrilldownMember");
        keywords.put("DRILLDOWNMEMBERBOTTOM", "DrilldownMemberBottom");
        keywords.put("DRILLDOWNMEMBERTOP", "DrilldownMemberTop");
        keywords.put("DRILLUPLEVEL", "DrillupLevel");
        keywords.put("DRILLUPMEMBER", "DrillupMember");
        keywords.put("EXCEPT", "Except");
        keywords.put("EXTRACT", "Extract");
        keywords.put("FILTER", "Filter");
        keywords.put("GENERATE", "Generate");
        keywords.put("HEAD", "Head");
        keywords.put("HIERARCHIZE", "Hierarchize");
        keywords.put("INTERSECT", "Intersect");
        keywords.put("LASTPERIODS", "LastPeriods");
        keywords.put("MEMBERS", "Members");
        keywords.put("MTD", "Mtd");
        keywords.put("NAMETOSET", "NameToSet");
        keywords.put("NONEMPTYCROSSJOIN", "NonEmptyCrossjoin");
        keywords.put("ORDER", "Order");
        keywords.put("PERIODSTODATE", "PeriodsToDate");
        keywords.put("QTD", "Qtd");
        keywords.put("SIBLINGS", "Siblings");
        keywords.put("STRIPCALCULATEDMEMBERS", "StripCalculatedMembers");
        keywords.put("STRTOSET", "StrToSet");
        keywords.put("SUBSET", "Subset");
        keywords.put("TAIL", "Tail");
        keywords.put("TOGGLEDRILLSTATE", "ToggleDrillState");
        keywords.put("TOPCOUNT", "TopCount");
        keywords.put("TOPPERCENT", "TopPercent");
        keywords.put("TOPSUM", "TopSum");
        keywords.put("UNION", "Union");
        keywords.put("VISUALTOTALS", "VisualTotals");
        keywords.put("WTD", "Wtd");
        keywords.put("YTD", "Ytd");
        keywords.put("CALCULATIONPASSVALUE", "CalculationPassValue");
        keywords.put("COALESCEEMPTY", "CoalesceEmpty");
        keywords.put("GENERATE", "Generate");
        keywords.put("IIF", "IIf");
        keywords.put("LOOKUPCUBE", "LookupCube");
        keywords.put("MEMBERTOSTR", "MemberToStr");
        keywords.put("NAME", "Name");
        keywords.put("PROPERTIES", "Properties");
        keywords.put("SETTOSTR", "SetToStr");
        keywords.put("TUPLETOSTR", "TupleToStr");
        keywords.put("UNIQUENAME", "UniqueName");
        keywords.put("USERNAME", "UserName");
        keywords.put("CURRENT", "Current");
        keywords.put("ITEM", "Item");
        keywords.put("STRTOTUPLE", "StrToTuple");
    }

    class TextAreaKeyListener
    extends KeyAdapter {
        TextAreaKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (!(e.isControlDown() || e.isShiftDown() || e.isAltDown())) {
                if (e.getKeyCode() != 38) {
                    if (e.getKeyCode() != 40) {
                        if (e.getKeyCode() != 39) {
                            if (e.getKeyCode() != 37) {
                                if (e.getKeyCode() != 144) {
                                    if (e.getKeyCode() != 27) {
                                        if (e.getKeyCode() != 20) {
                                            MdxEditor.this.toolbar.setSave(false);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (e.isControlDown() && e.isShiftDown() && e.getKeyCode() == 10) {
                MdxEditor.this.runAllQuery();
            } else if (e.isControlDown() && e.getKeyCode() == 10) {
                MdxEditor.this.runSelectedQuery();
            }
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10 || e.getKeyCode() == 9 || e.getKeyCode() == 44 || e.getKeyCode() == 39 || e.getKeyCode() == 37 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                int start;
                for (start = MdxEditor.this.textArea.getCaretPosition() - 1; start > 0; --start) {
                    char ch = MdxEditor.this.textArea.getText().charAt(start);
                    if (ch != ' ' && ch != '\n' && ch != '\t') continue;
                    ++start;
                    break;
                }
                if (start >= 0 && keywords.get(MdxEditor.this.textArea.getText().substring(start, MdxEditor.this.textArea.getCaretPosition()).toUpperCase()) != null) {
                    MdxEditor.this.textArea.replaceRange((String)keywords.get(MdxEditor.this.textArea.getText().substring(start, MdxEditor.this.textArea.getCaretPosition()).toUpperCase()), start, MdxEditor.this.textArea.getCaretPosition());
                }
            }
            if (!e.isControlDown() || e.getKeyCode() == 86) {
                // empty if block
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    class CreateTree
    implements ActionListener {
        CreateTree() {
        }

        public void actionPerformed(ActionEvent e) {
            MdxEditor.this.parseQuery();
        }
    }

    class SegregateMDXWithNWhere {
        private String[] with;
        private String where;

        public SegregateMDXWithNWhere(String mdx) {
            mdx = mdx.replaceAll("\r", "");
            try {
                StringReader reader = new StringReader(mdx);
                parser parser_obj = new parser(new Lexer(reader));
                Symbol parse_tree = null;
                ParsedQuery pQuery = null;
                parse_tree = parser_obj.parse();
                pQuery = (ParsedQuery)parse_tree.value;
                pQuery.afterParse();
                Formula[] formula = pQuery.getFormulas();
                Exp slicer = pQuery.getSlicer();
                this.with = new String[formula.length];
                for (int i = 0; i < formula.length; ++i) {
                    this.with[i] = formula[i].toMdx().trim();
                }
                this.where = slicer.toMdx();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }

        public String[] getFormulas() {
            return this.with;
        }

        public String getSlicer() {
            return this.where;
        }
    }

    class SaveJSP
    implements ActionListener {
        SaveJSP() {
        }

        public void actionPerformed(ActionEvent e) {
            new SaveJSPListener(MdxEditor.this.textArea.getText(), MdxEditor.this.properties.getDataSourceInfo(), MdxEditor.this.properties.getCatalog());
        }
    }

    class BackgroundListener
    implements ActionListener {
        BackgroundListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorMenu m = (ColorMenu)e.getSource();
            MdxEditor.this.setBackgroundColor(m.getColor());
        }
    }

    class ForegroundListener
    implements ActionListener {
        ForegroundListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorMenu m = (ColorMenu)e.getSource();
            MdxEditor.this.setForegroundColor(m.getColor());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MdxEditor.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

