/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;

class DrilldownMemberFunDef
extends FunDefBase {
    static final String[] reservedWords = new String[]{"RECURSIVE"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("DrilldownMember", "DrilldownMember(<Set1>, <Set2>[, RECURSIVE])", "Drills down the members in a set that are present in a second specified set.", new String[]{"fxxx", "fxxxy"}, DrilldownMemberFunDef.class, reservedWords);

    public DrilldownMemberFunDef(FunDef funDef) {
        super(funDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        String literalArg = DrilldownMemberFunDef.getLiteralArg(call, 2, "", reservedWords);
        final boolean recursive = literalArg.equals("RECURSIVE");
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            public List evaluateList(Evaluator evaluator) {
                List list1 = listCalc1.evaluateList(evaluator);
                List list2 = listCalc2.evaluateList(evaluator);
                return this.drilldownMember(list1, list2, evaluator);
            }

            protected void drillDownObj(Evaluator evaluator, Object element, Set memberSet, List resultList) {
                int j;
                if (null == element) {
                    return;
                }
                Member m = null;
                int k = -1;
                if (element instanceof Member) {
                    if (!memberSet.contains(element)) {
                        return;
                    }
                    m = (Member)element;
                } else {
                    Util.assertTrue(element instanceof Member[]);
                    Member[] members = (Member[])element;
                    for (j = 0; j < members.length; ++j) {
                        Member member = members[j];
                        if (!memberSet.contains(member)) continue;
                        k = j;
                        m = member;
                        break;
                    }
                    if (k == -1) {
                        return;
                    }
                }
                Member[] children = evaluator.getSchemaReader().getMemberChildren(m);
                for (j = 0; j < children.length; ++j) {
                    Member[] objNew;
                    if (k < 0) {
                        objNew = children[j];
                    } else {
                        Member[] members = (Member[])((Member[])element).clone();
                        members[k] = children[j];
                        objNew = members;
                    }
                    resultList.add(objNew);
                    if (!recursive) continue;
                    this.drillDownObj(evaluator, objNew, memberSet, resultList);
                }
            }

            private List drilldownMember(List v0, List v1, Evaluator evaluator) {
                if (null == v0 || v0.isEmpty() || null == v1 || v1.isEmpty()) {
                    return v0;
                }
                HashSet set1 = new HashSet();
                set1.addAll(v1);
                ArrayList result = new ArrayList();
                int i = 0;
                int n = v0.size();
                while (i < n) {
                    Object o = v0.get(i++);
                    result.add(o);
                    this.drillDownObj(evaluator, o, set1, result);
                }
                return result;
            }
        };
    }
}

