/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.wizards.TemplateWizardPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class TemplateVisualPanel
extends JPanel {
    private TemplateWizardPanel panel = null;
    private ButtonGroup buttonGroup1;
    private JLabel jLabelPreview;
    private JList jList1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;

    public TemplateVisualPanel(TemplateWizardPanel panel) {
        this.panel = panel;
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new FieldListCellRenderer());
        this.updateTemplates();
    }

    public String getName() {
        return I18n.getString("TemplateVisualPanel.Name.Layout");
    }

    private void updateTemplates() {
        this.loadTemplates(this.getReportType());
    }

    private void loadTemplates(String type) {
        this.jLabelPreview.setIcon(null);
        ((DefaultListModel)this.jList1.getModel()).clear();
        FileObject templatesFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("ireport/templates/" + type);
        if (templatesFileObject == null) {
            return;
        }
        DataFolder templatesDataFolder = DataFolder.findFolder((FileObject)templatesFileObject);
        if (templatesDataFolder == null) {
            return;
        }
        Enumeration enObj = templatesDataFolder.children();
        while (enObj.hasMoreElements()) {
            DataObject dataObject = (DataObject)enObj.nextElement();
            if (dataObject.getPrimaryFile().getExt() != null && dataObject.getPrimaryFile().getExt().length() != 0) continue;
            ((DefaultListModel)this.jList1.getModel()).addElement(dataObject);
        }
        if (((DefaultListModel)this.jList1.getModel()).getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabelPreview = new JLabel();
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)I18n.getString("TemplateVisualPanel.RadioButton.ColLayout"));
        this.jRadioButton1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TemplateVisualPanel.this.jRadioButton1StateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 4, 0, 4);
        this.add((Component)this.jRadioButton1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)I18n.getString("TemplateVisualPanel.RadioButton.TabLayout"));
        this.jRadioButton2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TemplateVisualPanel.this.jRadioButton2StateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.jRadioButton2, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 120));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TemplateVisualPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelPreview.setHorizontalAlignment(2);
        this.jLabelPreview.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 4, 4);
        this.add((Component)this.jLabelPreview, gridBagConstraints);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        FileObject previewFileObject;
        DataObject dataObject;
        this.jLabelPreview.setIcon(null);
        if (this.jList1.getSelectedIndex() >= 0 && (dataObject = (DataObject)this.jList1.getSelectedValue()).getPrimaryFile().existsExt(I18n.getString("TemplateVisualPanel.List.Preview")) && (previewFileObject = dataObject.getFolder().getPrimaryFile().getFileObject(dataObject.getName(), I18n.getString("TemplateVisualPanel.List.Preview"))) != null) {
            try {
                ImageIcon img = new ImageIcon(previewFileObject.getURL());
                this.jLabelPreview.setIcon(img);
                this.jLabelPreview.updateUI();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void jRadioButton1StateChanged(ChangeEvent evt) {
        this.updateTemplates();
    }

    private void jRadioButton2StateChanged(ChangeEvent evt) {
        this.updateTemplates();
    }

    public String getReportType() {
        return this.jRadioButton1.isSelected() ? I18n.getString("TemplateVisualPanel.RadioButton.columnar") : I18n.getString("TemplateVisualPanel.RadioButton.tabular");
    }

    public FileObject getReportTemplate() {
        DataObject dataObject = (DataObject)this.jList1.getSelectedValue();
        return dataObject.getPrimaryFile();
    }

    static class FieldListCellRenderer
    extends DefaultListCellRenderer {
        FieldListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DataObject) {
                value = ((DataObject)value).getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

