/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.ByteProperty;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignImage;

public final class ScaleImageProperty
extends ByteProperty {
    private final JRDesignImage image;

    public ScaleImageProperty(JRDesignImage image) {
        super(image);
        this.image = image;
    }

    public String getName() {
        return "scaleImage";
    }

    public String getDisplayName() {
        return "Scale Image";
    }

    public String getShortDescription() {
        return "How to scale the image.";
    }

    public List getTagList() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(new Byte(1), "Clip"));
        tags.add(new Tag(new Byte(2), "Fill Frame"));
        tags.add(new Tag(new Byte(3), "Retain Shape"));
        return tags;
    }

    public Byte getByte() {
        return this.image.getScaleImage();
    }

    public Byte getOwnByte() {
        return this.image.getOwnScaleImage();
    }

    public Byte getDefaultByte() {
        return null;
    }

    public void setByte(Byte scaleImage) {
        this.image.setScaleImage(scaleImage);
    }
}

