/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.widgets.BandSeparatorWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.PageWidget;
import java.awt.Point;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.widget.Widget;

public class BandMoveProvider
implements MoveProvider {
    int startY = 0;
    boolean reversOrder = false;

    public BandMoveProvider() {
        this(false);
    }

    public BandMoveProvider(boolean reversOrder) {
        this.reversOrder = reversOrder;
    }

    public void movementStarted(Widget w) {
        this.startY = w.getPreferredLocation().y;
        w.setForeground(ReportObjectScene.EDITING_DESIGN_LINE_COLOR);
    }

    public void movementFinished(Widget w) {
        w.setForeground(ReportObjectScene.DESIGN_LINE_COLOR);
        ReportObjectScene scene = (ReportObjectScene)w.getScene();
        JRBand b = ((BandSeparatorWidget)w).getBand();
        if (!this.reversOrder && b.getHeight() == 0) {
            List<JRBand> bands = ModelUtils.getBands(scene.getJasperDesign());
            JRBand rightBand = bands.get(0);
            for (JRBand tmpBand : bands) {
                if (tmpBand == b) break;
                if (tmpBand.getHeight() == 0) continue;
                rightBand = tmpBand;
            }
            b = rightBand;
        }
        int delta = w.getPreferredLocation().y - this.startY;
        int originalHight = b.getHeight();
        int newValue = b.getHeight() + delta;
        ((JRDesignBand)b).setHeight(newValue);
        ObjectPropertyUndoableEdit edit = new ObjectPropertyUndoableEdit(b, "Height", Integer.TYPE, originalHight, newValue);
        IReportManager.getInstance().addUndoableEdit(edit);
        ((PageWidget)((Object)scene.getPageLayer().getChildren().get(0))).updateBounds();
        List list = scene.getBandSeparatorsLayer().getChildren();
        for (Widget separatorWidget : list) {
            ((BandSeparatorWidget)separatorWidget).updateBounds();
        }
        list = scene.getElementsLayer().getChildren();
        for (Widget elementWidget : list) {
            ((JRDesignElementWidget)elementWidget).updateBounds();
            ((JRDesignElementWidget)elementWidget).getSelectionWidget().updateBounds();
        }
        ((ReportObjectScene)w.getScene()).validate();
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point newLocation) {
        widget.setPreferredLocation(newLocation);
    }
}

