/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.UninstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UnitTab
extends JPanel {
    private UnitTable table = null;
    private UnitDetails details = null;
    private UnitCategoryTableModel model = null;
    private DocumentListener dlForSearch;
    private FocusListener flForSearch;
    private String filter = "";
    private PluginManagerUI manager = null;
    private PopupActionSupport popupActionsSupport;
    private RowTabAction activateAction;
    private RowTabAction deactivateAction;
    private TabAction reloadAction;
    private RowTabAction moreAction;
    private RowTabAction lessAction;
    private RowTabAction removeLocallyDownloaded;
    private static final RequestProcessor RP = new RequestProcessor();
    private final RequestProcessor.Task searchTask = RP.create(new Runnable(){

        public void run() {
            if (UnitTab.this.filter != null) {
                int n = UnitTab.this.getSelectedRow();
                final Unit unit = n >= 0 ? UnitTab.this.getModel().getUnitAtRow(n) : null;
                final Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (unit != null) {
                            int n = UnitTab.this.findRow(unit.updateUnit.getCodeName());
                            UnitTab.this.restoreSelectedRow(n);
                        }
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                        UnitTab.this.refreshState();
                    }
                };
                UnitTab.this.model.setFilter(UnitTab.this.filter, runnable);
            }
        }
    });
    private final Logger log = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitTab");
    private JButton bTabAction;
    private JLabel lSearch;
    private JLabel lSelectionInfo;
    private JLabel lWarning;
    private JSplitPane spTab;
    private JTextField tfSearch;
    private JButton topButton;

    public UnitTab(UnitTable unitTable, UnitDetails unitDetails, PluginManagerUI pluginManagerUI) {
        this.table = unitTable;
        this.details = unitDetails;
        this.manager = pluginManagerUI;
        TableModel tableModel = unitTable.getModel();
        assert (tableModel instanceof UnitCategoryTableModel) : tableModel + " instanceof UnitCategoryTableModel.";
        this.model = (UnitCategoryTableModel)tableModel;
        unitTable.getSelectionModel().setSelectionMode(0);
        this.initComponents();
        this.spTab.setLeftComponent(new JScrollPane(unitTable));
        this.spTab.setRightComponent(new JScrollPane(unitDetails, 20, 30));
        this.initTab();
        this.listenOnSelection();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                super.componentShown(componentEvent);
                UnitTab.this.focusTable();
            }
        });
        this.addUpdateUnitListener(new UpdateUnitListener(){

            public void updateUnitsChanged() {
                UnitTab.this.manager.updateUnitsChanged();
            }

            public void buttonsChanged() {
                UnitTab.this.manager.buttonsChanged();
            }

            public void filterChanged() {
                UnitTab.this.model.fireTableDataChanged();
                UnitTab.this.manager.decorateTabTitle(UnitTab.this.table);
                UnitTab.this.refreshState();
            }
        });
    }

    void focusTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UnitTab.this.table.requestFocusInWindow();
            }
        });
    }

    UnitCategoryTableModel getModel() {
        return this.model;
    }

    UnitTable getTable() {
        return this.table;
    }

    public String getHelpId() {
        return UnitTab.class.getName() + '.' + (Object)((Object)this.model.getType());
    }

    void setWaitingState(boolean bl) {
        boolean bl2 = !bl;
        Component[] componentArray = this.getComponents();
        for (Component component : componentArray) {
            if (component == this.bTabAction) {
                if (bl2) {
                    component.setEnabled(this.model.getMarkedUnits().size() > 0);
                    continue;
                }
                component.setEnabled(bl2);
                continue;
            }
            if (component == this.spTab) {
                this.spTab.getLeftComponent().setEnabled(bl2);
                this.spTab.getRightComponent().setEnabled(bl2);
                this.details.setEnabled(bl2);
                this.table.setEnabled(bl2);
                continue;
            }
            component.setEnabled(bl2);
        }
        if (this.reloadAction != null) {
            this.reloadAction.setEnabled(bl2);
        }
        Container container = this.getParent();
        JRootPane jRootPane = this.getRootPane();
        if (container != null) {
            container.setEnabled(bl2);
        }
        if (jRootPane != null) {
            if (bl2) {
                jRootPane.setCursor(null);
            } else {
                jRootPane.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        this.focusTable();
    }

    private void prepareTopButton(Action action) {
        JButton jButton = this.topButton;
        jButton.setToolTipText((String)action.getValue("ToolTipText"));
        jButton.setAction(action);
    }

    public void addNotify() {
        super.addNotify();
        if (this.dlForSearch == null) {
            this.tfSearch.getDocument().addDocumentListener(this.getDocumentListener());
        }
        if (this.flForSearch == null) {
            this.flForSearch = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    UnitTab.this.tfSearch.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    UnitTab.this.tfSearch.select(0, 0);
                }
            };
            this.tfSearch.addFocusListener(this.flForSearch);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.dlForSearch != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.getDocumentListener());
        }
        this.dlForSearch = null;
        if (this.flForSearch != null) {
            this.tfSearch.removeFocusListener(this.flForSearch);
        }
        this.flForSearch = null;
    }

    public void refreshState() {
        Collection<Unit> collection = this.model.getMarkedUnits();
        int n = this.model.getDownloadSize();
        this.popupActionsSupport.tableDataChanged();
        if (collection.size() == 0) {
            this.cleanSelectionInfo();
        } else {
            this.setSelectionInfo(Utilities.getDownloadSizeAsString(n), collection.size());
        }
        this.getDefaultAction().setEnabled(collection.size() > 0);
    }

    private TabAction getDefaultAction() {
        return (TabAction)this.bTabAction.getAction();
    }

    private void initTab() {
        TabAction[] tabActionArray = null;
        switch (this.model.getType()) {
            case INSTALLED: {
                CheckCategoryAction checkCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction uncheckCategoryAction = new UncheckCategoryAction();
                CheckAllAction checkAllAction = new CheckAllAction();
                UncheckAllAction uncheckAllAction = new UncheckAllAction();
                ActivateCategoryAction activateCategoryAction = new ActivateCategoryAction();
                DeactivateCategoryAction deactivateCategoryAction = new DeactivateCategoryAction();
                this.activateAction = new ActivateAction();
                this.deactivateAction = new DeactivateAction();
                tabActionArray = new TabAction[]{this.activateAction, this.deactivateAction, activateCategoryAction, deactivateCategoryAction, checkCategoryAction, uncheckCategoryAction, checkAllAction, uncheckAllAction, new CheckAction()};
                this.bTabAction.setAction(new UninstallAction());
                this.reloadAction = new ReloadAction();
                this.prepareTopButton(this.reloadAction);
                this.table.setEnableRenderer(new EnableRenderer());
                break;
            }
            case UPDATE: {
                CheckCategoryAction checkCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction uncheckCategoryAction = new UncheckCategoryAction();
                CheckAllAction checkAllAction = new CheckAllAction();
                UncheckAllAction uncheckAllAction = new UncheckAllAction();
                this.moreAction = new MoreAction();
                this.lessAction = new LessAction();
                tabActionArray = new TabAction[]{checkCategoryAction, uncheckCategoryAction, checkAllAction, uncheckAllAction, new CheckAction(), this.moreAction, this.lessAction};
                this.bTabAction.setAction(new UpdateAction());
                this.reloadAction = new ReloadAction();
                this.prepareTopButton(this.reloadAction);
                break;
            }
            case AVAILABLE: {
                CheckCategoryAction checkCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction uncheckCategoryAction = new UncheckCategoryAction();
                CheckAllAction checkAllAction = new CheckAllAction();
                UncheckAllAction uncheckAllAction = new UncheckAllAction();
                this.moreAction = new MoreAction();
                this.lessAction = new LessAction();
                tabActionArray = new TabAction[]{checkCategoryAction, uncheckCategoryAction, checkAllAction, uncheckAllAction, new CheckAction(), this.moreAction, this.lessAction};
                this.bTabAction.setAction(new AvailableAction());
                this.reloadAction = new ReloadAction();
                this.prepareTopButton(this.reloadAction);
                this.table.setEnableRenderer(new SourceCategoryRenderer());
                break;
            }
            case LOCAL: {
                this.removeLocallyDownloaded = new RemoveLocallyDownloadedAction();
                tabActionArray = new TabAction[]{this.removeLocallyDownloaded, new CheckAction()};
                this.bTabAction.setAction(new LocalUpdateAction());
                this.prepareTopButton(new AddLocallyDownloadedAction());
            }
        }
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                UnitTab.this.refreshState();
            }
        });
        this.popupActionsSupport = new PopupActionSupport(tabActionArray);
        this.table.addMouseListener(this.popupActionsSupport);
        this.getDefaultAction().setEnabled(this.model.getMarkedUnits().size() > 0);
    }

    private void cleanSelectionInfo() {
        this.lSelectionInfo.setText("");
        this.lWarning.setText("");
        this.lWarning.setIcon(null);
    }

    private void setSelectionInfo(String string, int n) {
        String string2;
        String string3 = null;
        switch (this.model.getType()) {
            case INSTALLED: {
                string3 = "UnitTab_OperationName_Text_INSTALLED";
                break;
            }
            case UPDATE: {
                string3 = "UnitTab_OperationName_Text_UPDATE";
                break;
            }
            case AVAILABLE: {
                string3 = "UnitTab_OperationName_Text_AVAILABLE";
                break;
            }
            case LOCAL: {
                string3 = "UnitTab_OperationName_Text_LOCAL";
            }
        }
        String string4 = string2 = n == 1 ? "UnitTab_lHowManySelected_Single_Text" : "UnitTab_lHowManySelected_Many_Text";
        if (UnitCategoryTableModel.Type.INSTALLED == this.model.getType() || UnitCategoryTableModel.Type.LOCAL == this.model.getType()) {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)string2, (Object)n));
        } else {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lHowManySelected_TextFormatWithSize", (Object)NbBundle.getMessage(UnitTab.class, (String)string2, (Object)n), (Object)string));
        }
        if (this.model.needsRestart()) {
            ImageIcon imageIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/warning.gif"));
            this.lWarning.setIcon(imageIcon);
            this.lWarning.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lWarning_Text", (Object)NbBundle.getMessage(UnitTab.class, (String)string3)));
        }
    }

    private void showDetailsAtRow(int n) {
        this.showDetailsAtRow(n, null);
    }

    private void showDetailsAtRow(int n, Action action) {
        if (n == -1) {
            this.details.setUnit(null);
        } else {
            Unit unit;
            Unit unit2 = unit = this.model.isExpansionControlAtRow(n) ? null : this.model.getUnitAtRow(n);
            if (unit != null) {
                this.details.setUnit(unit, action);
            }
        }
    }

    private void listenOnSelection() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    UnitTab.this.showDetailsAtRow(-1);
                    UnitTab.this.popupActionsSupport.rowChanged(-1);
                } else {
                    int n = listSelectionModel.getMinSelectionIndex();
                    UnitTab.this.popupActionsSupport.rowChanged(n);
                    RowTabAction rowTabAction = null;
                    if (UnitTab.this.activateAction != null && UnitTab.this.activateAction.isEnabled()) {
                        rowTabAction = UnitTab.this.activateAction;
                    } else if (UnitTab.this.deactivateAction != null && UnitTab.this.deactivateAction.isEnabled()) {
                        rowTabAction = UnitTab.this.deactivateAction;
                    } else if (UnitTab.this.removeLocallyDownloaded != null && UnitTab.this.removeLocallyDownloaded.isEnabled()) {
                        rowTabAction = UnitTab.this.removeLocallyDownloaded;
                    }
                    UnitTab.this.showDetailsAtRow(n, rowTabAction);
                }
            }
        });
    }

    public void addUpdateUnitListener(UpdateUnitListener updateUnitListener) {
        this.model.addUpdateUnitListener(updateUnitListener);
    }

    public void removeUpdateUnitListener(UpdateUnitListener updateUnitListener) {
        this.model.removeUpdateUnitListener(updateUnitListener);
    }

    void fireUpdataUnitChange() {
        this.model.fireUpdataUnitChange();
    }

    DocumentListener getDocumentListener() {
        if (this.dlForSearch == null) {
            this.dlForSearch = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    UnitTab.this.filter = UnitTab.this.tfSearch.getText().trim();
                    UnitTab.this.searchTask.schedule(350);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            };
        }
        return this.dlForSearch;
    }

    private void initComponents() {
        this.lSelectionInfo = new JLabel();
        this.bTabAction = new JButton();
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.spTab = new JSplitPane();
        this.topButton = new JButton();
        this.lWarning = new JLabel();
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(UnitTab.class, (String)"lSearch1.text"));
        this.spTab.setBorder(null);
        this.spTab.setDividerLocation(370);
        this.spTab.setResizeWeight(0.5);
        this.spTab.setOneTouchExpandable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.topButton, (String)"jButton1");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.topButton).addPreferredGap(0, 453, Short.MAX_VALUE).add((Component)this.lSearch).add(4, 4, 4).add((Component)this.tfSearch, -2, 114, -2)).add((Component)this.spTab, -1, 689, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.bTabAction).addPreferredGap(0).add((Component)this.lSelectionInfo).addPreferredGap(1).add((Component)this.lWarning, -1, 631, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.tfSearch, -2, -1, -2).add((Component)this.lSearch).add((Component)this.topButton)).addPreferredGap(0).add((Component)this.spTab, -1, 46, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(4, false).add((Component)this.bTabAction).add((Component)this.lSelectionInfo, -1, -1, Short.MAX_VALUE).add((Component)this.lWarning)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.lSelectionInfo, this.lWarning}, 2);
        this.lSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_Search"));
        this.topButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTab.class, (String)"ACN_Reload"));
        this.topButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_Reload"));
    }

    private LocalDownloadSupport getLocalDownloadSupport() {
        return this.model instanceof LocallyDownloadedTableModel ? ((LocallyDownloadedTableModel)this.model).getLocalDownloadSupport() : null;
    }

    private RequestProcessor.Task reloadTask(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ((UnitTab)UnitTab.this).manager.initTask.waitFinished();
                UnitTab.this.setWaitingState(true);
                final int n = UnitTab.this.getSelectedRow();
                final Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                if (UnitTab.this.model instanceof LocallyDownloadedTableModel) {
                    ((LocallyDownloadedTableModel)UnitTab.this.model).removeInstalledUnits();
                    ((LocallyDownloadedTableModel)UnitTab.this.model).setUnits(null);
                }
                Utilities.presentRefreshProviders(UnitTab.this.manager, bl);
                List list = UpdateManager.getDefault().getUpdateUnits(Utilities.getUnitTypes());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UnitTab.this.fireUpdataUnitChange();
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                        UnitTab.this.restoreSelectedRow(n);
                        UnitTab.this.refreshState();
                        UnitTab.this.setWaitingState(false);
                    }
                });
            }
        };
        return Utilities.startAsWorkerThread(runnable);
    }

    private void showPopup(Point point, Component component) {
        int n = this.table.rowAtPoint(point);
        if (n >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
            JPopupMenu jPopupMenu = this.popupActionsSupport.createPopup();
            if (jPopupMenu != null && jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.show(component, point.x, point.y);
            }
        }
    }

    private int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    private void restoreSelectedRow(int n) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i >= 0; --i) {
            if (i >= this.table.getRowCount() || i <= -1) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    int findRow(String string) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Unit unit = this.model.getUnitAtRow(i);
            if (unit == null || !string.equals(unit.updateUnit.getCodeName())) continue;
            return i;
        }
        return -1;
    }

    static String textForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(UnitTab.class, (String)string));
        return jButton.getText();
    }

    static int mnemonicForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(UnitTab.class, (String)string));
        return jButton.getMnemonic();
    }

    private class ActivateAction
    extends RowTabAction {
        public ActivateAction() {
            super("UnitTab_ActivateAction", "EnableDisable");
        }

        protected boolean isEnabled(Unit unit) {
            Unit.Installed installed;
            boolean bl = false;
            if (unit != null && unit instanceof Unit.Installed && !(installed = (Unit.Installed)unit).getRelevantElement().isEnabled()) {
                bl = Unit.Installed.isOperationAllowed(unit.updateUnit, unit.getRelevantElement(), Containers.forEnable());
            }
            return bl;
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }

        public void performerImpl(Unit unit) {
            Unit.Installed installed = (Unit.Installed)unit;
            int n = UnitTab.this.getSelectedRow();
            if (!installed.getRelevantElement().isEnabled()) {
                OperationContainer.OperationInfo operationInfo = Containers.forEnable().add(installed.updateUnit, installed.getRelevantElement());
                assert (operationInfo != null);
                UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
                uninstallUnitWizard.invokeWizard(true);
                Containers.forEnable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        protected boolean isVisible(Unit unit) {
            return false;
        }
    }

    private class ActivateCategoryAction
    extends RowTabAction {
        public ActivateCategoryAction() {
            super("UnitTab_ActivateCategoryAction", "EnableDisable");
        }

        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                Unit.Installed installed;
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || (installed = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                bl = Unit.Installed.isOperationAllowed(installed.updateUnit, installed.getRelevantElement(), Containers.forEnable());
            }
            return bl;
        }

        protected String getContextName(Unit unit) {
            if (unit != null && unit instanceof Unit.Installed) {
                return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
            }
            return this.getActionName();
        }

        public void performerImpl(Unit unit) {
            Unit.Installed installed = (Unit.Installed)unit;
            int n = UnitTab.this.getSelectedRow();
            String string = installed.getCategoryName();
            int n2 = UnitTab.this.model.getRowCount();
            for (int i = 0; i < n2; ++i) {
                Unit.Installed installed2;
                Unit unit2 = UnitTab.this.model.getUnitAtRow(i);
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || (installed2 = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                OperationContainer.OperationInfo operationInfo = Containers.forEnable().add(installed2.updateUnit, installed2.getRelevantElement());
                assert (operationInfo != null);
            }
            if (Containers.forEnable().listAll().size() > 0) {
                UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
                uninstallUnitWizard.invokeWizard(true);
                Containers.forEnable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        protected boolean isVisible(Unit unit) {
            return this.isEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddLocallyDownloadedAction
    extends TabAction {
        public AddLocallyDownloadedAction() {
            super("UnitTab_bAddLocallyDownloads_Name", null);
            String string = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_AddAction_LOCAL");
            this.putValue("ToolTipText", string);
        }

        @Override
        public void performerImpl() {
            if (UnitTab.this.getLocalDownloadSupport().selectNbmFiles()) {
                final Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                Runnable runnable = new Runnable(){

                    public void run() {
                        LocallyDownloadedTableModel locallyDownloadedTableModel = (LocallyDownloadedTableModel)UnitTab.this.model;
                        List<UpdateUnit> list = Collections.emptyList();
                        locallyDownloadedTableModel.setUnits(list);
                        final Collection<UpdateUnit> collection = locallyDownloadedTableModel.getLocalDownloadSupport().getInstalledUpdateUnits();
                        locallyDownloadedTableModel.removeInstalledUnits();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                UnitTab.this.fireUpdataUnitChange();
                                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                                UnitTab.this.refreshState();
                                if (!collection.isEmpty()) {
                                    AddLocallyDownloadedAction.this.showMessage(collection);
                                }
                                UnitTab.this.setWaitingState(false);
                            }
                        });
                    }
                };
                UnitTab.this.setWaitingState(true);
                Utilities.startAsWorkerThread(runnable, 250);
            }
        }

        void showMessage(Collection<UpdateUnit> collection) {
            if (!collection.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (UpdateUnit updateUnit : collection) {
                    UpdateElement updateElement;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',').append(' ');
                    }
                    if ((updateElement = updateUnit.getInstalled()) != null) {
                        stringBuilder.append(updateElement.getDisplayName());
                        continue;
                    }
                    if (!updateUnit.getAvailableUpdates().isEmpty()) {
                        stringBuilder.append(((UpdateElement)updateUnit.getAvailableUpdates().get(0)).getDisplayName());
                        continue;
                    }
                    stringBuilder.append(updateUnit.getCodeName());
                }
                stringBuilder = collection.size() == 1 ? new StringBuilder(NbBundle.getMessage(UnitTab.class, (String)"NotificationOneAlreadyInstalled", (Object)stringBuilder.toString())) : new StringBuilder(NbBundle.getMessage(UnitTab.class, (String)"NotificationMoreAlreadyInstalled", (Object)stringBuilder.toString()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)stringBuilder.toString(), 1));
            }
        }
    }

    private class AvailableAction
    extends TabAction {
        public AvailableAction() {
            super("UnitTab_bTabAction_Name_AVAILABLE", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                bl = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.INSTALL);
            }
            finally {
                UnitTab.this.fireUpdataUnitChange();
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }
    }

    private class CheckAction
    extends RowTabAction {
        public CheckAction() {
            super("UnitTab_CheckAction", KeyStroke.getKeyStroke(32, 0), null);
        }

        public void performerImpl(Unit unit) {
            int n = UnitTab.this.getSelectedRow();
            if (UnitTab.this.model.isExpansionControlAtRow(n)) {
                if (UnitTab.this.moreAction != null && UnitTab.this.moreAction.isEnabled()) {
                    UnitTab.this.moreAction.performAction();
                } else if (UnitTab.this.lessAction != null && UnitTab.this.lessAction.isEnabled()) {
                    UnitTab.this.lessAction.performAction();
                }
            } else if (unit != null && unit.canBeMarked()) {
                unit.setMarked(!unit.isMarked());
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(Unit unit) {
            return unit != null && unit.canBeMarked();
        }

        protected boolean isEnabled(int n) {
            return UnitTab.this.model.isExpansionControlAtRow(n);
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }

        protected boolean isVisible(Unit unit) {
            return false;
        }

        protected boolean isVisible(int n) {
            return false;
        }
    }

    private class CheckAllAction
    extends RowTabAction {
        public CheckAllAction() {
            super("UnitTab_CheckAllAction", "Check");
        }

        public void performerImpl(Unit unit) {
            int n = UnitTab.this.getSelectedRow();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                if (unit2 == null || unit2.isMarked() || !unit2.canBeMarked()) continue;
                unit2.setMarked(true);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(Unit unit) {
            return true;
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class CheckCategoryAction
    extends RowTabAction {
        protected CheckCategoryAction(String string, KeyStroke keyStroke, String string2) {
            super(string, keyStroke, string2);
        }

        public CheckCategoryAction() {
            super("UnitTab_CheckCategoryAction", "Check");
        }

        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                if (unit2 == null || !string.equals(unit2.getCategoryName()) || unit2.isMarked()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        protected String getContextName(Unit unit) {
            return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
        }

        public void performerImpl(Unit unit) {
            String string = unit.getCategoryName();
            int n = UnitTab.this.model.getRowCount();
            int n2 = UnitTab.this.getSelectedRow();
            for (int i = 0; i < n; ++i) {
                unit = UnitTab.this.model.getUnitAtRow(i);
                if (unit == null || !string.equals(unit.getCategoryName()) || unit.isMarked() || !unit.canBeMarked()) continue;
                unit.setMarked(true);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n2);
        }

        protected boolean isVisible(Unit unit) {
            return super.isVisible(unit);
        }
    }

    private class DeactivateAction
    extends RowTabAction {
        public DeactivateAction() {
            super("UnitTab_DeactivateAction", "EnableDisable");
        }

        protected boolean isEnabled(Unit unit) {
            Unit.Installed installed;
            boolean bl = false;
            if (unit != null && unit instanceof Unit.Installed && (installed = (Unit.Installed)unit).getRelevantElement().isEnabled()) {
                bl = Unit.Installed.isOperationAllowed(unit.updateUnit, unit.getRelevantElement(), Containers.forDisable());
            }
            return bl;
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }

        public void performerImpl(Unit unit) {
            Unit.Installed installed = (Unit.Installed)unit;
            int n = UnitTab.this.getSelectedRow();
            if (installed.getRelevantElement().isEnabled()) {
                OperationContainer.OperationInfo operationInfo = Containers.forDisable().add(installed.updateUnit, installed.getRelevantElement());
                assert (operationInfo != null);
                UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
                if (uninstallUnitWizard.invokeWizard(false)) {
                    Containers.forUninstall().remove(installed.getRelevantElement());
                }
                Containers.forDisable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        protected boolean isVisible(Unit unit) {
            return false;
        }
    }

    private class DeactivateCategoryAction
    extends RowTabAction {
        public DeactivateCategoryAction() {
            super("UnitTab_DeactivateCategoryAction", "EnableDisable");
        }

        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                Unit.Installed installed;
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || !(installed = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                bl = Unit.Installed.isOperationAllowed(installed.updateUnit, installed.getRelevantElement(), Containers.forDisable());
            }
            return bl;
        }

        protected String getContextName(Unit unit) {
            if (unit != null && unit instanceof Unit.Installed) {
                return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
            }
            return this.getActionName();
        }

        public void performerImpl(Unit unit) {
            Unit.Installed installed = (Unit.Installed)unit;
            int n = UnitTab.this.getSelectedRow();
            String string = installed.getCategoryName();
            int n2 = UnitTab.this.model.getRowCount();
            for (int i = 0; i < n2; ++i) {
                Unit.Installed installed2;
                Unit unit2 = UnitTab.this.model.getUnitAtRow(i);
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || !(installed2 = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                OperationContainer.OperationInfo operationInfo = Containers.forDisable().add(installed2.updateUnit, installed2.getRelevantElement());
                assert (operationInfo != null);
            }
            if (Containers.forDisable().listAll().size() > 0) {
                UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
                uninstallUnitWizard.invokeWizard(false);
                Containers.forDisable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        protected boolean isVisible(Unit unit) {
            return this.isEnabled();
        }
    }

    private class EnableRenderer
    extends DefaultTableCellRenderer {
        private EnableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Boolean) {
                object2 = UnitTab.this.model.getUnitAtRow(n);
                if (object2 != null && ((Unit)object2).getRelevantElement().getUpdateUnit().isPending()) {
                    jLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/autoupdate/ui/resources/restart.png")));
                } else {
                    Boolean bl3 = (Boolean)object;
                    if (bl3.booleanValue()) {
                        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/autoupdate/ui/resources/active.png")));
                    } else {
                        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/autoupdate/ui/resources/inactive.png")));
                    }
                }
                jLabel.setText("");
                jLabel.setHorizontalAlignment(0);
            }
            object2 = jLabel;
            return object2;
        }
    }

    private class LessAction
    extends RowTabAction {
        public LessAction() {
            super("UnitTab_LessAction", "Expand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performerImpl(Unit unit) {
            try {
                UnitTab.this.setWaitingState(true);
                Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                UnitTab.this.model.setExpanded(false);
                UnitTab.this.fireUpdataUnitChange();
                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                UnitTab.this.focusTable();
            }
            finally {
                UnitTab.this.setWaitingState(false);
            }
        }

        protected boolean isVisible(Unit unit) {
            return this.isEnabled(unit);
        }

        protected boolean isVisible(int n) {
            return !UnitTab.this.model.isExpansionControlAtRow(n) && this.isEnabled(n);
        }

        protected boolean isEnabled(Unit unit) {
            return unit != null && UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isExpanded();
        }

        protected boolean isEnabled(int n) {
            return UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isExpanded();
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class LocalUpdateAction
    extends TabAction {
        public LocalUpdateAction() {
            super("UnitTab_bTabAction_Name_LOCAL", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                bl = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.LOCAL_DOWNLOAD);
            }
            finally {
                if (bl) {
                    UnitTab.this.reloadTask(false).schedule(10);
                } else {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                    UnitTab.this.restoreSelectedRow(n);
                    UnitTab.this.refreshState();
                }
                UnitTab.this.focusTable();
            }
        }
    }

    private class MoreAction
    extends RowTabAction {
        public MoreAction() {
            super("UnitTab_MoreAction", "Expand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performerImpl(Unit unit) {
            try {
                UnitTab.this.setWaitingState(true);
                Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                UnitTab.this.model.setExpanded(true);
                UnitTab.this.fireUpdataUnitChange();
                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                UnitTab.this.focusTable();
            }
            finally {
                UnitTab.this.setWaitingState(false);
            }
        }

        protected boolean isVisible(Unit unit) {
            return this.isEnabled(unit);
        }

        protected boolean isVisible(int n) {
            return !UnitTab.this.model.isExpansionControlAtRow(n) && this.isEnabled(n);
        }

        protected boolean isEnabled(Unit unit) {
            return unit != null && UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isCollapsed();
        }

        protected boolean isEnabled(int n) {
            return UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isCollapsed();
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class PopupActionSupport
    extends MouseAdapter {
        private final TabAction[] actions;

        PopupActionSupport(TabAction[] tabActionArray) {
            this.actions = tabActionArray;
        }

        void rowChanged(int n) {
            Unit unit = null;
            if (n > -1) {
                unit = UnitTab.this.model.getUnitAtRow(n);
            }
            for (TabAction tabAction : this.actions) {
                if (!(tabAction instanceof RowTabAction)) continue;
                RowTabAction rowTabAction = (RowTabAction)tabAction;
                rowTabAction.unitChanged(n, unit);
            }
        }

        void tableDataChanged() {
            Collection<Unit> collection = UnitTab.this.model.getMarkedUnits();
            for (TabAction tabAction : this.actions) {
                tabAction.tableDataChanged(collection);
            }
        }

        private JPopupMenu createPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.removeAll();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TabAction tabActionArray : this.actions) {
                String string = tabActionArray.getActionCategory();
                if (!hashSet.add(string)) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                int n = jPopupMenu.getSubElements().length > 0 ? 1 : 0;
                for (TabAction tabAction : this.actions) {
                    String string2 = tabAction.getActionCategory();
                    if ((string == null || !string.equals(string2)) && (string != null || string2 != null)) continue;
                    if (tabAction instanceof RowTabAction) {
                        RowTabAction rowTabAction = (RowTabAction)tabAction;
                        if (!rowTabAction.isVisible()) continue;
                        if (n != 0) {
                            n = 0;
                            jPopupMenu.addSeparator();
                        }
                        jPopupMenu.add(new JMenuItem(tabAction));
                        continue;
                    }
                    if (n != 0) {
                        n = 0;
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add(new JMenuItem(tabAction));
                }
            }
            return jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.maybeShowPopup(mouseEvent)) {
                int n = UnitTab.this.table.rowAtPoint(mouseEvent.getPoint());
                if (UnitTab.this.model.isExpansionControlAtRow(n)) {
                    UnitTab.this.moreAction.unitChanged(n, null);
                    UnitTab.this.lessAction.unitChanged(n, null);
                    if (UnitTab.this.moreAction != null && UnitTab.this.moreAction.isEnabled()) {
                        UnitTab.this.moreAction.performAction();
                    } else if (UnitTab.this.lessAction != null && UnitTab.this.lessAction.isEnabled()) {
                        UnitTab.this.lessAction.performAction();
                    }
                }
            }
        }

        private boolean maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                UnitTab.this.focusTable();
                UnitTab.this.showPopup(mouseEvent.getPoint(), mouseEvent.getComponent());
                return true;
            }
            return false;
        }
    }

    private class ReloadAction
    extends TabAction {
        RequestProcessor.Task reloadTask;

        public ReloadAction() {
            super("UnitTab_ReloadAction", KeyStroke.getKeyStroke(82, 128), null);
            this.reloadTask = null;
            String string = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_RefreshAction");
            this.putValue("ToolTipText", string);
            this.setEnabled(false);
        }

        public void performerImpl() {
            this.setEnabled(false);
            this.reloadTask = UnitTab.this.reloadTask(true);
        }
    }

    private class RemoveLocallyDownloadedAction
    extends RowTabAction {
        public RemoveLocallyDownloadedAction() {
            super("UnitTab_RemoveLocallyDownloadedAction", null);
            String string = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_RemoveAction_LOCAL");
            this.putValue("ToolTipText", string);
        }

        protected boolean isEnabled(Unit unit) {
            return unit != null && UnitTab.this.model.getType().equals((Object)UnitCategoryTableModel.Type.LOCAL);
        }

        public boolean isEnabled() {
            return UnitTab.this.table.getSelectedRow() > -1;
        }

        public void performerImpl(final Unit unit) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                    try {
                        if (unit.isMarked()) {
                            unit.setMarked(false);
                        }
                        UnitTab.this.getLocalDownloadSupport().remove(unit.updateUnit);
                        UnitTab.this.getLocalDownloadSupport().getUpdateUnits();
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(map){
                            final /* synthetic */ Map val$state;
                            {
                                this.val$state = map;
                            }

                            public void run() {
                                UnitTab.this.fireUpdataUnitChange();
                                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), this.val$state, UnitTab.this.model.isMarkedAsDefault());
                                UnitTab.this.refreshState();
                                UnitTab.this.setWaitingState(false);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            UnitTab.this.setWaitingState(true);
            Utilities.startAsWorkerThread(runnable, 250);
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }

        protected boolean isVisible(Unit unit) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RowTabAction
    extends TabAction {
        private Unit u;
        private int row;

        public RowTabAction(String string, String string2) {
            super(string, string2);
        }

        public RowTabAction(String string, KeyStroke keyStroke, String string2) {
            super(string, keyStroke, string2);
        }

        public void unitChanged(int n, Unit unit) {
            this.u = unit;
            this.row = n;
            this.unitChanged();
        }

        public final boolean isVisible() {
            return this.u != null ? this.isVisible(this.u) : this.isVisible(this.row);
        }

        private final void unitChanged() {
            if (this.u != null) {
                this.setEnabled(this.isEnabled(this.u));
                this.setContextName(this.getContextName(this.u));
            } else {
                this.setEnabled(this.isEnabled(this.row));
                this.setContextName(this.getContextName(this.row));
            }
        }

        @Override
        public void tableDataChanged() {
            this.unitChanged();
        }

        @Override
        public void tableDataChanged(Collection<Unit> collection) {
            this.unitChanged();
        }

        @Override
        public final void performerImpl() {
            this.performerImpl(this.u);
        }

        protected boolean isVisible(Unit unit) {
            return unit != null;
        }

        protected boolean isVisible(int n) {
            return false;
        }

        public abstract void performerImpl(Unit var1);

        protected abstract boolean isEnabled(Unit var1);

        protected boolean isEnabled(int n) {
            return false;
        }

        protected abstract String getContextName(Unit var1);

        protected String getContextName(int n) {
            return this.getActionName();
        }
    }

    class SourceCategoryRenderer
    extends DefaultTableCellRenderer {
        SourceCategoryRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof UpdateUnitProvider.CATEGORY && (object2 = UnitTab.this.model.getUnitAtRow(n)) instanceof Unit.Available) {
                Unit.Available available = (Unit.Available)object2;
                UpdateUnitProvider.CATEGORY cATEGORY = available.getSourceCategory();
                URL uRL = Utilities.getCategoryIcon(cATEGORY);
                jLabel.setIcon(new ImageIcon(uRL));
                jLabel.setText("");
                jLabel.setHorizontalAlignment(0);
            }
            object2 = jLabel;
            return object2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TabAction
    extends AbstractAction {
        private String name;
        private String actionCategory;

        public TabAction(String string, String string2) {
            super(UnitTab.textForKey(string));
            this.actionCategory = string2;
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey(string));
            this.name = (String)this.getValue("Name");
            this.putIntoActionMap(UnitTab.this.table);
        }

        public TabAction(String string, KeyStroke keyStroke, String string2) {
            this(string, string2);
            this.putValue("AcceleratorKey", keyStroke);
            this.putIntoActionMap(unitTab.table);
        }

        protected String getActionName() {
            return this.name;
        }

        public String getActionCategory() {
            return this.getActionCategoryImpl();
        }

        protected String getActionCategoryImpl() {
            return this.actionCategory;
        }

        protected void setContextName(String string) {
            this.putValue("Name", string);
        }

        public void putIntoActionMap(JComponent jComponent) {
            KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
            Object object = this.getValue("Name");
            if (keyStroke == null) {
                keyStroke = KeyStroke.getKeyStroke((Integer)this.getValue("MnemonicKey"), 18);
            }
            if (keyStroke != null && object != null) {
                jComponent.getInputMap(0).put(keyStroke, object);
                jComponent.getActionMap().put(object, this);
            }
        }

        public final void performAction() {
            if (this.isEnabled()) {
                this.actionPerformed(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            int n = UnitTab.this.getSelectedRow();
            this.performerImpl();
        }

        public void tableDataChanged() {
            this.tableDataChanged(UnitTab.this.model.getMarkedUnits());
        }

        public void tableDataChanged(Collection<Unit> collection) {
            this.setEnabled(collection.size() > 0);
        }

        public abstract void performerImpl();
    }

    private class UncheckAllAction
    extends RowTabAction {
        public UncheckAllAction() {
            super("UnitTab_UncheckAllAction", "Uncheck");
        }

        public void performerImpl(Unit unit) {
            int n = UnitTab.this.getSelectedRow();
            Collection<Unit> collection = UnitTab.this.model.getMarkedUnits();
            for (Unit unit2 : collection) {
                if (unit2 == null || !unit2.isMarked() || !unit2.canBeMarked()) continue;
                unit2.setMarked(false);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
        }

        protected boolean isEnabled(Unit unit) {
            return true;
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class UncheckCategoryAction
    extends RowTabAction {
        public UncheckCategoryAction() {
            super("UnitTab_UncheckCategoryAction", "Uncheck");
        }

        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                if (unit2 == null || !string.equals(unit2.getCategoryName()) || !unit2.isMarked()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public void performerImpl(Unit unit) {
            String string = unit.getCategoryName();
            int n = UnitTab.this.getSelectedRow();
            int n2 = UnitTab.this.model.getRowCount();
            for (int i = 0; i < n2; ++i) {
                unit = UnitTab.this.model.getUnitAtRow(i);
                if (unit == null || !string.equals(unit.getCategoryName()) || !unit.isMarked() || !unit.canBeMarked()) continue;
                unit.setMarked(false);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        protected boolean isVisible(Unit unit) {
            return super.isVisible(unit);
        }

        protected String getContextName(Unit unit) {
            return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
        }
    }

    private class UninstallAction
    extends TabAction {
        public UninstallAction() {
            super("UnitTab_bTabAction_Name_INSTALLED", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
            try {
                bl = uninstallUnitWizard.invokeWizard();
            }
            finally {
                Containers.forUninstall().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }
    }

    private class UpdateAction
    extends TabAction {
        public UpdateAction() {
            super("UnitTab_bTabAction_Name_UPDATE", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                bl = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.UPDATE);
            }
            finally {
                UnitTab.this.fireUpdataUnitChange();
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }
    }
}

