/*
 * Decompiled with CFR 0.152.
 */
package uk.co.wilson.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import uk.co.wilson.net.MinMLThreadPool;

public abstract class MinMLSocketServer
extends MinMLThreadPool {
    private final ServerSocket serverSocket;

    public MinMLSocketServer(ServerSocket serverSocket, int minWorkers, int maxWorkers, int workerIdleLife) {
        super(minWorkers, maxWorkers, workerIdleLife);
        this.serverSocket = serverSocket;
    }

    public synchronized void shutDown() throws IOException {
        this.serverActive = false;
        this.serverSocket.close();
    }

    public int getPortNumber() {
        return this.serverSocket.getLocalPort();
    }

    protected void setTimeout(int timeout) {
        try {
            this.serverSocket.setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected abstract class ServerSocketWorker
    extends MinMLThreadPool.Worker {
        protected ServerSocketWorker() {
            super(MinMLSocketServer.this);
        }

        protected Object getResource() throws IOException {
            return MinMLSocketServer.this.serverSocket.accept();
        }

        protected void dispose(Object resource) throws IOException {
            ((Socket)resource).close();
        }
    }
}

