/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SpringSessionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class JtaSessionSynchronization
implements Synchronization {
    private final SpringSessionSynchronization springSessionSynchronization;
    private final TransactionManager jtaTransactionManager;
    private boolean beforeCompletionCalled = false;

    public JtaSessionSynchronization(SpringSessionSynchronization springSessionSynchronization, TransactionManager jtaTransactionManager) {
        this.springSessionSynchronization = springSessionSynchronization;
        this.jtaTransactionManager = jtaTransactionManager;
    }

    public void beforeCompletion() {
        try {
            boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            this.springSessionSynchronization.beforeCommit(readOnly);
        }
        catch (Throwable ex) {
            SessionFactoryUtils.logger.error((Object)"beforeCommit callback threw exception", ex);
            try {
                this.jtaTransactionManager.setRollbackOnly();
            }
            catch (SystemException ex2) {
                SessionFactoryUtils.logger.error((Object)"Could not set JTA transaction rollback-only", (Throwable)ex2);
            }
        }
        this.beforeCompletionCalled = true;
        this.springSessionSynchronization.beforeCompletion();
    }

    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.springSessionSynchronization.beforeCompletion();
        }
        switch (status) {
            case 3: {
                this.springSessionSynchronization.afterCompletion(0);
                break;
            }
            case 4: {
                this.springSessionSynchronization.afterCompletion(1);
                break;
            }
            default: {
                this.springSessionSynchronization.afterCompletion(2);
            }
        }
    }
}

