/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class TemplateVisualPanel extends JPanel {

    private TemplateWizardPanel panel = null;
        
    /** Creates new form TemplateVisualPanel */
    public TemplateVisualPanel(TemplateWizardPanel panel) {
        this.panel = panel;
        initComponents();
        jList1.setModel(new DefaultListModel());
        jList1.setCellRenderer(new TemplateVisualPanel.FieldListCellRenderer());
        updateTemplates();
    }

    @Override
    public String getName() {
        return I18n.getString("TemplateVisualPanel.Name.Layout");
    }

    private void updateTemplates()
    {
        loadTemplates( getReportType() );
    }
    
    private void loadTemplates(String type)
    {
        
        jLabelPreview.setIcon(null);
        ((DefaultListModel)jList1.getModel()).clear();
        FileObject templatesFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("ireport/templates/" + type);
        if (templatesFileObject == null) return;
        DataFolder templatesDataFolder = DataFolder.findFolder(templatesFileObject);
        if (templatesDataFolder == null) return;
        
        Enumeration<DataObject> enObj = templatesDataFolder.children();
        while (enObj.hasMoreElements())
        {
            DataObject dataObject = enObj.nextElement();
            if (dataObject.getPrimaryFile().getExt() == null ||
                dataObject.getPrimaryFile().getExt().length() == 0)
            {
                ((DefaultListModel)jList1.getModel()).addElement(dataObject);
            }
        }
        
        if (((DefaultListModel)jList1.getModel()).getSize() > 0)
        {
            jList1.setSelectedIndex(0);
        }
        
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jLabelPreview = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton1, I18n.getString("TemplateVisualPanel.RadioButton.ColLayout")); // NOI18N
        jRadioButton1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton1StateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(50, 4, 0, 4);
        add(jRadioButton1, gridBagConstraints);

        buttonGroup1.add(jRadioButton2);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton2, I18n.getString("TemplateVisualPanel.RadioButton.TabLayout")); // NOI18N
        jRadioButton2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton2StateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        add(jRadioButton2, gridBagConstraints);

        jScrollPane1.setPreferredSize(new java.awt.Dimension(200, 120));

        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 4, 4, 4);
        add(jScrollPane1, gridBagConstraints);

        jLabelPreview.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelPreview.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 4, 4);
        add(jLabelPreview, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged
        
        jLabelPreview.setIcon(null);
        if (jList1.getSelectedIndex() >= 0)
        {
            DataObject dataObject = (DataObject)jList1.getSelectedValue();
            if (dataObject.getPrimaryFile().existsExt(I18n.getString("TemplateVisualPanel.List.Preview")))
            {
                FileObject previewFileObject = dataObject.getFolder().getPrimaryFile().getFileObject(dataObject.getName(), I18n.getString("TemplateVisualPanel.List.Preview"));
                if (previewFileObject != null)
                {
                    try {
                        // Get file object...
                        ImageIcon img = new ImageIcon(previewFileObject.getURL());
                        jLabelPreview.setIcon(img);
                        jLabelPreview.updateUI();
                    } catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                }
            }
        }
        
        
    }//GEN-LAST:event_jList1ValueChanged

    private void jRadioButton1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton1StateChanged
        updateTemplates();
    }//GEN-LAST:event_jRadioButton1StateChanged

    private void jRadioButton2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton2StateChanged
        updateTemplates();
    }//GEN-LAST:event_jRadioButton2StateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel jLabelPreview;
    private javax.swing.JList jList1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

    public String getReportType()
    {
        return jRadioButton1.isSelected() ? I18n.getString("TemplateVisualPanel.RadioButton.columnar") : I18n.getString("TemplateVisualPanel.RadioButton.tabular");
    }
    
    public FileObject getReportTemplate()
    {
        DataObject dataObject = (DataObject)jList1.getSelectedValue();
        return dataObject.getPrimaryFile();
    }
    
    
    static class FieldListCellRenderer extends DefaultListCellRenderer
    {

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        
            if (value instanceof DataObject)
            {
                value = ((DataObject)value).getName();
            }
           
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        
    }
}

