/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Image;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;

public class ImageConverter
extends ElementConverter {
    private static final ImageConverter INSTANCE = new ImageConverter();

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRImage image = (JRImage)element;
        this.copyGraphicElement(reportConverter, image, printImage);
        printImage.copyBox(image.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(image.getAnchorNameExpression()));
        printImage.setBookmarkLevel(image.getBookmarkLevel());
        printImage.setHorizontalAlignment(image.getOwnHorizontalAlignment());
        printImage.setLazy(image.isLazy());
        printImage.setLinkType(image.getLinkType());
        printImage.setOnErrorType(image.getOnErrorType());
        printImage.setVerticalAlignment(image.getOwnVerticalAlignment());
        printImage.setRenderer(this.getRenderer(image, printImage));
        printImage.setScaleImage(image.getOwnScaleImage());
        return printImage;
    }

    private JRRenderable getRenderer(JRImage imageElement, JRPrintImage printImage) {
        String location = JRExpressionUtil.getSimpleExpressionText(imageElement.getExpression());
        if (location != null) {
            try {
                byte[] imageData = JRLoader.loadBytesFromLocation(location);
                Image awtImage = JRImageLoader.loadImage(imageData);
                if (awtImage == null) {
                    printImage.setScaleImage((byte)1);
                    return JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/noimage.GIF", imageElement.getOnErrorType());
                }
                return JRImageRenderer.getInstance(imageData);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        try {
            printImage.setScaleImage((byte)1);
            return JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/noimage.GIF", imageElement.getOnErrorType());
        }
        catch (JRException e) {
            e.printStackTrace();
            return null;
        }
    }
}

